.TH NETDATA 1 "LOCAL"
.SH NAME
netdata \- produce CMS netdata file
.SH SYNOPSIS
netdata [-n <name> -t <type> -s <size> -u <orig_user> -d <dest_node> -v <dest_user> <file>]
.SH DESCRIPTION
Netdata converts a standard text file into CMS netdata format
and writes it to standard output
as a stream of 80-byte binary and EBCDIC card images.
This allows a text file with lines longer than 80 characters to be
"punched" to a CMS or TSO/E user.
If <file> is not specified, standard input is used.
The command line options are:
.TP 12
-n <name>
Specifies an internal file name for the CMS file.
The default is "MAILER".
.TP 12
-t <type>
Specifies an internal file type for the CMS file.
The default is "MAIL".
.TP 12
-s <size>
Specifies the approximate size of the file, for space allocation
purposes on the receiving system.
This option is only needed when the input is standard input.
The default is 2048 bytes.
.TP 12
-u <orig_user>
Specifies the origin user name.
The default is "MAILER".
.TP 12
-d <dest_node>
Specifies the destination node name.
The default is the local node.
.TP 12
-v <dest_user>
Specifies the destination user name.
The default is "MAILER".
.SH EXAMPLES
Send a file to user MAILER on node UOFMCC:
.ti+2n
netdata -d uofmcc hello.c | lp -db -o"-r -v uofmcc.mailer"
.SH SEE ALSO
lp(1), diskdump(1x)
.SH BUGS
Netdata will fold input lines longer than 253 characters.
It will not handle binary files.
The CMS file produced is always sequental and format V.
Specifying wrong destination node or user names may confuse the
receiving system.
The ASCII to EBCDIC translation may not conform to what is expected
on the receiving system.
