/* netdata.c:  convert text file to CMS	netdata	format	  */
/*	       output is a stream of 80-byte card images  */

/* Author:   Gary Mills	<mills@cc.uofm.cdn>		  */
/*			<mills@uofmcc.bitnet>		  */

/* Compilation Switches:				  */
/*	MVS:	Waterloo C v1.3	for MVS			  */
/*	default:  Amdahl UTS Unix System V		  */

/* #define MVS	   1 */
#include <stdio.h>
#include <time.h>
#ifdef	MVS
#define	ATE(c)	(c)
#else
#include <sys/types.h>
#include <sys/stat.h>
extern long time();
extern struct tm *gmtime();
extern char atetab[128];	/* ASCII to EBCDIC translation table */

#define	ATE(c)	atetab[c]
#endif
#define	NUL	'\0'
#define	TCAST	(long *)
#define	SIZBUF	254
#define	SIZREC	255
#ifdef	MVS
#define	ONODE	"UOFMCC"
#else
#define	ONODE	"UOFMCCX"
#endif

/* control record identifiers */
#define	INMR01	"INMR01"
#define	INMR02	"INMR02"
#define	INMR03	"INMR03"
#define	INMR06	"INMR06"

/* text	unit keys */
#define	INMLRECL 0x0042
#define	INMFNODE 0x1011
#define	INMFUID	 0x1012
#define	INMTNODE 0x1001
#define	INMTUID	 0x1002
#define	INMFTIME 0x1024
#define	INMNUMF	 0x102f
#define	INMSIZE	 0x102c
#define	INMDSORG 0x003c
#define	INMUTILN 0x1028
#define	INMRECFM 0x0049
#define	INMTERM	 0x0028
#define	INMDSNAM 0x0002
#define	INMFFM	 0x102d
#define	INMLCHG	 0x1021

static char	inbuf[SIZBUF];
static char	rec[SIZREC];
static char	tvalue[21];
#ifndef	MVS
static struct	stat sbuf;
#endif
static int	count;	/* output char count */
static FILE	*ofile;	/* output file */

char *acunit(),	*abunit(), *acfield(), *inirec(), *membin();

main(argc, argv) int argc; char	**argv;
    {
    int	n;
    char *pend,	*pstar;
    FILE *ifile;
    char c;
    char *ouser, *dnode, *duser;
    char *tcurr, *tlast;
    char *fname, *ftype, *pgm;
    int	fsize, maxl;
    long tbuf;
    struct tm *tpt;

#ifdef MVS
    tpt	= localtime();
#else
    tbuf = time( TCAST 0 );
    tpt	= gmtime(&tbuf);
#endif
    sprintf(tvalue, "%04d%02d%02d%02d%02d%02d%06d",
	tpt->tm_year+1900, tpt->tm_mon+1, tpt->tm_mday,
	tpt->tm_hour, tpt->tm_min, tpt->tm_sec,	0);
    tcurr = tlast = tvalue;
    ifile = stdin;
    ofile = stdout;
    ouser = duser = fname = "MAILER";
    dnode = ONODE;
    ftype = "MAIL";
    fsize = 0x0800;
    maxl = SIZBUF-1;

    pgm	= *argv++;
    --argc;
    while ( argc )
	{
	if ( **argv == '-' )
	    {
	    c =	tolower( (*argv)[1] );
	    ++argv;
	    --argc;
	    if ( argc )
		{
		--argc;
		if ( c == 'n' )
		    fname = *argv++;
		else if	( c == 't' )
		    ftype = *argv++;
		else if	( c == 'u' )
		    ouser = *argv++;
		else if	( c == 'd' )
		    dnode = *argv++;
		else if	( c == 'v' )
		    duser = *argv++;
		else if	( c == 's' )
		    fsize = atoi(*argv++);
		else
		    {
		    ++argc;
		    break;
		    }
		}
	    else
		{
		++argc;
		break;
		}
	    }
	else
	    {
	    if ( ( ifile = fopen(*argv,	"r") ) != NULL )
		{
#ifndef	MVS
		if ( 0 == fstat( fileno(ifile),	&sbuf) )
		    fsize = sbuf.st_size;
#endif
		}
	    else
		{
		fprintf(stderr,	"%s: cannot open %s\n",	pgm, *argv);
		return(1);
		}
	    --argc;
	    break;
	    }
	}
    if ( argc )
	{
	fprintf(stderr,	"usage:	%s [-n name -t type -u orig_user\n", pgm);
	fprintf(stderr,	"	-d dest_node -v	dest_user -s size file]\n");
	return(1);
	}
#ifdef MVS
    ofile = fopen("SYSUT2 ( bin", "w");
    if ( ofile == NULL )
	return 1;
#endif

    pend = inirec(rec, INMR01, -1);	/* header */
    pend = abunit(pend,	INMLRECL, 80, 2);
    pend = acunit(pend,	INMFNODE, ONODE);
    pend = acunit(pend,	INMFUID, ouser);
    pend = acunit(pend,	INMTNODE, dnode);
    pend = acunit(pend,	INMTUID, duser);
    pend = acunit(pend,	INMFTIME, tcurr);
    pend = abunit(pend,	INMNUMF, 1, 4);
    finrec(rec,	pend);

    pend = inirec(rec, INMR02, 1);	/* output utility */
    pend = abunit(pend,	INMSIZE, fsize,	8);
    pend = abunit(pend,	INMDSORG, 0x4000, 2);
    pend = abunit(pend,	INMLRECL, maxl,	4);
    pend = acunit(pend,	INMUTILN, "INMCOPY");
    pend = abunit(pend,	INMRECFM, 0x0002, 2);
    pstar = pend;
    pend = acunit(pend,	INMDSNAM, "A");
    pend = acfield(pend, fname);
    pend = acfield(pend, ftype);
    pstar[3] = 3;
    pend = acunit(pend,	INMFFM,	"1");
    pend = acunit(pend,	INMLCHG, tlast);
    finrec(rec,	pend);

    pend = inirec(rec, INMR03, -1);	/* input data */
    pend = abunit(pend,	INMSIZE, fsize,	8);
    pend = abunit(pend,	INMDSORG, 0x4000, 2);
    pend = abunit(pend,	INMLRECL, 80, 2);
    pend = abunit(pend,	INMRECFM, 0x0001, 2);
    finrec(rec,	pend);

    while ( n =	igets(ifile) )		/* data	records	*/
	{
	while (	n > 1 && inbuf[n-1] == ' ' )
	    --n;
	inbuf[n] = NUL;
	odata(n, inbuf);
	}

    pend = inirec(rec, INMR06, -1);	/* trailer */
    finrec(rec,	pend);

    finout();
    return 0;
    }

/* get input line, expanding tabs and padding null lines */
igets(fp) FILE *fp;
    {
    int	c, col;
    col	= 0;
    while ( ( c	= getc(fp) ) !=	EOF )
	{
	if ( c == '\t' )
	    do
		inbuf[col++] = ' ';
	    while ( col	< SIZBUF-1 && col % 8 );
	else if	( c == '\n' )
	    {
	    if ( col ==	0 )
		inbuf[col++] = ' ';
	    break;
	    }
	else
	    {
	    inbuf[col++] = c;
	    }
	if ( !(	col < SIZBUF-1 ) )
	    break;
	}
    inbuf[col] = NUL;
    return col;
    }

/* initialize control record */
char *inirec(pt, s, n) char *pt, *s; int n;
    {
    *pt++ = 0;		/* length bythe	*/
    *pt++ = 0xe0;	/* flag	byte */
    while ( *s )	/* identifier */
	*pt++ =	ATE( toupper(*s++) );
    if ( n > 0 )	/* number of files */
	pt = membin(pt,	n, 4);
    return pt;
    }

/* finalize control record */
finrec(pt, pe) char *pt, *pe;
    {
    *pt	= pe - pt;	/* length byte */
    while ( pt < pe )	/* record */
	{
	putc(*pt, ofile);
	++pt;
	++count;
	}
    }

/* add a binary	text unit */
char *abunit(pt, k, v, n) char *pt; int	k, v, n;
    {
    pt = membin(pt, k, 2);	/* key */
    pt = membin(pt, 1, 2);	/* count */
    pt = membin(pt, n, 2);	/* length */
    pt = membin(pt, v, n);	/* value */
    return pt;
    }

/* add a character text	unit */
char *acunit(pt, k, s) char *pt; int k;	char *s;
    {
    pt = membin(pt, k, 2);	/* key */
    pt = membin(pt, 1, 2);	/* count */
    pt = membin(pt, strlen(s), 2);	/* length */
    while ( *s )		/* value */
	*pt++ =	ATE( toupper(*s++) );
    return pt;
    }

/* add a character field */
char *acfield(pt, s) char *pt, *s;
    {
    pt = membin(pt, strlen(s), 2);	/* length */
    while ( *s )		/* value */
	*pt++ =	ATE( toupper(*s++) );
    return pt;
    }

/* add a binary	item */
char *membin(pt, v, n) char *pt; int v,	n;
    {
    char *pe;
    pe = pt + n;
    while ( --pe >= pt )
	{
	*pe = v;
	v = v /	256;
	}
    return pt +	n;
    }

/* write a data	record */
odata(n, pt) int n; char *pt;
    {
    char *pe;
    pe = pt + n;
    putc(n+2, ofile);  /* length byte */
    putc(0xc0, ofile); /* flag byte */
    count = count + 2;
    while ( pt < pe )	/* data	*/
	{
	putc(ATE(*pt), ofile);
	++pt;
	++count;
	}
    }

/* pad last record */
finout()
    {
    while ( count % 80 )
	{
	putc(0,	ofile);
	++count;
	}
    }

/**/
