/* diskdump.c:	convert	text file to CMS disk dump format */
/*		output is a stream of 80-byte card images */

/* Author:   Gary Mills	<mills@cc.uofm.cdn>		  */
/*			<mills@uofmcc.bitnet>		  */

/* Compilation Switches:				  */
/*	MVS:	Waterloo C v1.3	for MVS			  */
/*	default:  Amdahl UTS Unix System V		  */

/* #define MVS	   1 */
#include <stdio.h>
#ifdef	MVS
#define	ATE(c)	(c)
#else
extern char atetab[128];	/* ASCII to EBCDIC translation table */

#define	ATE(c)	atetab[c]
#endif
#define	NUL	'\0'
#define	SIZBUF	256
#define	CMSV	struct cmsrec
CMSV
    {
    char dd_id[1];	/* 0x02	*/
    char dd_cms[3];	/* "CMS" */
    char dd_fmt[1];	/* record format */
    char dd_data[50];	/* text	*/
    char dd_blk[2];	/* block count */
    char dd_fn[8];	/* file	name */
    char dd_ft[8];	/* file	type */
    char dd_fm[3];	/* file	mode */
    char dd_seq[4];	/* sequence */
    };

static char	inbuf[SIZBUF];
static CMSV	rec;
static int	recn, blkn;
static int	datax;
static FILE	*ofile;

main(argc, argv) int argc; char	**argv;
    {
    int	n, num,	max;
    char *inpt;
    FILE *ifile;
    char c;
    char *fname, *ftype, *pgm;

    ifile = stdin;
    ofile = stdout;
    fname = "mailer";
    ftype = "mail";
    pgm	= *argv++;
    --argc;
    while ( argc )
	{
	if ( **argv == '-' )
	    {
	    c =	tolower( (*argv)[1] );
	    ++argv;
	    --argc;
	    if ( argc )
		{
		--argc;
		if ( c == 'n' )
		    fname = *argv++;
		else if	( c == 't' )
		    ftype = *argv++;
		else
		    {
		    ++argc;
		    break;
		    }
		}
	    else
		{
		++argc;
		break;
		}
	    }
	else
	    {
	    if ( ( ifile = fopen(*argv,	"r") ) == NULL )
		{
		fprintf(stderr,	"%s: cannot open %s\n",	pgm, *argv);
		return(1);
		}
	    --argc;
	    break;
	    }
	}
    if ( argc )
	{
	fprintf(stderr,	"usage:	%s [-n name -t type file]\n", pgm);
	return(1);
	}
#ifdef	MVS
    ofile = fopen("SYSUT2 ( bin", "w");
#endif
    num	= max =	0;
    iniout(fname, ftype);
    while ( n =	igets(ifile) )
	{
	++num;
	while (	n > 1 && inbuf[n-1] == ' ' )
	    --n;
	inbuf[n] = NUL;
	if ( n > max )
	    max	= n;
	inpt = inbuf;
	oput(n/256);
	oput(n&255);
	while (	n = *inpt++ )
	    {
	    oput( ATE(n) );
	    }
	}
    finout(num,	max);
    if ( ifile != stdin	)
	fclose(ifile);
    return 0;
    }

/* get input line, expanding tabs and padding null lines */
igets(fp) FILE *fp;
    {
    int	c, col;
    col	= 0;
    while ( ( c	= getc(fp) ) !=	EOF )
	{
	if ( c == '\t' )
	    do
		inbuf[col++] = ' ';
	    while ( col	< SIZBUF-1 && col % 8 );
	else if	( c == '\n' )
	    {
	    if ( col ==	0 )
		inbuf[col++] = ' ';
	    break;
	    }
	else
	    {
	    inbuf[col++] = c;
	    }
	if ( !(	col < SIZBUF-1 ) )
	    break;
	}
    inbuf[col] = NUL;
    return col;
    }

/* initialize output */
iniout(sn, st) char *sn, *st;
    {
    recn = blkn	= 1;
    datax = 0;
    rec.dd_id[0] = 0x02;
    mncopy(rec.dd_cms, "CMS", 3);
    rec.dd_fmt[0] = ATE('V');
    memset(rec.dd_data,	0, 50);
    mhalf(rec.dd_blk, blkn);
    memset(rec.dd_fn, ATE(' '),	19);
    mncopy(rec.dd_seq, "0001", 4);
    mncopy(rec.dd_fn, sn, 8);
    mncopy(rec.dd_ft, st, 8);
    mncopy(rec.dd_fm, "A1", 3);
    }

/* finalize output */
finout(n, m) int n, m;
    {
    oflush();
    oflush();
    rec.dd_fmt[0] = ATE('N');
    mhalf(&rec.dd_data[0], n+1);	/* write pointer (number) */
    mhalf(&rec.dd_data[2], 1);		/* read	pointer	(number) */
    mncopy(&rec.dd_data[4], "A1", 2);	/* file	mode */
    mhalf(&rec.dd_data[6], n);		/* item	count (number) */
    rec.dd_data[10] = ATE('V');		/* variable flag */
    mhalf(&rec.dd_data[14], m);		/* max item length */
    mhalf(&rec.dd_data[16], blkn);	/* number of blocks */
    mhalf(&rec.dd_data[26], blkn);	/* alternate number of blocks */
    mhalf(&rec.dd_data[30], n);		/* alternate item count	*/
    oflush();
    }

/* add a byte to output	*/
oput(c)	char c;
    {
    rec.dd_data[datax++] = c;
    if ( datax >= 50 )
	{
	oflush();
	datax =	0;
	}
    }

/* write and re-initialize record */
oflush()
    {
    int	n, r;
    for	( n = 0; n < 80; ++n )
	putc(rec.dd_id[n], ofile);
    memset(rec.dd_data,	0, 50);
    if ( recn %	16 == 0	)
	++blkn;
    ++recn;
    mhalf(rec.dd_blk, blkn);
    r =	recn;
    for	( n = 3; n >= 0; --n )
	{
	rec.dd_seq[n] =	ATE(r %	10 + '0');
	r = r /	10;
	}
    }

/* copy	string to memory in upper case,	not including NUL */
mncopy(s1, s2, n) char *s1, *s2; int n;
    {
    while ( --n	>= 0 &&	*s2 )
	*s1++ =	ATE( toupper(*s2++) );
    }

/* copy	two-byte integer to memory */
mhalf(s, n) char *s; int n;
    {
    s[0] = n/256;
    s[1] = n&255;
    }

/**/
