
/************************************************************************
 *									*
 * 	Background File Transfer Program (BFTP)				*
 *									*
 *	Written at USC/Information Sciences Institute			*
 *	September, 1988							*
 *									*
 *      BFTP is Public Domain, and may be used for any purpose as	*
 *      long as this notice is not removed.  USC-ISI does not assume	*
 *	any responsibility for the correctness, performance, or use	*
 *	of this software.						*
 *									*
 ************************************************************************/
/*
 *	bftp_req.c
 *
 *	These routines are used in "bftp" and "bftptool", user interface
 *	modules, and also in "fts", the file transfer driver.  Included
 *	are routines which read and write a standard BFTP request file.
*/

#include <stdio.h>
#include <errno.h>
#include <strings.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/timeb.h>
#include "time.h"
	  
#include "bftp.h"

#define endof(x) (x + strlen(x))

char *expand_stru(c)
   char c;
{
   return( (c == 'F')? "file":
   	   (c == 'R')? "record":
	   (c == 'P')? "page":
	   	       "unknown");
}
char *expand_mode(c)
   char c;
{
   return( (c == 'S')? "stream":
   	   (c == 'B')? "block":
	   (c == 'C')? "compress":
	   	       "unknown");
}
char *expand_type(c)
   char c;
{
   return( (c == 'A')? "ascii":
   	   (c == 'E')? "ebcdic":
	   (c == 'I')? "image":
	   (c == 'L')? "local":
	   	       "unknown");
}
char *expand_form(c)
   char c;
{
   return( (c == 'N')? "nonprint":
   	   (c == 'T')? "telnet":
	   (c == 'C')? "carriage-control":
	   	       "unknown");
}

boolean
get_id(id, filename)
   char *id, *filename;
{
   char *temp, *dot;

   if ((temp = rindex(filename, '/')) == NULL)
      temp = filename;
   else 
      temp++;
   if (strlen(temp) == 0)
      return(FALSE);
   else {
      strcpy(id, temp);
      if ((dot = rindex(temp, '.')) != NULL) {
         dot = rindex(id, '.');
	 *dot = '\0';
	 }
      return(TRUE);
      }
} /* get_id */

void
name_dotfile(file, dotfile)
   char *file, *dotfile;
{
   int len;
   char *cp;

   if (strlen(file))
      if ((cp = rindex(file, '/')) != NULL) {
	 len = strlen(file) - strlen(cp) + 1;
	 strncpy(dotfile, file, len);
	 dotfile[len] = '\0';
	 strcat(dotfile, ".");
	 strcat(dotfile, ++cp);
         }
      else {
	 strcpy(dotfile, ".");
	 strcat(dotfile, file);
         }
   else
      dotfile[0] = '\0';

} /* name_dotfile */

int
find_job(reqfile)
   char *reqfile;
{
   FILE *stream;
   char temp[80];
   int jobno = 0;
   
   strcpy(temp, "atq | grep ");
   if (get_id(endof(temp), reqfile))
      if (stream = popen(temp,"r")) {
         if (fgets(temp,sizeof(temp),stream))
	    sscanf(temp, "%*s %*s %*d, %*d %*d:%*d %*s %d",&jobno);
	 pclose(stream);
         }
   return(jobno);
} /* find_job */

void
cancel_job(jobno)
   int jobno;
{
   char temp[80];

   if (jobno) {
      sprintf(temp, "atrm %d 1> /dev/null 2>&1",jobno);
      system(temp);
      }
}

boolean
print_req(out, req,src,dst,file, verbose)
   FILE *out;
   struct reqinfo *req;
   struct hostinfo *src, *dst;
   struct fileinfo *file;
   int verbose;
{
   char *cp;

   fprintf(out,"    Request type: %s\n",
		(file->reqtype==COPY)?"COPY":
		(file->reqtype==MOVE)?"MOVE":
		(file->reqtype==DFILE)?"DFILE":
		(file->reqtype==VERIFY)?"VERIFY":
		(file->reqtype==VERIFY_SRC)?"VERIFY_SRC":
		"unknown");
   if (verbose) {
      fprintf(out,"\n");
      fprintf(out,"    Source --\n");
      fprintf(out,"\tHost: '%s'\n", src->host);
      fprintf(out,"\tUser: '%s'\n", src->user);
      fprintf(out,"\tPass: %s\n", (strlen(src->passwd)==0) ? "NOT SET": "SET");
      fprintf(out,"\tAcct: '%s'\n", src->acct);
      fprintf(out,"\tDir: '%s'\n", src->dir);
      fprintf(out,"\tFile: '%s'\n", src->file);
      fprintf(out,"\tPort: %d\n", src->port);
    if ((file->reqtype != VERIFY_SRC) && (file->reqtype != DFILE)) {
	fprintf(out,"\n");
	fprintf(out,"    Destination --\n");
	fprintf(out,"\tHost: '%s'\n", dst->host);
	fprintf(out,"\tUser: '%s'\n", dst->user); 
	fprintf(out,"\tPass: %s\n",(strlen(dst->passwd)==0) ? "NOT SET": "SET");

	fprintf(out,"\tAcct: '%s'\n", dst->acct);
	fprintf(out,"\tDir: '%s'\n", dst->dir);
	if (! file->multflag)
	   fprintf(out,"\tFile:'%s'\n", dst->file);
	fprintf(out,"\tPort: %d\n", dst->port);
	};
    fprintf(out,"\n");
    if ((file->reqtype != DFILE) && (file->reqtype != VERIFY_SRC)) {
       if (file->creation != STOR)
          fprintf(out,"    Creation: %s\n",
    		(file->creation == APPE) ? "appending to existing file":
		"using STOU command");
       fprintf(out,"    %s%s", "Structure: ", expand_stru(file->stru));
       cp = file->filetype;
       fprintf(out,"%s%s%s%s", ", Mode: ", expand_mode(file->mode), 
	  		     ", Type: ", expand_type(*cp));
       switch (*cp) {
             case 'L':
	        cp = cp + 2;
		fprintf(out,"%s%s",", Byte size: ", cp);
		break;
	     case 'A':
	     case 'E':
	        cp = cp + 2;
		fprintf(out,"%s%s",", Format: ", expand_form(*cp));
		break;
	     }
       fprintf(out,"\n");
       };
      }
   else { /* not verbose */
      fprintf(out,"    Source: %s,%s,XXX,%s,%d,%s,%s\n",
   	   src->host, src->user, src->acct, src->port, src->dir, src->file);
      if ((file->reqtype != VERIFY_SRC) && (file->reqtype != DFILE)) {
	 fprintf(out,"    Destination: %s,%s,XXX,%s,%d,%s,%s\n",
	   dst->host, dst->user, dst->acct, dst->port, dst->dir, dst->file);
	 fprintf(out,"    Stru: %c",file->stru);
	 fprintf(out,", Mode: %c, Type: %s", file->mode, file->filetype);
	 fprintf(out,", Creation: %s\n",
			(file->creation==APPE)?"APPE":
			(file->creation==STOU)?"STOU":
			"STOR");
	 }
      }
    
   fprintf(out,"    Multiple matching: %s", 
   			(file->multflag)?"TRUE": "FALSE");
   if ((file->reqtype != VERIFY) && (file->reqtype != VERIFY_SRC)) {
      fprintf(out, ", Return mailbox: '%s'\n", req->mailbox);
     fprintf(out,"    Remaining tries: %d, Current retry interval: %d minutes",
      		req->ntries, req->interval);
      }
   fprintf(out,"\n\n");

} /* print_req */
	

void
format_time(t, tstr)
   time_t t;
   char *tstr;
{
   struct timeb tp;
   struct tm *tmP;

   ftime(&tp);
   tmP = localtime((t)? &t: &tp.time);
	
   strcpy(tstr, asctime(tmP) + 4);
   /* Note: the previous localtime() call has magical properties that 
      make the upcoming timezone call work right! */
   sprintf(tstr+strlen(tstr)-1, " %s", timezone(tp.timezone, tmP->tm_isdst));
}

void
queue_req(req, timeval, out)
   struct reqinfo *req;
   long timeval;
   char *out;
{
   char temp[80],tmp1[30], tmp2[20], tmp3[20];

#ifdef SUNOS4
   if (time(NULL) > (timeval-30))
      sprintf(temp, "at -s now + 1 minute %s 1> /dev/null 2>&1", req->cmdfile);
   else
#endif   
      {
      strcpy(temp,ctime(&timeval));
      temp[strlen(temp)-1] = 0;
      sscanf(temp,"%*s%s%s%s",tmp1,tmp2,tmp3);
         /* Tue Apr 28 14:20:18 1987  is example of format */
      tmp3[strlen(tmp3)-3] = 0;
      sprintf(temp, "at -s %s %s %s %s 1> /dev/null 2>&1", 
      		tmp3, tmp1, tmp2, req->cmdfile);
      }
   system(temp);

   if (out != NULL) {
      get_id(temp, req->cmdfile);
      format_time(timeval, tmp1);
      sprintf(out, "Request %s submitted to run at %s.", temp, tmp1);
      }
}

void
finish_req(reqfile, req, subject, multlist)
   char *reqfile;
   struct reqinfo *req;
   char *subject, *multlist;
{
   char id[80], temp[200];
   
   /* send the results message */ 
   if (strlen(req->mailbox)!=0 && strlen(req->mailfile)!=0) {
      if (!subject)
	 get_id(id, reqfile);
      sprintf(temp,"%s -s \"BFTP Results: %s\" %s < %s\n", 
      		   MAILPATH, (subject)?subject : id, 
		   req->mailbox,req->mailfile);
      system(temp); 
      }
	       
   /* delete the request files */      
   sprintf(temp,"rm %s %s %s %s 1> /dev/null 2>&1\n", 
   		req->mailfile, req->cmdfile, reqfile, multlist);

   system(temp);
}

boolean
read_req(filename,req,src,dst,file,multlist)
   char *filename;
   struct reqinfo *req;
   struct hostinfo *src, *dst;
   struct fileinfo *file;
   char *multlist;   
{
   FILE *rfile;
	
   if ((rfile = fopen(filename,"r")) == NULL)
      return(FALSE);
      
   bzero((char *)src, sizeof(struct hostinfo));
   bzero((char *)dst, sizeof(struct hostinfo));
   bzero((char *)req, sizeof(struct reqinfo));
   bzero((char *)file, sizeof(struct fileinfo));

   if ((5 == fscanf(rfile,"%[^\n] %[^\n] %[^\n] %[^\n] %d ",
 		req->rpasswd, req->mailbox, req->mailfile, 
		req->cmdfile, &file->reqtype)) &&
       (7 == fscanf(rfile,"%[^\n] %[^\n] %[^\n] %[^\n] %hd %[^\n] %[^\n] ",
   		src->host, src->user, src->passwd,
		src->acct, &src->port, src->dir, src->file)) &&
       (7 == fscanf(rfile,"%[^\n] %[^\n] %[^\n] %[^\n] %hd %[^\n] %[^\n] ",
   		dst->host, dst->user, dst->passwd,
		dst->acct, &dst->port, dst->dir, dst->file)) &&
       (7 == fscanf(rfile,"%[^\n] %c %c %d %d %d %d ",
   		file->filetype, &file->stru, &file->mode, &file->creation,
		&file->multflag, &req->ntries, &req->interval)))
      {
      if (file->multflag) {
         if (fscanf(rfile,"%[^\n]",multlist) != 1)
            multlist[0] = '\0';
	 }
      else
         multlist[0] = '\0';
      }
   fclose(rfile);
   return(TRUE);
}

void
put_string(fptr,sptr)
   FILE *fptr;
   char *sptr;
{
   if (strlen(sptr))
      fprintf(fptr,"%s\n", sptr);
   else
      fprintf(fptr,"%c\n", '\0');
}

boolean
write_req(filename,req,src,dst,file,multlist)
   char *filename;
   struct reqinfo *req;
   struct hostinfo *src, *dst;
   struct fileinfo *file;
   char *multlist;
{
   FILE *rfile;
   
   if (!(rfile = fdopen(open(filename,(O_WRONLY|O_CREAT),0600),"w")))
/*   if ((rfile = fopen(filename,"w")) == NULL) */
      return(FALSE);
      
   put_string(rfile,req->rpasswd);
   put_string(rfile,req->mailbox);
   put_string(rfile,req->mailfile);
   put_string(rfile,req->cmdfile);
   fprintf(rfile, "%d\n",file->reqtype);
   put_string(rfile, src->host);
   put_string(rfile, src->user);
   put_string(rfile, src->passwd);
   put_string(rfile, src->acct);
   fprintf(rfile, "%d\n",src->port);
   put_string(rfile, src->dir);
   put_string(rfile, src->file);
   put_string(rfile, dst->host);
   put_string(rfile, dst->user);
   put_string(rfile, dst->passwd);
   put_string(rfile, dst->acct);
   fprintf(rfile, "%d\n",dst->port);
   put_string(rfile, dst->dir);
   put_string(rfile, (file->multflag)? "" : dst->file);
   
   put_string(rfile, file->filetype);
   fprintf(rfile, "%c\n%c\n%d\n%d\n%d\n%d\n",
		file->stru,file->mode,file->creation,file->multflag, 
		req->ntries,req->interval);
   put_string(rfile, (multlist)? multlist: "");
   fclose(rfile);
	   
   return(TRUE);
}

void
unpack_filetype(ftype, type, form, bsize)
   char *ftype;
   int *type, *form, *bsize;
{
   char *cp = NULL;
   *type = (*ftype == 'A')? ASCII :
   	  (*ftype == 'E')? EBCDIC :
	  (*ftype == 'I')? IMAGE :
	  (*ftype == 'L')? LOCAL : NOTYPE;
	 
   switch (*type) {
      case ASCII:
      case EBCDIC:
         if (strlen(ftype)==3) {
	    cp = ftype + 2;
	    *form = (*cp == 'N')? NONPRINT :
	    	   (*cp == 'C') ? CCNTRL :
		   (*cp == 'T')? TELNET : NOFORM;
	    }
	 else
	    *form = NOFORM;
	 *bsize = DEFAULT_BYTESZ;
         break;
      case IMAGE:
      case NOTYPE:
         *form = NONPRINT;
	 *bsize = DEFAULT_BYTESZ;
         break;
      case LOCAL:
         if (strlen(ftype) > 2) {
	    cp = ftype + 2;
	    *bsize = atoi(cp);
	    }
	 else
	    *bsize = DEFAULT_BYTESZ;
	 *form = NONPRINT;
         break;
      }
} /* unpack_filetype */
