/************************************************************************
 *									*
 * 	Background File Transfer Program (BFTP)				*
 *									*
 *	Written at USC/Information Sciences Institute			*
 *	September, 1988							*
 *									*
 *      BFTP is Public Domain, and may be used for any purpose as	*
 *      long as this notice is not removed.  USC-ISI does not assume	*
 *	any responsibility for the correctness, performance, or use	*
 *	of this software.						*
 *									*
 ************************************************************************/
/*
 *	bftp_share.c
 *
 *	These global variables and routines are are common to the "bftp", 
 *	tty-style user interface, and the "bftptool", SunView user interface.
*/

#include <stdio.h>
#include <ctype.h>
#include <strings.h>
#include <string.h>
#include <time.h>
#include <sys/param.h>
#include "bftp.h"

extern char
	**environ,
	*getenv(),
        *getlogin(),
	*malloc();

char bftp_dir[MAXPATHLEN],
#ifdef BSD4_3
     def_user[10],
#else
     def_user[L_cuserid],
#endif
     def_hostname[80],
     def_mailbox[101],
     *ptrs[MAX_SAVES+1];

FILE *listp = NULL;     
char filename[100];
     
u_long start = 0;     
     
struct hostinfo src, 
		dst,
		nullhost = {"","","","","","",DEFAULT_PORT};
struct fileinfo fil,
		defaultfile = {"A N",'F','S',COPY,STOR,FALSE};
struct reqinfo  nullreq = {"","","","",0,0};

char *version = "Version 3.12  6/29/90";	
	
char *introduction = "\n\
Introduction:\n\
\n\
  This Background File Transfer program may be used to submit a request\n\
  to have a file transfered at some time in the future.\n\
\n";
  
char *background = "\n\
Additional background information on how BFTP works:\n\
\n\
  BFTP makes use of third party FTP, so the source and the destination\n\
  hosts do not have to be operational at the time that the request is\n\
  submitted.  Transfers are scheduled locally via the system 'at' command.\n\
  Therefore the exact time that a file tranfer will take place depends on\n\
  how often jobs are run from the system 'at' queue; for more details, see\n\
  the system manual pages for 'at', 'cron', and 'crontab'.\n\
\n\
  For a transfer to succeed, either the source or the destination host must\n\
  support the FTP passive command.  (4.2BSD doesn't, 4.3BSD does!)\n\
\n\
  To set the directory where BFTP stores request files to something other\n\
  than ones home directory, exit this program and use the system 'setenv'\n\
  command, for example 'setenv BFTPDIR ~deschon/.bftp'.\n\
\n\
Please report bugs to Annette DeSchon <deschon@isi.edu>, 213-822-1511.\n\
\n";

void
close_listp()
{
   if (listp) {
      pclose(listp);
      listp = NULL;
      }
}
	
char *	
get_request_file(password)
   char *password;
{
   char temp[MAXPATHLEN*2];
	
   if (!listp) {
      sprintf(temp,"grep -l '^%s' *.req /dev/null 2> /dev/null\n", password);
      listp = popen(temp,"r");
      getwd(temp);
      }
   if (!listp)
      return(NULL);
   else 
      if (EOF != fscanf(listp,"%s",filename)) {
         return(filename);
	 }
      else {
	 close_listp();
	 return(NULL);
         }
}	

void
init_req(req)
   struct reqinfo *req;
{
   *req->rpasswd = '\0';
   strcpy(req->mailbox, def_mailbox);
   *req->mailfile = '\0';
   *req->cmdfile = '\0';
   req->interval = 15;
   req->ntries = 5;
}
	
void 
init_user()
{
   char *cp;
	
#ifdef BSD4_3
   if ((cp = getlogin()) != NULL)
      strcpy(def_user, cp);
   else
      def_user[0] = '\0';
#else
   (void)cuserid(def_user);
#endif
   if (strlen(def_user))
      sprintf(def_mailbox, "%s@%s", def_user, SITESTR);
   else
      def_mailbox[0] = '\0';

   if ((cp = getenv("BFTPDIR")) == NULL) {
      if ((cp = getenv("HOME")) == NULL)
         cp = ".";
      /* make sure that the directory exists */	 
      if (chdir(cp) < 0) {
	 fprintf(stderr,"bftp: Directory does not exist: %s\n",cp);
	 fprintf(stderr,"Check environment variables BFTPDIR and HOME.\n");
	 exit(1);
         }
      strcpy(bftp_dir, cp);
      if (bftp_dir[strlen(bftp_dir)-1] != '/')
         strcat(bftp_dir, "/");
      }
   else {
      /* make sure that the directory exists */	 
      if (chdir(cp) < 0) {
	 strcpy(bftp_dir, getenv("HOME"));
	 if (bftp_dir[strlen(bftp_dir)-1] != '/')
	    strcat(bftp_dir, "/");
	 strcat(bftp_dir, cp);
	 if (bftp_dir[strlen(bftp_dir)-1] != '/')
	    strcat(bftp_dir, "/");
	 if (chdir(bftp_dir) < 0) {
	    fprintf(stderr,"bftp: Directory does not exist: %s\n",cp);
	    fprintf(stderr,"Check environment variables BFTPDIR and HOME.\n");
	    exit(1);
            }
         }
      else {
         strcpy(bftp_dir, cp);
	 if (bftp_dir[strlen(bftp_dir)-1] != '/')
	    strcat(bftp_dir, "/");
         }
      }
   
   gethostname(def_hostname, sizeof(def_hostname));
} /* init_user */

char **
get_save_files()
{
   FILE *listp;
   int tmp, i = 0, len;
   char prefix[80], temp[80], filename[80];
   
   sprintf(prefix,"%s.", SAVEPREFIX);
   len = strlen(prefix);
   sprintf(temp,"ls -1 %s* 2>/dev/null\n", prefix);
   if (listp = popen(temp,"r")) {
      for (tmp = fscanf(listp,"%s",filename);
      	   tmp != EOF && i<MAX_SAVES;
      	   tmp = fscanf(listp,"%s",filename), i++) {
	 if (!strncmp(prefix,filename, len)) {
	    ptrs[i] = malloc(strlen(filename+len));	
	    strcpy(ptrs[i], filename+len);
	    }
	 else
	    break;
	 }
      pclose(listp);
      }
   ptrs[i] = NULL;
   return(ptrs);
}

void
cancel_msg(reqfile, req, filename, listfile)
   char *reqfile;
   struct reqinfo *req;
   char *filename, *listfile;
{
   FILE *msgfp;
   int jobno;
   char temp[100], subject[100];

   format_time(0, temp);
   if ((strlen(req->mailfile)!=0) && 
       ((msgfp = fopen(req->mailfile,"a")) != NULL)) {
	fprintf(msgfp,"\n  %s: request cancelled.\n",temp);
	fclose(msgfp);
	}
   /* dequeue it from atq */
   if (jobno = find_job(reqfile)) {
      sprintf(temp, "atrm %d 1> /dev/null 2>&1",jobno);
      system(temp);
      }
      
   sprintf(temp, "%s -- Cancelled", filename);
   if (!strlen(listfile)) {
      get_id(listfile,reqfile);
      strcat(listfile,".list");
      }
   finish_req(reqfile, req, temp, listfile);
      
} /* cancel_msg */

boolean
request_queued(filename)
   char *filename;
{
   FILE *atqfp;
   char temp[100], id[20];
   boolean found = FALSE;
   
   get_id(id, filename);
   
   /* grep atq results to see whether this request is there */
   sprintf(temp,"atq | grep %s", id);
   if (atqfp = popen(temp,"r")) {
      found = (fgets(temp, sizeof(temp), atqfp))? TRUE:FALSE;
      pclose(atqfp);
      }

   return(found);
}

boolean	   
empty_str(xxx)
    char *xxx;
{
    char *pch;
    
    if (!strlen(xxx))
    	return(TRUE);
    for (pch = xxx;*pch && isspace(*pch);pch++) ;
    return((!*pch)?TRUE:FALSE);
}

boolean
mailbox_ok(name,errorstr)
   char *name;
   char *errorstr;
{
   char *cp;
	
   if ((cp = index(name, '@')) == NULL) {
      if (errorstr)
	 strcpy(errorstr, "Mailbox format is 'person@host'.\n");
      return(FALSE);
      }
   if (! gethostbyname(++cp)) {
      if (errorstr)
	 sprintf(errorstr, "Illegal host name in mailbox: '%s'\n", cp);
      return(FALSE);
      }

   if (errorstr) errorstr[0] = '\0';
   return(TRUE);
}

boolean
parse_date(dp, tdate)
   char *dp;
   time_t *tdate;		/* parsed date and time */
{
    struct tm datetm;

    /*
      parsedate (str, tmp, settm, select, err, gmt)
      		 char *str;
		 struct tm *tmp;
		 int settm, select, err;
		 long *gmt;
    */     

    if (parsedate(dp, &datetm, TRUE, FALSE, TRUE, tdate) < 0)
       return(FALSE);

    return(TRUE);
} /* parse_date */
