/*
 * ftpget.c by Mingqi Deng, July 6, 1989
 *
 *    makes one attempt to get a file from a remote host.
 *
 *  Compile:  
 *             cc -o ftpget ftpget.c
 *  Execute:
 *             ftpget alarm remotehost ftp_script
 *    where
 *      alarm      :- the number in seconds that an ftp attempt can last
 *      ftp_script :- ftp command script created by nextfile.c
 *
 *  Example:   
 *             ftpget 3600 wsmr-simtel20.army.mil 123ftp_script
 *  Note   : 
 *    1. The maximum number of characters contained on ftpget's command
 *       line is defined in the constant ftpget_cmd_line_length. The
 *       default is 160.
 *    2. The host name is assumed to have no more than 80 characters. 
 *       Adjust the constant hostname_length if necessary.
 */

#include <stdio.h>
#include <signal.h>

int id,pgid,mask;

#define ftpget_cmd_line_length     160
#define hostname_length             80

main(argc, argv)
int argc;
char *argv[];
{
  unsigned t_alarm;
  char cmd[ftpget_cmd_line_length+1];
  void  handler();
  FILE *f;

  if (argc != 3) {
     fprintf(stderr,"***Type 'ftpget alarm ftp.script' to run\n");
     exit(99);
  }
		/* check if file ftp_script exists. */
  f = fopen(argv[2],"r");
  if (f == NULL) {
     fprintf(stderr,"***Ftp script file '%s' does not exist.\n",argv[2]);
     exit(99);
  }
  fclose(f);

  sscanf(argv[1],"%u",&t_alarm);
  if (t_alarm < 300) { 
     fprintf(stderr,"***'alarm'(= %d < 300) in autoftp30.sh too small!\n",t_alarm);
     exit(99);
  }

  mask=sigsetmask(0);   /* do not block any signals */
  id=getpid();  pgid=getpgrp(id);   /* get process group id */
  setpgrp(id,pgid+1);   /* modify process group id so that only this 
			   and all of its subprocesses (with this id)
			   can be terminated by a signal */
  signal(SIGALRM,handler);  /* catch the alarm signal and use procedure
				"handler" to process it */
             /* create a command "ftp remotehost < ftp_script" to
                be run in current shell (instead of a subshell)*/
  sprintf(cmd,"exec ftp -n < '%s'",argv[2]);

  alarm(t_alarm);   /* timing the system call next: send a SIGALRM 
			signal to the current process after t_alarm 
			many seconds */
  system(cmd);      /* execute "ftp remotehost < ftp_script" */
  alarm(0);         /* stop the alarm if "cmd" ends before the alarm
			call*/
}

/* SIGALRM signal handling */
void handler()
{
   fprintf(stderr,"Alarm call!\n");
   killpg(pgid+1,SIGHUP);  /* kill the current process and its
				subprocess (ftp ....) */
   exit(5);
}
