#! /bin/sh
#
# AutoFtp Version 3.0, by Mingqi Deng, July 6, 1989
# -------------------------------------------------
# 
# Refer to file README for instructions to run the program

# Set-up: 
#
# 1. Set the following 3 parameters in this program on lines 23-62:
#
#      		ALARM, RemoteHost, FtpLibDir 
#
#    Instructions and examples are given as comments in the following.
#
# 2. Make sure that you do NOT have any executable files of the same
#    name as the following UNIX commands' names:
#
# 	   cat chmod cp echo expr grep mv rm sh sleep sed test
#
#    Otherwise, rename your files to different names.

# An ftp attempt will be aborted after ALARM many seconds. It must at 
# least be equal to 300. The default # is 3600, eg., ALARM=3600 (do 
# not leave blanks between '=' and '3600'!)

ALARM=3600

# Define host names:
#   Use one of the following addresses for simtel20 archive site for the
# parameter RemoteHost below:
#         "26.2.0.74"
#         "WSMR-SIMTEL20.ARMY.MIL"
#         "SIMTEL20.ARPA"
# The first one is highly recommended if it works, since it is the 
# most time-saving address to use. The second is the official name. The
# third is an alias, thus least recommended. However, you may find only
# one of them works for you, depending on how your UNIX installation
# handles the addresses. One symptom is a quickly failed ftp (less than
# 5 seconds), which can be noticed by the ps command of UNIX.
#
# Also note that it has been noticed that some system does not recognize
# the address in upper case. Therefore, if none of the above three
# works for you, change the names to lower case and try again.
#
# LocalHost is set to "guest". If you find it not working, replace
# it with the host name of your machine on which this program is run.
#   eg.,     RemoteHost="26.2.0.74"
#            LocalHost="shire.cs.psu.edu"

RemoteHost="26.2.0.74" 
LocalHost="guest"

# Set the path name for the directory where three compiled C programs
# ftpget.c, nextfile.c and checkout.c are. This program assumes as 
# default that the three compiled programs are in $HOME/bin (a directory
# "bin" in your home directory). If they are to be put in a different
# directory, say, lib in your home directory, you should set FtpLibDir 
# as:
#        FtpLibDir="$HOME/lib"
# Otherwise, just leave 'FtpLibDir=""' on next line as it is.
FtpLibDir=""

#
#-------AUTOFTP30.SH Set-up Stops Here: No further set-up needed------
#

test 1$FtpLibDir = 1 && FtpLibDir=$HOME/bin
_ftpget="$FtpLibDir/ftpget"
_checkout="$FtpLibDir/checkout"
_nextfile="$FtpLibDir/nextfile"

test -s "$_ftpget" ||
   { echo "***Cannot find file '$_ftpget'!"
     echo "   Please compile 'ftpget.c', name the compiled program as"
     echo "   'ftpget' and place it in your '$FtpLibDir' directory." ; 
     exit 2 ; }
test -s "$_checkout" ||
   { echo "***Cannot find file '$_checkout'!"
     echo "   Please compile 'checkout.c', name the compiled program as"
     echo "   'checkout' and place it in your '$FtpLibDir' directory." ;
     exit 2 ; }
test -s "$_nextfile" ||
   { echo "***Cannot find file '$_nextfile'!"
     echo "   Please compile 'nextfile.c', name the compiled program as"
     echo "   'nextfile' and place it in your '$FtpLibDir' directory." ;
     exit 2 ; }

test $# != 1 && 
   { echo "***Usage: sh autoftp30.sh in_file" ; exit 2; }

exec 1>$$stdout 2>$$stderr

# Try FTP into simtel20 SLEEP many seconds until being connected
# SLEEP will be increased and decreased randomly for subsequent tries.
SLEEP=60

# save messages
cat  $$stdout $$stderr > $$msg

#initialize the loop
WS=`expr \( $SLEEP \* 47 + 31 \) \% 89 + 50`

ctr=1
cp $1 $$input
retry=no

# Repeat if there is more request in the input file or if the last
# attempt failed and a retry can be performed.
while { test -s $$input || test $retry = yes ; }
do

  > $$stderr
  > $$stdout

# If not a re-try for a requested file, then fetch next requested 
# file name. If the fetch fails, then quit autoftp30.sh.
  test $retry = no && 
  { echo "%%%%%%% Process File Request #$ctr %%%%%%%" >> $$msg
    ctr=`expr $ctr + 1`
    $_nextfile $$input $RemoteHost anonymous $LocalHost $$ftp.script >> $$msg || 
    { status=92; break;}
  }

# Attempt to get the file. If not able to make an attempt, then quit.
# Note that exit status=99 means there is no alarm call.
  chmod og-rx $$ftp.script
  $_ftpget $ALARM $$ftp.script ||
  { test $? = 99 &&        # alarm called, do not quit yet, $_checkout 
			   # will respond 
     { status=93; break; } ; }

# Check the result of the transfer. If a retry is not to be made, then 
# set "retry" to no, otherwise set it to yes.
  $_checkout $$stdout $$stderr $$ftp.script $$tmp >> $$msg
  status=$?
  { test $status = 99 && { status=94; break ; } ; } ||
  { test $status = 0  && retry=no ; } || retry=yes

# if not the last request, i.e., $$input is not empty or retry=yes, 
# then wait for a while before next attempt. Otherwise done!!!
  test -s $$input || test $retry = yes || { status=95; break ; }

# save the messages for only the last attempt on a request
  test $retry = no && cat  $$tmp >> $$msg
  rm $$tmp

  sleep $WS
  WS=`expr \( $WS \* 13 \/ 10 \) \% 900 + 60`

done

test $status -ge 92 && 
   { test $status -le 93 &&  cat $$stderr >> $$msg || 
        { cat $$tmp >> $$msg ; rm $$tmp ; }   # status=94,95
   }
  
case $status in
 92) echo "*******Fatal error: when preparing an ftp attempt!*******" >> $$msg;;
 93) echo "*******Fatal error: during an ftp attempt!*******" >> $$msg;;
 94) echo "*******Fatal error: when checking last ftp result!*******" >> $$msg;;
 95) echo "###################Execution Completed###################" >> $$msg;;
  *) ;;
esac

#remove ftp command and working files
rm $$ftp.script $$stderr $$stdout $$input

exit 0
