#
# $Id: Makefile.com,v 5.1.1.2 90/01/11 16:46:47 jsp Exp Locker: jsp $
#
# Copyright (c) 1990 Jan-Simon Pendry
# Copyright (c) 1990 Imperial College of Science, Technology & Medicine
# Copyright (c) 1990 The Regents of the University of California.
# All rights reserved.
#
# This code is derived from software contributed to Berkeley by
# Jan-Simon Pendry at Imperial College, London.
#
# Redistribution and use in source and binary forms are permitted
# provided that the above copyright notice and this paragraph are
# duplicated in all such forms and that any documentation,
# advertising materials, and other materials related to such
# distribution and use acknowledge that the software was developed
# by Imperial College of Science, Technology and Medicine, London, UK.
# The names of the College and University may not be used to endorse
# or promote products derived from this software without specific
# prior written permission.
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#	%W% (Berkeley) %G%
#

#
# -------- Users may care to override these values --------
#
# Any of these values can be overridden by redefining them
# in a file called Makefile.local or Makefile.local.foo (where
# "foo" is the OS name)
#

# Where to install amd
ETC = /usr/local/etc

# With what to install amd
INSTALL = install
INSTALL_BIN = ${INSTALL} -c -m 711 -o root

# Uncomment the next CC line if you want to use GNU CC
# Better yet - put the definition in Makefile.local.<foo>
#CC = gcc ${GCCOPTS}
GCCOPTS = -fcombine-regs -W -Wunused -fstrength-reduce #-finline-functions

# Basic C compiler options
CCOPTS = -O

# These are for testing/debugging...
# Best to put your own definitions in Makefile.local.<foo>
#CCOPTS =  -g
# Turn on -DDEBUG if you want a running commentary
#DEBUG = -DDEBUG

# Define RPCINC if Sun RPC header files are not in the standard place
RPCINC = #-I../../rpc

# Define RPCGEN as the name of your Sun *RPC/4* RPCGEN program (not RPC/3)
RPCGEN = rpcgen

# System C Compiler - one that is FULLY call compatible with your C libraries
SYSCC = cc
SYSCCFLAGS = ${CFLAGS}

# For old makes
SHELL = /bin/sh

# -------- YOU SHOULD NOT NEED TO CHANGE ANYTHING BELOW THIS LINE --------

# Magic
OS_HDR = os-${OS}.h
OSDEF = -DOS_HDR=\"${OS_HDR}\" -DOS_REP=\"${OS}\" -DARCH_REP=\"${ARCH}\"
CFLAGS = ${CCOPTS} ${DEBUG} ${OSDEF} -I..

# Basename of the program we are trying to build
AMD = amd
AMQ = amq
MKMAP = mk-amd-map

CC_COMPILE = ${CC} -c ${CFLAGS} ${RPCINC} ${CONFIG}
SYSCC_COMPILE = ${SYSCC} -c ${SYSCCFLAGS} ${RPCINC} ${CONFIG}

#
# Keeps sysV make happy:
#
VPATH = ..

#
# Autmounter modules
#
MOUNTOBJ = \
	afs_ops.o am_ops.o clock.o efs_ops.o \
	mapc.o info_file.o info_hes.o info_ndbm.o info_yp.o map.o \
	srvr_afs.o srvr_nfs.o \
	mntfs.o misc_rpc.o mount_fs.o mount_xdr.o \
	mtab.o nfs_ops.o nfs_prot_svc.o \
	nfs_start.o nfs_stubs.o nfs_prot_xdr.o \
	opts.o pfs_ops.o rpc_fwd.o \
	sched.o sfs_ops.o \
	amq_svc.o amq_subr.o umount_fs.o util.o \
	ufs_ops.o ifs_ops.o am.o get_args.o \
	rcs_info.o restart.o

AMQOBJ = \
	amq.o amq_clnt.o amq_xdr.o misc_rpc.o

MAPOBJ = \
	mk-amd-map.o

#
# Files defining different O/S flavors
#
OS_FILES = \
	os-acis43.h \
	os-aux.h \
	os-bsd44.h Makefile.bsd44 \
	os-concentrix.h \
	os-defaults.h \
	os-hlh42.h \
	os-hpux.h Makefile.hpux hpux.h \
	os-riscix.h \
	os-sos3.h \
	os-sos4.h \
	os-u2_2.h u2_2-nfs.h \
	os-u3_0.h \
	os-umax43.h \
	os-utx32.h \
	os-xinu43.h

# Experimental...
EXPERIMENTAL_OS_FILES = os-aix2.h Makefile.aix2

#
# Other files that need to be shipped
#
BITS	= \
	RELEASE \
	COPYRIGHT \
	Configure \
	ChangeLog \
	INSTALL \
	Makefile \
	Makefile.com \
	Makefile.config \
	patchlevel.h \
	newvers.sh \
	README \
	WishList \
	a_master \
	amd-man \
	amq-man \
	amd.start.ex \
	arch \
	os-type

#
# Files to ship
#
SHIP	= \
	afs_ops.c am.c am.h am_ops.c amq.c amq.h amq.x amq_clnt.c \
	amq_subr.c amq_svc.c amq_xdr.c clock.c \
	efs_ops.c fs.h get_args.c ifs_ops.c info_file.c info_hes.c \
	info_ndbm.c info_yp.c map.c mapc.c misc_rpc.c mk-amd-map.c \
	mntfs.c mount.h mount.x mount_fs.c mount_xdr.c mtab.c nfs_ops.c \
	nfs_prot.h nfs_prot.x nfs_prot_svc.c nfs_prot_xdr.c nfs_start.c \
	nfs_stubs.c opts.c pfs_ops.c rcs_info.c restart.c rpc_fwd.c sched.c \
	sfs_ops.c srvr_afs.c srvr_nfs.c ufs_ops.c umount_fs.c util.c uwait.h \
	${OS_FILES} ${BITS}

DOCS	= \
	doc/nh.sty doc/nh.doc \
	doc/amd.bbl doc/amd.bib \
	doc/amd.tex

EXAMPLES = \
	examples/am.master examples/amd.home \
	examples/amd.homes examples/amd.vol

SCRIPTS = \
	scripts/build-userinfo \
	scripts/get-homes \
	scripts/mk-home-maps \
	scripts/auto-banner

#
# Files to print
#
PRINT	= ${SHIP} ${SCRIPTS}

#
# What to build
#
all: ${AMQ} ${AMD} ${MKMAP}

${AMD}: ${MOUNTOBJ} version.${AMD}
	@sh ../newvers.sh $@
	${CC_COMPILE} vers.$@.c
	@rm -f $@
	${CC} -o $@ ${CFLAGS} ${MOUNTOBJ} vers.$@.o ${XLIBDIR} ${DBM} ${RPCLIB} ${RESOLV}

${AMQ}: ${AMQOBJ}
	@rm -f $@
	${CC} -o $@ ${CFLAGS} ${AMQOBJ} ${RPCLIB} ${XLIBDIR} ${RESOLV}

${MKMAP}: ${MAPOBJ}
	@rm -f $@
	${CC} -o $@ ${CFLAGS} ${MAPOBJ} ${DBM}

version.${AMD}: ../RELEASE
#	@echo Starting ${AMD} versions from zero ...
	@rm -f $@
	@echo 0 > $@

lint:
	@for i in ${MOUNTOBJ:.o=.c}; do \
		c="$$c ../$$i"; \
	done; \
	echo lint -chaax ${CFLAGS} $$c; \
	lint -chaax ${CFLAGS} $$c

count:
	cat ${MOUNTOBJ:.o=.c} | grep -v '^#' | /lib/cpp | \
	sed -e 's/[ 	]*$$//' -e '/^$$/d' | \
	wc

FRC:

${MOUNTOBJ}: ../am.h ../${OS_HDR} ../os-defaults.h ../fs.h ../Makefile.config
${AMQOBJ}: ../amq.h ../${OS_HDR} ../os-defaults.h
${MAPOBJ}: ../am.h ../${OS_HDR} ../os-defaults.h

nfs_start.o: ../amq.h
../amq.c ../amq_clnt.c ../amq_xdr.c ../amq_svc.c ../amq_subr.c: ../amq.h

# We can't use gcc here (at least on sparc) ....
amq.o: ../amq.c; ${SYSCC_COMPILE} ../amq.c
amq_clnt.o: ../amq_clnt.c; ${SYSCC_COMPILE} ../amq_clnt.c
info_ndbm.o: ../info_ndbm.c; ${SYSCC_COMPILE} ../info_ndbm.c
mk-amd-map.o: ../mk-amd-map.c; ${SYSCC_COMPILE} ../mk-amd-map.c

#amq.h: amq.x
#	${RPCGEN} -h -o $@ amq.x
#	@echo amq.h is out of date wrt amq.x - please fix by hand

#amq_xdr.c: amq.x
#	${RPCGEN} -c -o $@ amq.x
#	@echo amq_xdr.c is out of date wrt amq.x - please fix by hand

#amq_svc.c: amq.x
#	${RPCGEN} -m -o $@ amq.x
#	@echo amq_svc.c is out of date wrt amq.x - please fix by hand

#amq_clnt.c: amq.x
#	${RPCGEN} -l -o $@ amq.x
#	@echo amq_clnt.c is out of date wrt amq.x - please fix by hand

#
# Don't really need the next two
#
#mount_xdr.c: mount.x
#	${RPCGEN} -c -o $@ amq.x
#	@echo mount_xdr.c is out of date wrt mount.x - please fix by hand

#mount.h: mount.x
#	${RPCGEN} -h -o $@ mount.x
#	@echo mount.h is out of date wrt mount.x - please fix by hand

print: ${PRINT}
	enscript -2Grf Courier7 ${PRINT}

sharfile: ${AMD}.shar
${AMD}.shar: ${SHIP} ${DOCS} ${EXAMPLES} ${SCRIPTS}
	shar -o $@ ${SHIP} doc ${DOCS} examples ${EXAMPLES} scripts ${SCRIPTS}

tarfile: ${AMD}.tar.Z
${AMD}.tar.Z: ${SHIP} ${DOCS} ${EXAMPLES} ${SCRIPTS}
	tar cf - ${SHIP} ${DOCS} ${EXAMPLES} ${SCRIPTS} | compress > $@

uufile: tarfile
	uuencode < ${AMD}.tar.Z ${AMD}.tar.Z > ${AMD}.tar.Z.UU

install: all
	${INSTALL_BIN} ${AMD} ${ETC}/${AMD}
	${INSTALL_BIN} ${AMQ} ${ETC}/${AMQ}
	${INSTALL_BIN} ${MKMAP} ${ETC}/${MKMAP}
	@echo Please install the manual pages by hand

clean:
	-rm -f ${AMD} ${AMQ} ${MKMAP} *.o a.out core #mtab

#co:
#	co -l -r${REL} ${SHIP}
#
#release:
#	ci -u -r${REL} -f -m'Version ${VER}' -n${NAME} -s'${NAME}' ${SHIP}

pat:
	@touch RELEASE
	pat -n

diffs:
	@rcsdiff -q -c2 -r${NAME} ${SHIP} | \
		grep -v '^No differences encountered$$'

afs_ops.o: ../afs_ops.c; ${CC_COMPILE} ../afs_ops.c
am.o: ../am.c; ${CC_COMPILE} ../am.c
am_ops.o: ../am_ops.c; ${CC_COMPILE} ../am_ops.c
clock.o: ../clock.c; ${CC_COMPILE} ../clock.c
get_args.o: ../get_args.c; ${CC_COMPILE} ../get_args.c
efs_ops.o: ../efs_ops.c; ${CC_COMPILE} ../efs_ops.c
ifs_ops.o: ../ifs_ops.c; ${CC_COMPILE} ../ifs_ops.c
info_file.o: ../info_file.c; ${CC_COMPILE} ../info_file.c
info_hes.o: ../info_hes.c; ${CC_COMPILE} ../info_hes.c
#info_ndbm.o: ../info_ndbm.c; ${CC_COMPILE} ../info_ndbm.c
info_yp.o: ../info_yp.c; ${CC_COMPILE} ../info_yp.c
map.o: ../map.c; ${CC_COMPILE} ../map.c
mapc.o: ../mapc.c; ${CC_COMPILE} ../mapc.c
misc_rpc.o: ../misc_rpc.c; ${CC_COMPILE} ../misc_rpc.c
#mk-amd-map.o: ../mk-amd-map.c; ${CC_COMPILE} ../mk-amd-map.c
mntfs.o: ../mntfs.c; ${CC_COMPILE} ../mntfs.c
mount_fs.o: ../mount_fs.c; ${CC_COMPILE} ../mount_fs.c
mount_xdr.o: ../mount_xdr.c; ${CC_COMPILE} ../mount_xdr.c
mtab.o: ../mtab.c; ${CC_COMPILE} ../mtab.c
nfs_ops.o: ../nfs_ops.c; ${CC_COMPILE} ../nfs_ops.c
nfs_prot_svc.o: ../nfs_prot_svc.c; ${CC_COMPILE} ../nfs_prot_svc.c
nfs_start.o: ../nfs_start.c; ${CC_COMPILE} ../nfs_start.c
nfs_stubs.o: ../nfs_stubs.c; ${CC_COMPILE} ../nfs_stubs.c
nfs_prot_xdr.o: ../nfs_prot_xdr.c; ${CC_COMPILE} ../nfs_prot_xdr.c
opts.o: ../opts.c; ${CC_COMPILE} ../opts.c
pfs_ops.o: ../pfs_ops.c; ${CC_COMPILE} ../pfs_ops.c
rcs_info.o: ../rcs_info.c; ${CC_COMPILE} ../rcs_info.c
restart.o: ../restart.c; ${CC_COMPILE} ../restart.c
rpc_fwd.o: ../rpc_fwd.c; ${CC_COMPILE} ../rpc_fwd.c
sched.o: ../sched.c; ${CC_COMPILE} ../sched.c
sfs_ops.o: ../sfs_ops.c; ${CC_COMPILE} ../sfs_ops.c
srvr_afs.o: ../srvr_afs.c; ${CC_COMPILE} ../srvr_afs.c
srvr_nfs.o: ../srvr_nfs.c; ${CC_COMPILE} ../srvr_nfs.c
#svc_udp2.o: ../svc_udp2.c; ${CC_COMPILE} ../svc_udp2.c
#tfs_ops.o: ../tfs_ops.c; ${CC_COMPILE} ../tfs_ops.c
ufs_ops.o: ../ufs_ops.c; ${CC_COMPILE} ../ufs_ops.c
umount_fs.o: ../umount_fs.c; ${CC_COMPILE} ../umount_fs.c
util.o: ../util.c; ${CC_COMPILE} ../util.c
version.o: ../version.c; ${CC_COMPILE} ../version.c
amq_svc.o: ../amq_svc.c; ${CC_COMPILE} ../amq_svc.c
amq_subr.o: ../amq_subr.c; ${CC_COMPILE} ../amq_subr.c
#amq.o: ../amq.c; ${CC_COMPILE} ../amq.c
#amq_clnt.o: ../amq_clnt.c; ${CC_COMPILE} ../amq_clnt.c
amq_xdr.o: ../amq_xdr.c; ${CC_COMPILE} ../amq_xdr.c
