/*
 * $Id: mount_fs.c,v 5.1.1.2 90/01/11 17:10:47 jsp Exp Locker: jsp $
 *
 * Copyright (c) 1990 Jan-Simon Pendry
 * Copyright (c) 1990 Imperial College of Science, Technology & Medicine
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Jan-Simon Pendry at Imperial College, London.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Imperial College of Science, Technology and Medicine, London, UK.
 * The names of the College and University may not be used to endorse
 * or promote products derived from this software without specific
 * prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	%W% (Berkeley) %G%
 */

#include "am.h"
#ifdef NFS_3
typedef nfs_fh fhandle_t;
#endif
#include <sys/mount.h>

/*
 * System Vr4 / SunOS 4.1 compatibility
 * - put dev= in the options list
 *
 * From: Brent Callaghan <brent@eng.sun.com>
 */
#define	MNTINFO_DEV	"dev"
#include <sys/stat.h>

int compute_mount_flags(mnt)
struct mntent *mnt;
{
	int flags;
#ifdef NFS_4
	flags = M_NEWTYPE;
#else
	flags = 0;
#endif

	/*
	 * Crack basic mount options
	 */
	flags |= hasmntopt(mnt, "ro") ? M_RDONLY : 0;
#ifdef M_CACHE
	flags |= hasmntopt(mnt, "nocache") ? M_NOCACHE : 0;
#endif
#ifdef M_GRPID
	flags |= hasmntopt(mnt, "grpid") ? M_GRPID : 0;
#endif
#ifdef M_MULTI
	flags |= hasmntopt(mnt, "multi") ? M_MULTI : 0;
#endif
#ifdef M_NODEV
	flags |= hasmntopt(mnt, "nodev") ? M_NODEV : 0;
#endif
#ifdef M_NOEXEC
	flags |= hasmntopt(mnt, "noexec") ? M_NOEXEC : 0;
#endif
#ifdef M_NOSUB
	flags |= hasmntopt(mnt, "nosub") ? M_NOSUB : 0;
#endif
#ifdef hpux
/* HP-UX has an annoying feature of printing error msgs on /dev/console */
#undef M_NOSUID
#endif
#ifdef M_NOSUID
	flags |= hasmntopt(mnt, "nosuid") ? M_NOSUID : 0;
#endif
#ifdef M_SYNC
	flags |= hasmntopt(mnt, "sync") ? M_SYNC : 0;
#endif

	return flags;
}

int mount_fs(mnt, flags, mnt_data, retry, type)
struct mntent *mnt;
int flags;
caddr_t mnt_data;
int retry;
MTYPE_TYPE type;
{
	int error = 0;
	int automount = 0;
#ifdef MNTINFO_DEV
	struct stat stb;
	char *xopts = 0;
#endif

#ifdef DEBUG
#ifdef NFS_4
	dlog("%s fstype %s (%s) flags %#x (%s)",
		mnt->mnt_dir, type, mnt->mnt_type, flags, mnt->mnt_opts);
#else
	dlog("%s fstype %d (%s) flags %#x (%s)",
		mnt->mnt_dir, type, mnt->mnt_type, flags, mnt->mnt_opts);
#endif /* NFS_4 */
#endif /* DEBUG */

	/*
	 * Fake some mount table entries for the automounter
	 */
	if (STREQ(mnt->mnt_type, MNTTYPE_AUTO)) {
		automount = 1;
		mnt->mnt_fsname = pid_fsname;
		/*
		 * Try it with the normal name
		 */
#ifdef notdef
		mnt->mnt_type = MNTTYPE_IGNORE;
#endif
		mnt->mnt_type = MNTTYPE_NFS;
		/*
		 * Background the mount, so that the stat of the
		 * mountpoint is done in a background process.
		 */
		if (background())
			return 0;
	}

again:
	clock_valid = 0;
	error = MOUNT_TRAP(type, mnt, flags, mnt_data);
	if (error < 0)
		plog(XLOG_ERROR, "%s: mount: %m", mnt->mnt_dir);
	if (error < 0 && --retry > 0) {
		sleep(1);
		goto again;
	}
	if (error < 0) {
		if (automount)
			going_down(errno);
		return errno;
	}

#ifdef UPDATE_MTAB
#ifdef MNTINFO_DEV
	/*
	 * Add the extra dev= field to the mount table.
	 */
	if (stat(mnt->mnt_dir, &stb) == 0) {
		char *zopts = (char *) xmalloc(strlen(mnt->mnt_opts) + 32);
		xopts = mnt->mnt_opts;
		if (sizeof(stb.st_dev) == 2) {
			/* SunOS 4.1 */
			sprintf(zopts, "%s,%s=%04lx", xopts, MNTINFO_DEV,
					(u_long) stb.st_dev & 0xffff);
		} else {
			/* System Vr4 */
			sprintf(zopts, "%s,%s=%08lx", xopts, MNTINFO_DEV,
					(u_long) stb.st_dev);
		}
		mnt->mnt_opts = zopts;
	}
#endif /* MNTINFO_DEV */

#ifdef hpux
	/*
	 * Yet another gratuitously incompatible change in HP-UX
	 */
	mnt->mnt_time = clocktime();
#endif
	write_mntent(mnt);
#ifdef MNTINFO_DEV
	if (xopts) {
		free(mnt->mnt_opts);
		mnt->mnt_opts = xopts;
	}
#endif
#endif /* UPDATE_MTAB */

	/*
	 * Needed this way since mnt may contain a pointer
	 * to a local variable in this stack frame.
	 */
	if (automount)
		going_down(0);
	return 0;
}

#ifdef NEED_MNTOPT_PARSER
/*
 * Some systems don't provide these to the user,
 * but amd needs them, so...
 *
 * From: Piete Brooks <pb@cl.cam.ac.uk>
 */

#include <ctype.h>

static char *nextmntopt(p)
char **p;
{
	char *cp = *p;
	char *rp;
	/*
	 * Skip past white space
	 */
	while (*cp && isspace(*cp))
		cp++;
	/*
	 * Word starts here
	 */
	rp = cp;
	/*
	 * Scan to send of string or separator
	 */
	while (*cp && *cp != ',')
		cp++;
	/*
	 * If separator found the overwrite with nul char.
	 */
	if (*cp) {
		*cp = '\0';
		cp++;
	}
	/*
	 * Return value for next call
	 */
	*p = cp;
	return rp;
}

char *hasmntopt(mnt, opt)
struct mntent *mnt;
char *opt;
{
	char t[MNTMAXSTR];
	char *f;
	char *o = t;
	int l = strlen(opt);
	strcpy(t, mnt->mnt_opts);

	while (*(f = nextmntopt(&o)))
		if (strncmp(opt, f, l) == 0)
			return f - t + mnt->mnt_opts;

	return 0;
}
#endif /* NEED_MNTOPT_PARSER */
