/*
 * $Id: info_yp.c,v 5.1 89/11/17 18:20:22 jsp Exp Locker: jsp $
 *
 * Copyright (c) 1989 Jan-Simon Pendry
 * Copyright (c) 1989 Imperial College of Science, Technology & Medicine
 * Copyright (c) 1989 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Jan-Simon Pendry at Imperial College, London.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Imperial College of Science, Technology and Medicine, London, UK.
 * The names of the College and University may not be used to endorse
 * or promote products derived from this software without specific
 * prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	%W% (Berkeley) %G%
 */

/*
 * Get info from YP map
 */

#include "am.h"

#ifdef HAS_YP_MAPS
#include <rpcsvc/yp_prot.h>
#include <rpcsvc/ypclnt.h>

/*
 * Figure out the yp domain name
 */
static int determine_yp_domain(P_void)
{
static	 char default_domain[YPMAXDOMAIN];

	if (getdomainname(default_domain, sizeof(default_domain)) < 0) {
		plog(XLOG_ERROR, "getdomainname: %m");
		return EIO;
	}

	domain = default_domain;
	if (!*domain) {
		plog(XLOG_ERROR, "YP domain name is not set");
		return ENOENT;
	}

	return 0;
}

/*
 * Try to locate a key using Yellow Pages.
 * Modify time is ignored in YP - XXX
 */
int yp_search(m, map, key, val, tp)
mnt_map *m;
char *map;
char *key;
char **val;
time_t *tp;
{
	int outlen;
	int res;

	if (!domain) {
		int error = determine_yp_domain();
		if (error)
			return error;
	}

	res = yp_match(domain, map, key, strlen(key), val, &outlen);

	/*
	 * Do something interesting with the return code
	 */
	switch (res) {
	case 0:
		return 0;

	case YPERR_KEY:
		return ENOENT;

	default:
		plog(XLOG_ERROR, "%s: %s", map, yperr_string(res));
		return EIO;
	}
}

int yp_init(map)
char *map;
{
	char *name = 0;

	if (!domain) {
		int error = determine_yp_domain();
		if (error)
			return error;
	}

	/*
	 * To see if the map exists, try to find
	 * a master for it.
	 */
	if (yp_master(domain, map, &name))
		return ENOENT;
	free(name);
	return 0;
}
#endif
