.TH SPOOL 1 Local
.AT 5 2.0
.SH NAME
spool - spool files to remote printer.
.sp
.SH SYNOPSIS
.PP
spool -s 
.RI -p printer
.br
spool
.RI -p printer
.RI -b banner
[files]
.br
spool -l
.br
spool
.I node_name
R|S @
.B (see below)
.sp
.SH DESCRIPTION
.PP
.I Spool
allows the printing of files on a remote machine.
After sending the request,
.I spool
waits for (and displays) confirmation of the printing or status request.
.PP            
The command line options:
.TP
.B -p
This option is used to specify the remote
printer name for the printing or status request. (Required)
.TP
.B -s
Requests a queue and status report from the remote printer.
This must be used in conjunction with the
.B -p
flag.
(See above.)
.TP
.B -l
Lists the printers that can be reached from the network, along with
information regarding restricted use.
.TP
.B -b
The
.BI -b banner
option is required for all printing
requests.
.I Banner
will appear on the printout in large letters 
below the login name of the requestor.
There is a ten character maximum, with no spaces.
.TP
.B -d
Turns on a myriad of sometimes useful debugging
information, but does not actually execute the
remote commands.
.PP
The last
.I spool
command invokes the ``return'' mode of the
.I spool
program.  When a
.I spool
request is submitted, the
.I spool
program on the remote printer is invoked with the
name of the calling machine, an R for ``return 
.I spool
request
number'' or an S for ``return
.I lp
queue status'' and then an
@ sign.  The @ sign is introduced to make it very unlikely
for a user to type ``spool Mach7 R @'' from the console. (See
reference below.)
.br
.sp
.SH EXAMPLES
pr foo.s | spool -pgumby -bJohn
.br
.PP
.in +.5i
Formats the file foo.s and feeds it to
.I spool
for printing on the remote printer
.B gumby.
The name on the printout will be John.
.in -.5i
.br
.sp
spool -ppokey -bJones hexdump.c
.PP
.in +.5i
Prints the file hexdump.c on the remote printer 
.B pokey
with the name Jones on the printout.
.in -.5i
.br
.sp
spool -s -psluggo
.PP
.in +.5i
Requests status information about printer \fBsluggo\fR.  This
command will list the printer status, pending and
currently printing files, and other tidbits of
knowledge.
.in -.5i
.br
.sp
spool -l
.PP
.in +.5i
Lists the reachable printers physically connected to
the network.  This list is taken from 
.B ``etc/sysprint.''
[See \fBsysprint(7)\fR]
.in -.5i
.br
.sp
.SH NOTES
.PP
The '-' options may be specified in any order.
Options may be combined, and spaces between options
and arguments are allowed.  For example:
\fIspool -s -p room10\fR is the same as \fIspool -sproom10\fR.
[See \fBgetopt(3C)\fR]
.PP
Restricted use of printers is determined by login name through
\fIcuserid\fR. Currently, the
`student' login is not allowed to use restricted printers.
.br
.SH FILES
.br
.B /etc/sysprint
.SH DIAGNOSTICS
.br
Exit codes and messages:
.sp
.TP
1
Printer xxxx does not exist
.TP
2
Please request a printer
.TP
3
General usage error
.TP
4
Error opening xxxx for transmission
.TP
5
Panic: Error opening temporary file
.TP
6
File disappeared
.TP
7
Can't execute transmit program. (Nisend failed)
.TP
8
Panic: Could not delete temporary file
.TP
9
Can't execute request program. (Nisend failed)
.TP
10
Network printer database is missing.
.TP
11
Status file is missing. Hmm.
.TP
12
Sorry, remote machine is not answering...
.TP
13
Not allowed to use printer xxxx
.br
.sp
.SH REFERENCE
.LP
``\fBProject Report: Printer Spooling Over 3bnet\fR'' by James A.
Hayes, March, 1986.
.SH SEE ALSO
.LP
\fIsysprint(7)\fR, \fIgetopt(3C)\fR, \fIcuserid(2)\fR.
.br
