.ST
.nr VS 18
.ds LH "EECS 70
.ds RH %
.ds CH "Project Report
.ds CF
.sp 2i
.LG
.ce
\fBReport of activities\fI
.sp
.ce
\fBPrinter Spooling Over 3bnet\fR
.sp 2
.ce
.SM
.nr VS 15
James A. Hayes
.br
.ce
University of California,
.br
.ce
San Diego
.br
.sp 3
.ce
.LG
.I ABSTRACT
.sp
.QP
.LG
.nr VS 18
The goal of the
.I spool
implementation is to allow students to send information to printers
not physically
connected to their machine.  This design replaces the current method of
having to physically login to the printer's host.  This document
will provide an outline of the 
.I spool
implementation.
.sp 3
.nr VS 14
.LP
March, 1986
.br
.nr PS 12
.bp
.SH
Introduction
.PP
While the concept of a remote printer spooling system is easy to
understand, the actual implementation is at best, complicated.  If you have
not already done so, please read the
.I spool
manual page which will explain the \fIspool\fR command syntax.
This document will try to explain the
.I spool
implementation in three stages.  An explanation of network
security, a description of the
.I nisend
command,  and finally,
a nuts-and-bolts description of the spooling software.
.sp
.SH
1. Network Security
.PP
The AT&T 3B2 computer is capable of running an Ethernet network 
communications
system.  While the software provided with the Ethernet hardware is complete, 
a major problem arises when trying to use it in an educational environment.
The network commands are not protected from subversive
application.  That is
to say, it is dangerous when
.I anyone
is given permission to use the network
commands.  This means that a student on machine A can
.I copy
or knowingly
.I damage
homework files from a student on machine B.
.PP
The means for securing
the crucial network command (\fInisend\fR)
is borne from built-in UNIX\(dg
.FS
\(dg.
UNIX is a trademark of AT&T Bell Laboratories.
.FE
execution privileges.
.PP
The network command
.I nisend
is owned by
.B bin
and is a member of the newly
created group
\fBnisecure\fR.  It has  only the owner and group execute
permissions set.  This will not allow anyone but
.B root
or a member of the
group
.B nisecure
to execute the
.I nisend
program.  The print spooler (\fIspool\fR) is
also a member of the group
.B nisecure
and sets its group identification (sgid) on
execution.  The execute permissions for
.I spool
allow it to be run by anyone.
.PP
Since the group ID of
.I spool
is the same as \fInisend\fR,
.I spool
is allowed to call
\fInisend\fR.  So far, 
.I spool
is the only program that is allowed to call \fInisend\fR.
.PP
The access permissions (as seen by \fIls\fR)
look like this:
.KS
.sp
.ce
/usr/bin/nisend /usr/bin/spool
.TS
center;
l l l l l l.
-rwxr-s---	bin	nisecure	xx/xx/86	12:00	nisend
-rwxr-xr-x	root	nisecure	xx/xx/86	12:00	spool
.TE
.KE
.sp
.SH
2. The `nisend' Program
.PP
The
.I nisend
program is provided by AT&T as a front-end file transfer and
remote command execution system to be used by programs at the
shell and applications
level.  It is complete, but does have a few problems that are worth
mentioning.
.PP
.I Nisend
sends mail to its users after every request, transfer, command
execution, error and hiccup.  The default file access mode is set to 
600 (owner read/write).  The directory where the file will be saved (once
transmitted) is not the same directory it was taken from.  The default
receiving directory is ~/rje/\fIname\fR.  The
local file to be transmitted must
be the last item on the command line.  The one line \*Q3bnet job xxxxyyy
submitted\*U is always printed.
.PP
The  above problems may be circumvented by command line options.  To
stop mail, use the
.I undocumented
-e option.  To set
the access permissions of
the remote files, use the -a\fImode\fR option.  To specify
what directory the
file is to be saved in, use the -f\fIpath\fR option.  The
\*Q3bnet...\*U message may be silenced by the -s option.
.PP
The spool program uses a standard form of the
.I nisend
command that avoids all the above problems. It looks like this:
.LP
.in +.5i
.ti -.5i
.na
nisend -s -e -d\fIremote_machine\fR -a0666
-f/usr/tmp/\fIremote_name\fR
-!\*Q\fIremote_command\fR\*U /usr/tmp/\fIlocal_file\fR
.ad b
.in -.5i
.sp
.SH
3. The `spool' Program, an Overview
.PP
The
.I spool
program is not a server, although it performs the function of
a server because it is executed on the sending machine as well
as the receiving machine when a request is submitted.
.PP
The sending machine is responsible for collecting the files, sending
them, submitting them for printing, and waiting for confirmation from the
.I spool
program on the receiving end.  The 
.I spool
program on the receiving end
takes the confirmation from
.I lp
or status from
.I lpstat
and returns it to the
waiting machine on the sending end.
.sp
.SH
3.1. Spooling a File for Remote Printing
.sp
\fRCOMMAND: spool -p room10 -bJones foo.c
.sp
ACTIONS:
.PP
Validate the command options and verify that the specified file(s) and
printer (via \fI/etc/sysprint\fR) exist.
Read the file(s) (via stdin or file name(s)
on command line), concatenate them, and put them in a temporary file
/usr/tmp/sp.\fInode\fR.\fIXXXXX\fR, where
.I node
is the
.B 3bnet
node name of the user's
machine making the request, and
.I XXXXX
is the process ID of the
.I spool
program.  The above actions insure that the temporary file will have a
unique name on the remote machine when it is arrives there.
.PP
Send the file to the remote system, execute
.I lp
on the
remote system, store the standard output and standard error of
.I lp
in another temporary file /usr/tmp/\fInode\fR.stat,
send it back to the user, display it
and exit.
.KS
.LP
For example: (See also \fIFigure 1\fR)
.IP \fBUSER:\fR 10
$ pr *.s | spool -pX -bSharon  (executed on machine A, for printer X
on machine B, with PID=5427.)
.sp
.KE
.LP
.B SPOOL:
(SENDING END)
.IP 1.
Collect standard input (or specified files) and save in
/usr/tmp/sp.A.a5427
.IP 2.
Execute
.I nisend
(via the
.I system()
call).
.QP
.na
/usr/bin/nisend -s -e -dB -a0666 -f/usr/tmp/sp.A.a5427 -!\*Q\fBSee
remote command below\fR\*U /usr/tmp/sp.A.a5427
.ad b
.IP 3.
Remove /usr/tmp/sp.A.a5427
.IP 4.
Wait for the response /usr/tmp/A.stat to arrive, (contains the output
of the
.I lp
command.) give it 40 seconds to show up, and if it doesn't
arrive after that, give up and tell the user what happened. If it
does arrive in the allotted time, print it out.
.IP 5.
Remove /usr/tmp/A.stat (If it arrived from the remote machine.)
.sp
.LP
\fBRemotely executed command (broken down into steps):\fR
[Please note that the
.I lp
command is executed on the printing system by
.I spool
on the requesting system and not by
.I spool
on the printing system.  This saves about 3 seconds that would
normally be wasted waiting for
.I spool
to fork() and exec(), then waiting for
.I lp
to echo the request ID.  Now, the result of
.I lp
can be sent back the moment it is available.  This is quirk of the
.I nisend
command.]
.sp
.in +.5i
.IP A.
submit the job to lp and capture its output:
.QP
.na
usr/bin/lp -tSharon -c /usr/tmp/sp.A.a5427 > /usr/tmp/A.stat 2>&1
.ad b
.IP B.
Remove the temporary file:
rm /usr/tmp/sp.A.a5427
.IP C.
Return the captured output of
.I lp
to the calling spool by executing
spool on the receiving end:
.in +.5i
/usr/bin/spool A R @  (A=Name to send back to, R=\fIlp\fR report,
@=Receiver mode.)
.in -.5i
.IP D.
Remove the captured output of lp and return.
.QP
rm /usr/tmp/A.stat
.in -.5i
.sp 1
.SH
3.2. Requesting a Status Report on the Remote Printer
.sp
\fRCOMMAND: spool -s -p room10
.sp
ACTIONS:
.PP
Validate the command options and verify that the specified printer (via
\fI/etc/sysprint\fR) exists.
.PP
Execute the
.I lpstat
program on the remote system, store the standard output
and standard error of
.I lpstat
in a temporary file /usr/tmp/\fInode\fR.stat, send it back to
the user, display it and exit. (\fINode\fR is the requesting
.B 3bnet
node name.)
.KS
.LP
For example: (see also \fIFigure 2\fR)
.IP \fBUSER:\fR 10
$ spool -s -pX (executed on machine A, for printer X on machine B)
.br
.KE
.LP
.B SPOOL:
(SENDING END)
.IP 1.
Execute
.I nisend
(via the
.I system()
call):
.QP
.na
/usr/bin/nisend -s -e -dB -a0666
-!\*Q\fBSee remote command below\fR\*U
.ad b
.IP 2.
Wait for the response /usr/tmp/A.stat to arrive, (contains the output of
the
.I lpstat
command.) give it 40 seconds to show up, and if it
doesn't arrive after that, give up and tell the user what
happened. If it does arrive in the allotted time, print it out.
.IP 3.
Remove /usr/tmp/A.stat (If it arrived from the remote machine.)
.sp
.LP
\fBRemotely executed command (broken down into steps):\fR
.in +.5i
.IP A.
Fire-up
.I spool
on the receiving end. There it will execute
.I lpstat
and return the output back to the user:
.in +.5i
/usr/bin/spool A S @  (A=Machine name to send back to, S=lp status
report, @=Receiver mode.)
.in -.5i
.IP B.
Remove the captured output of
.I lpstat
and exit.
.in +.5i
rm /usr/tmp/A.stat
.in -1i
.sp 2
.SH
Conclusion/Comments
.PP
It is not the most efficient, but it works.  Possible future
improvements might involve an actual spool daemon.  This would make
handshaking more reliable, instead of using 
.I nisend
which is very slow and very sensitive to system load.
.sp
