#include "census.h"
#include <ctype.h>
#include <curses.h>
#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <sys/utsname.h>

char *them;
char us[9];
char thetab[MAXNODES][9];
char node[9];
char temp[150];

static char *statmsg[] = {" UP ","DOWN",
				"?   "," ?  ","  ? ","   ?"};

suicide()
{
	nl();
	echo();
	nocbreak();
	noraw();
	refresh();
	endwin();
	printf("\nCleaning up...\n");
	exit(0);
}

main(argc,argv)
int argc;
char **argv;
{
	int i, numentries, minutes;
	struct utsname name;

	them= MS(strlen(TMPDIR)+9);

	if (argc>1) {
		minutes=atoi(argv[1]);

		if ((minutes<0)||(minutes>200)) {
			fprintf(stderr,"Usage: %s [minutes]\n",argv[0]);
			fprintf(stderr,"       (where minutes is 0 to 200)\n");
			exit(1);
		}	
	}
	else minutes=15;

	setup();

	uname(&name);
	strcpy(us,name.sysname);

	do {
		numentries=gettable(argv);

		for (i=0;i<numentries;i++)
			if ( (talk_to(i))==0 )
				statdisp(0,i+1);
			else {
				statdisp(1,i+1);
				system(KILLCMD);
			}
		stall(minutes);
	} while (1);
}

int talk_to(i)
int i;
{
	int limit;
	int counter;

	limit=MAXTIMEOUT;
	counter=0;
	
	sprintf(them,TMPDIR,thetab[i]);
	sprintf(temp,RTOUCHCMD,thetab[i],us,them);
	unlink(them);
	system(temp);

	statdisp(2,i+1);
	
	do {
		sleep(2);
		limit-=2;
		statdisp(counter+2,i+1);
		counter=(counter+1)%4;
		if ( (access(them,0))==0) break;
	} while (limit>0);

	if ( (access(them,0))!=0) return(1);
		else {
			unlink(them);
			return(0);
		}
}


setup()
{
	int i;

	signal(SIGINT,SIG_IGN);
	signal(SIGHUP,SIG_IGN);
	signal(SIGQUIT,SIG_IGN);

	initscr();

	nonl();
	cbreak();
	raw();
	noecho();
	clear();
	refresh();
	nodelay(stdscr,1);
	
	attrset(A_REVERSE);
	mvaddstr(1,1,
"                                                                              "
);
	mvaddstr(22,1,
"                                                                              "
);
	attrset(A_NORMAL);
	mvaddstr(0,2,"Network status report:");
	MYrefresh;
}

int gettable(argv)
char **argv;
{
	static char node[9];
	FILE *table;
	int i;

	move(23,1); 
	clrtoeol();
	mvaddstr(23,1,"Gathering table data.");
	MYrefresh;	

	if ( (access(TABLECMD,1))!=0) {
		fprintf(stderr,"%s: ",argv[0]);
		perror(TABLECMD);
		suicide();
	}

		table=popen(TABLECMD,"r");
		for (i=0; i<6 ; i++) fgets(temp,81,table);

		i=0;
		do {
			if ( (fgets(temp,81,table))!=NULL) {
				if (strlen(temp) > 3) {
					awk_node(node,temp);
					if (strcmp(node,us)!=0)  {
						strcpy(thetab[i++],node);
						nodedisp(node,i);
					}
				}
			}
			else break;
		} while (1);
	move(23,1); 
	clrtoeol();
	mvaddstr(23,1,"Hit any key to exit.");
	MYrefresh;
	pclose (table);
return(i);
}

awk_node(node,temp)
char *node;
char *temp;
{
	int i;
	strncpy(node,temp,8);
	for(i=8; i>0; i--) if (isalnum(temp[i])) break;
						else node[i]='\0';
}

stall(yawn)
int yawn;
{
	int i,j;

	move(23,1);
	clrtoeol();
	mvaddstr(23,1,"   minutes till next update (Hit any key to exit)");
	
	for (i=yawn;i>0;i--) {
		if (i==1) mvaddstr(23,2,
			"   minute till next update (Hit any key to exit)  ");
		mvprintw(23,1,"%2d",i);	
		MYrefresh;
		for (j=0;j<60;j++) {
			if (getch()!= (-1)) suicide();
			sleep(1);
		}
	}
}

nodedisp(name,where)
char *name;
int where;
{
	int x,y;

	x=(where-1)%ROWS+3;
	y=(where-1)/ROWS*COLWIDTH;

	mvaddstr(x, y+1 ,name);
	mvaddch(x, y+11,'[');
	mvaddch(x, y+16,']');
}

statdisp(status,where)
int status;
int where;
{
	int x,y;

	x=(where-1)%ROWS+3;
	y=(where-1)/ROWS*COLWIDTH;

	if (getch()!= (-1)) suicide();
	switch(status) {
	case 1: attrset(A_BLINK);
			mvaddch( x, y+18, '*');
			break;
	case 2:
	case 3:
	case 4:
	case 5: attrset(A_DIM|A_REVERSE);
			break;
    }

	move(0,0);
	mvaddstr( x, y+12,statmsg[status]);
	attrset(A_NORMAL);
	MYrefresh;
}
