#define SYS_PRINTERS "/etc/sysprint"    /* Location of printer info. */
#define DEFAULT_DIR "/usr/tmp/%sXXXXXX"      /* Place for temp files,
	where %s and XXXXXX will be replaced by the machine name and
	process I.D. */
#define TIMEOUT 50			/* Seconds to wait for response */
/* ***************************************************************************
COMMAND is what is sent to the remote system.  Various arguments in the
command (%s strings) are specified in the ARGUMENTS portion.  The arguments
are declared in the order they appear in the command.
************************************************************************** */

#define COMMAND "/usr/bin/nisend -e -d%s -a0666 -s -c -f%s -!\042\
/usr/bin/lp -c -t%s %s>/usr/tmp/%s.stat 2>&1; rm %s;\
/usr/local/spool %s R @; rm /usr/tmp/%s.stat\042 %s"


#define ARGUMENTS printer_node,outname,banner,outname,name.sysname,outname,\
	name.sysname,name.sysname,outname

/* **************************************************************************
QUERY_COMMAND is what gets sent to the remote printer to get its status
sent back. QUERY_ARGUEMENTS are stuffed into the QUERY_COMMAND.
************************************************************************** */
#define QUERY_COMMAND "/usr/bin/nisend -e -s -d%s -!\
\042/usr/local/spool %s S @; rm /usr/tmp/%s.stat\042"

#define QUERY_ARGUMENTS printer_node,name.sysname,name.sysname

#define USAGE "print:  spool -p {printer} -b {banner}\n\
status: spool -p {printer} -s\n\
list supported network printers: spool -l\n"

#define STAT_COMMAND "lpstat -a -r -u -p>/usr/tmp/%s.stat;\
/usr/bin/nisend -c -e -d%s -a0666 -f/usr/tmp/%s.stat \
/usr/tmp/%s.stat"

#define STAT_ARGUMENTS sysname,sysname,sysname,sysname

#define LP_COMMAND "/usr/bin/nisend -s -e -c -d%s -a0666 -f /usr/tmp/%s.stat \
/usr/tmp/%s.stat"

#define LP_ARGUMENTS sysname,sysname,sysname 

/* We use these commands in the case that the person spooling to a remote
	printer, isn't.  (Meaning: When they are on the same machine as
	the printer, and no network activity needs to take place.
/*
#define LOCAL_LP "/usr/bin/lp -c -t%s %s"
#define LOCAL_LP_ARGS banner,outname

#define LOCAL_LPSTAT "/usr/bin/lpstat -a -r -u -p"
#define STATUS_TEMPLATE "/usr/tmp/%s.stat"

#define ERR -1
#define DEBUG if (debug) fprintf(stderr,"Debug>
#define EOL 10
#define SCRATCH 35

