#include <stdio.h>
#include <sys/utsname.h>  		/* System naming fetching library */
#include <string.h>			/* Until Jim can learn strings... */
#include <signal.h>
#include "spool.h"			/* spool.c #defines. */

/* **************************************************************
print:
  spool -pprinter_name -b[banner] {files}

query:
  spool -pprinter_name -q {<--query.}

list available printer:
  spool -l

(A -d may be added to turn debugging on.)

Author:  James Hayes.  (hayes@sdcsvax.ucsd.edu)
Log: 
        Version 1.5 (Added option for banner.)		13-Feb-86 
	Version 1.6 (Fixed things/cleaned up the code.)	19-Feb-86
	Version 2.0 (Frozen Revision)			03-Mar-86

**************************************************************** */

   char *printer_name[20],	/* The printer name known to eecs70 students.*/
        *printer_node[20],	/* The node name of the receiving printer. */
	*restriction[2];	/* The restriction flag. */

    int validate_printer(),     /* Verify printer exists. */
	list_printers(),	/* List available printers */
	printer_status(),	/* Request remote printer status */
	timeout(),		/* Wait for file to arrive. */
	student,		/* Non-zero if "student" logged in */
	debug;			/* Non-zero if debugging enabled. */

/* ********************************************************************** */ 

main(argc,argv)
int argc;
char *argv[];

{
   FILE *infd, *outfd, *fopen();

   extern int errno,		/* What else? */
  	optind,			/* For use with getopt (2) */
	opterr,    		/* Ditto */
	debug,			/* debug flag */
        student,		/* Non zero if student running program. */
	list_printers(),
	validate_printer();


   extern char *optarg,		/* Getopt option target string */
	*printer_name[20],	/* The printer name known to ee70 students.*/  
        *printer_node[20],	/* The node name of the receiving printer. */
	*restriction[2];	/* The restriction flag. */

   char *mktemp(),		/* MaKe a TeMPorary unique file name */
	*outname,		/* The temporary name itself. */
	*template[150],		/* The template used to create the temp name.*/
	*remote_command[255],   /* The remote command holder to the remote machine */
	*requested_printer, 	/* The printer requested by the student.*/
	*banner,		/* The truncated (10chars) banner name. */
	*login_name[20];	/* Login name of calling user. */
  	 
   int in_char,			/* Current stream input character */
       current_opt,		/* Pointer the next argv[] option. getopt(2) */
       error,			/* Non zero if command line errors found.*/
       prflag,			/* Non zero if a printer was specified */
       list_available,		/* Non zero if a printer list was asked for */
       query,			/* Non zero if printer status requested	*/
       banflag,			/* Non zero if a banner was specified */
       exec_status,		/* Exit status of the system call 'system()' */
       i; 

   struct utsname name;		/* Structure for the uname() system call */

   list_available=		/* Initialize everything. */
   debug=
   query=
   error=
   prflag=
   student=
   banflag=0;   

   uname(&name);					/* Get the system name. */
   sprintf(template,DEFAULT_DIR,name.sysname);		/* Make the temporary file templaye. */

   cuserid(login_name);					/* Get the login name of the user */
   if ( (strcmp(login_name,"student"))==0 ) student++;  /* If student, set the student flag */

   if ( (strcmp(argv[3],"@"))==0 ) return_state(argv[1],argv[2]);   /* Invoke the return mode of spool ? */

   /* Loop through all possible options and set flags according to what
      is chosen.  If an erronious command line option is choosen, then
      error is set to non-zero and the spooling stops.   */

   while  ((current_opt=getopt(argc,argv,"p:b:sld")) !=EOF)
	     switch (current_opt)
	      {
	       case 'p':		/* Printer? */
			prflag++;
			requested_printer=optarg;
			break;
 	       case 'b':		/* Banner name? */
			banflag++;
			banner=optarg;
			break;
	       case 's': 		/* Query printer? */
			query++;
			break;
	       case 'd':		/* Debug flag? */
			debug++;
			break;
	       case 'l':		/* List printers? */
			list_available++;
			break;
	       case '?':		/* Bad option? */
			error++;
			break;
	      }


DEBUG Template for making files %s\n",template);
DEBUG Student UID=%d, student flag=%d\n",getuid(),student);

      if ( (query) && (prflag))						/* Got -s and a printer name? */
	  if ( (validate_printer(requested_printer))==0 )  		/* Valid name? */
	    {
	      fprintf(stderr,"spool: printer %s does not exist.\n", requested_printer);
	      fprintf(stderr, "       To see supported printers, use: spool -l\n"); 
              exit(1);
	    }
	  else								/* Everything O.K... Do query. */
	    {
	      query_request(printer_node);
	      exit(0);
 	    }

      if (query)	/*Since -s is a strange option, be polite. */
	{
	  fprintf(stderr,"spool: Please request a printer\n");
	  exit(2);
	}

      if (list_available) 		/* List available printers?  */
	{
	  DEBUG Listing printers: \n");
	  list_printers();
	  exit(0);
        }

      /********************************************************************
       * Bad flag combinations, ie. Banner and no printer, printer and no
       * banner, no banner and printer, are not allowed.
       ********************************************************************
       */

      if ((prflag==NULL) && (banflag)) error++;
      if ((banflag==NULL) && (prflag)) error++;
      if ((banflag==NULL) && (prflag==NULL)) error++;

      if (error==0)			/* No errors? Check printer name. */

	  if ( (validate_printer(requested_printer))==0 )
	    {
	     fprintf(stderr, "spool: Incorrect printer choice\n");
	     error++;
	    }
      if (error)
       {
	 fprintf(stderr,USAGE);		/* If there was an error, print the */
	 list_printers();		/* command usage, and list the */
	 exit(3);			/* Available printers. */
       }

DEBUG Your printer: node: %s Res: %s Name: %s\n\n", printer_node,restriction, printer_name);

       i=optind;  			/* Save pointer to beginning of file names in the argv. */

/*******************************************************************************************************
 * Scan through each name specified to see if it is readable...  (As usual, complain if not, and exit.)
 *******************************************************************************************************
 */

	 for (;optind<argc;optind++)
	   if (access(argv[i],4) !=NULL)   			/* Check for read permissions */
	     {
	       fprintf(stderr,"spool: error opening %s for transmission.\n", argv[optind]);
	       exit(4);
	     }

	infd=stdin;			/* Default input is stdin. */
	outname=mktemp(template);  	/* Form unique filename. */
  	outfd=fopen(outname,"w"); 	/* Open it for writing. */
	if (outfd==NULL)		/* Error? */
 	  {
	    fprintf(stderr,"spool: panic: error opening tempfile %s\n",outname);
	    exit(5);	
	  }

	optind=i;	/* Restore saved argv pointer */

	do   		/* Copy each file into the transmission file. */
	  {
	      if (optind < argc)
		   {
		     infd=fopen(argv[i],"r");   /* Open for reading */
		     if (infd==NULL)
		      {
			fprintf(stderr,"spool: File %s was deleted, spool attempt aborted.\n",argv[i]);
			exit(6);
		      }
		   }
           while ( (in_char=getc(infd)) !=EOF) putc(in_char,outfd); 
           if (infd!=stdin) fclose(infd);    			/* Don't try and close stdin. */
	  } while (++i < argc);		     			/* Until all files are done. */

      fclose(outfd); 		        			/* Ready to transmit. */

      errno=0;  /* Just in case... */

      sprintf(banner,"%.10s",banner);   			/* Truncate the banner. */

      if ( (strcmp(name.sysname,printer_node))==0)		/* Are we on the same node we are trying to send to? */
        sprintf(remote_command,LOCAL_LP,LOCAL_LP_ARGS);         /* If so, use the local command. */
      else 
        sprintf(remote_command,COMMAND,ARGUMENTS);  		/* Otherwise, use the network command. */

      DEBUG Remote command:\n%s\n",remote_command);

      if (debug==0)
      {
        exec_status=system(remote_command); 			/* Execute the command. */

        if (exec_status == ERR) 				/* Was there a problem? */
	  {
	   fprintf(stderr,"spool: can't execute transmit program, spool attempt aborted with\n");
	   fprintf(stderr,"       system() erorr %d.\n",errno);
	   unlink(outname);
	   exit(7);
	  }
       }

DEBUG Unlinking work file %s.\n",outname);

	if (unlink(outname) != NULL)
	  {
	    fprintf(stderr,"panic: spool could not delete the temporary workfile %s. File(s) did transmit.\n",outname);
	    exit(8);
	  }

  if ( (strcmp(name.sysname,printer_node))!=0)
  list_response(name.sysname);						/* Wait for status file to come back. & printit. */

DEBUG EXIT.\n");
}

/****************************************************************************
 * validate (requested_printer);
 *
 *        return code:  0=not found.
 *			non-zero, found.
 *
 *       If found, the node_name of the printer is returned in printer_node,
 *	 along with it's restriction in restriction.
 ****************************************************************************
 */

validate_printer(requested_printer)
char *requested_printer;
{
  FILE *infd;

extern char *printer_name[20],	/* The printer name known to ee70 students.*/  
        *printer_node[20],	/* The node name of the receiving printer. */
	*restriction[2];	/* The restriction flag. */

extern int student;

  int	in_char,		/* Current stream input char. */
	found,			/* found requested printer in SYS_PRINTERS file if non-zero. */
	scan_OK;		/* Result of fscanf. -1=EOF. */
	
  found=0;
  if ((infd=fopen(SYS_PRINTERS,"r"))==NULL)
  {
    printf(stderr,"spool: Network printer database could not be located.\n");
    exit(10);
  }
  else
  {
   scan_OK=0;
   do
   {
     in_char=getc(infd);			/* Get first character */
     if (in_char==EOL) 				/* Blank line? */
      {
       do in_char=getc(infd) ;  		/* Skip any extra newlines. */
       while (in_char==EOL);
      }
     if (in_char==SCRATCH)      		/* Was it a beginning of a comment? */
	 do in_char=getc(infd) ;
	 while ( (in_char!=EOL) && (in_char!=EOF) ) ;
			 
     if (in_char==EOF) scan_OK=-1;  		/* End of file? God forbid! */

     if ((scan_OK==-1) || (in_char==SCRATCH) || (in_char==EOL)) ;
     else
       {
	ungetc(in_char,infd);	/* Put the first character back. */
	scan_OK=fscanf(infd,"%s%s%s",printer_name,restriction, printer_node);

	   if ( (strcmp(printer_name,requested_printer))==0 ) /* Found? */
	     {
	         scan_OK=EOF;       		/* Found? YES!, so artificially end the file. */
		 found++;
		 DEBUG Found printer name %s, restriction=%s.\n",printer_name, restriction);
		 DEBUG Student flag=%d\n",student);

	         if ( ((strcmp(restriction,"R"))==0)  && (student>0) )
	           {
		     fprintf(stderr, "spool: You are not allowed to use printer %s.\n", requested_printer);
		     exit(13);
	           }
	     }
       }
   } while (scan_OK!=EOF);		/* Keep going until EOF */
     fclose(infd);
  }
   return found;
}

/****************************************************************************
 * List available printers from SYS_PRINTERS.
 * (and print them out of course!)
 ****************************************************************************
 */

list_printers()
{
  FILE *infd;

extern char *printer_name[20],	/* The printer name known to ee70 students.*/  
        *printer_node[20],	/* The node name of the receiving printer. */
	*restriction[2];	/* The restriction flag. */

extern int debug;

int 	in_char,
	scan_OK;

  if ((infd=fopen(SYS_PRINTERS,"r"))==NULL)
  {
    printf(stderr,"spool: Network printer database could not be located.\n");
    exit(10);
  }
  else
  {
    fprintf(stdout,"\n   %-15s| %-30s\n","Printer Name:", "Restriction: (A=Anyone, R=Restricted)");
    fprintf(stdout,"   ---------------+--------------------------------------\n");
    scan_OK=0;
    do
     {
       in_char=getc(infd);  /* See above for the comments for this mess. */
       if (in_char==EOL) 
          do in_char=getc(infd); while (in_char==EOL);

       if (in_char==SCRATCH)
	 do in_char=getc(infd); while ( (in_char!=EOL) && (in_char!=EOF) );
			 
       if (in_char==EOF) scan_OK=-1;
       if ((scan_OK==-1) || (in_char==SCRATCH) || (in_char==EOL)) ;
       else
        {
	  ungetc(in_char,infd);
	  scan_OK=fscanf(infd,"%s%s%s",printer_name,restriction, printer_node);
	  fprintf(stdout,"   %-15s|%2s\n",printer_name,restriction);
        }
   } while (scan_OK!=EOF) ;
  }
   fclose(infd);
   fprintf(stdout,"\n");
   return;
}

/****************************************************************************
 * List response sent by remote system.  If it hasn't arrived yet, wait
 * until it does.  (Up to 40 seconds.)
 ****************************************************************************
 */
list_response(system_name)			/* Name of this system. (Used to build correct file name.) */
char *system_name;
{
   FILE *infd;
   int in_char;
   char *filename[30];

   sprintf(filename,STATUS_TEMPLATE,system_name);
   wait_file(TIMEOUT,filename);			/* Wait for TIMEOUT seconds for file 'filename' to arrive. */

   if ( (infd=fopen(filename,"r"))==NULL )
      {
	fprintf(stderr,"spool: Status file \'%s\' is missing. Hmm.\n", system_name);
	exit(11);
      }
    else
      {
	fprintf(stdout,"\n");
        while ( (in_char=getc(infd)) !=EOF) putc(in_char,stdout); 	/* List the file. */
	fprintf(stdout,"\n");
	close(infd);
	if ( (unlink(filename)) !=NULL )
	    fprintf(stderr,"Can't remove status file %s. Tell proctor.\n", filename);
	exit(8);
      }
}

/****************************************************************************
 * query_request(printer_node);
 * Line printer query request for printer 'printer_node'.
 ****************************************************************************
 */

query_request(printer_node)
char *printer_node;
{
   extern int errno,
	debug;

   int exec_status,
       in_char; 

   char *mktemp(),
	*outname,
	*template[150],
	*remote_command[255];  

   struct utsname name;		/* System name fetching structure */

   uname(&name);	 	/* Fetch our system name. */

   errno=0;

   if ( (strcmp(name.sysname,printer_node))==0)       /* Requesting from same machine as printer? */
     sprintf(remote_command,LOCAL_LPSTAT);	      /* Issue local lpstat command. */
   else
     sprintf(remote_command,QUERY_COMMAND,QUERY_ARGUMENTS);   /* Otherwise, use remote command. */

   DEBUG Remote command: %s\n",remote_command);

  if (debug==0)
   {
   exec_status=system(remote_command);

      if (exec_status == ERR)
	  {
	   fprintf(stderr,"spool: Can't execute request program, request attempt aborted with\n");
	   fprintf(stderr,"       system() error %d.\n",errno);
	   exit(9);
	  }
   }
   if ( (strcmp(name.sysname,printer_node))!=0)		/* If requesting from remote machine, wait for results. */
   list_response(name.sysname);
}

/****************************************************************************
 * wait_file(seconds,filename);
 * wait 'seconds' for file 'filename'
 * NOTE:  THE FILE BEING WAITED FOR IS UNLINKED, JUST IN CASE AN OLDER 
 *        VERSION OF IT MIGHT BE AROUND.    YOU HAVE BEEN WARNED....
 * 
 * If no file arrives after 'seconds', print error and exit(12) 
 ****************************************************************************
 */
wait_file(seconds,filename)
int seconds;
char *filename;
{
   DEBUG Filename: %s\n",filename);
   unlink(filename);			/* Just in case a leftover exists. */

   signal(SIGALRM,timeout); 		/* Set the alarm to point to the time out routine. */
   alarm(seconds);			/* Allow seconds timeout. */
   fprintf(stdout,"One moment please, your request is being processed.");
   fflush(stdout);
   
   do 
     {
       fprintf(stdout,".");		/* Print little dots every few seconds to let the user know what's goin on. */
       fflush(stdout);
       sleep(2);
     }
      while ((access(filename,4))!=NULL );    /* Keep doing it until the time runs out, or the file arrives. */

  signal(SIGALRM, SIG_IGN);
}

timeout()
{
  signal(SIGALRM, SIG_IGN);
  printf("\nSorry, the remote machine is not answering. Please make sure the\n");
  printf("printer/remote machine is operating properly.\n");
  exit(12);
}

/****************************************************************************
 * This is the return server for the spool program. It is invoked with
 * spool machine_making_request request_type @
 ****************************************************************************
 */
return_state(sysname,command)
char *sysname,
     *command;
{
 int exec_status; 
 char *remote_command[255];

 printf("Command: %s, Sysname: %s\n",command,sysname);

  if (strcmp(command,"S")==0)					/* Status request */
	sprintf(remote_command,STAT_COMMAND,STAT_ARGUMENTS);

  if (strcmp(command,"R")==0)					/* Return lp command status */
	sprintf(remote_command,LP_COMMAND,LP_ARGUMENTS);

  printf("Remote command: %s\n",remote_command);

  exec_status=system(remote_command);

  exit(0);
}

