/*
 * sub.c: general subroutines for "rcp"
 * remote(s): check if "s" refers to a local(0) or remote(1) file.
 * sysname(s): return systemname assosciated with s. "localnode" returned
 * 		if there is no specific "sys!" prefix.
 * filename(s): return filname part - strip first system prefix, if there is one
 * 
 * fmode(s): return value of file mode.
 *
 * lastpart(f): return last entry of path 'f'
 */

#define rindex strrchr
#define index strchr

char *filename(), *sysname(), *lastpart(), *malloc(), 
	*strrchr(), *strchr();
extern char *sys_errlist[];
#include "errno.h"
#include <stdio.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "ni.h"
long time();
char *asctime();
struct tm *localtime();

remote(s)
char *s;
{
	if(filename(s) == s) return(0);
	else return(1);
}
/*
 * sysname(f): get system name part of file name.
 * if no system present, return localnode
 */
char *sysname(f)
char *f;
{
	register char *p, *sys;
	register int length;
	if((p = filename(f)) == f) return(localnode);
	else {
		sys = malloc(length = p - f);
		strncpy(sys, f, length - 1);
		sys[length - 1] = 0;
		return(sys);
	}
}
/*
 * filename(f): return file name part of f
 * Strips the first (and only the first) system, if there is one.
 * [8] Also allow ':' as system flag.
 */
char *filename(f)
register char *f;
{
	register char *s;
	if((s = index(f, '!')) || (s = index(f, ':'))) return(++s);
	else return(f);
}
bang(c)
char c;
{
	if((c == '!') || (c == ':')) return(1);
	else return(0);
}

fmode(f)
char *f;
{
	struct stat s;
	if(stat(f, &s) == -1) return(0664);
	return(s.st_mode);
}

char *lastpart(f)
char *f;
{
	char *l;
	if(l = rindex(f, '/')) return(++l);
	else return(f);
}
	
