#include <sys/ni.h>
#include <sys/signal.h>

#ifdef MAIN
#define EXTERN
#else
#define EXTERN extern
#endif

#define MAP "/usr/lib/ethernet.addr"

EXTERN NI_PORT port;
EXTERN int debug;
EXTERN char *hostname, localnode[16];

#define ETHERSIZE 6

typedef char address_t[];
typedef unsigned char sequence_t;

#define PORT 4			/* plonk port id here */
#define NODE 5			/* plonk lsb node address */
#define LSB 5			/* lsb of node address */
#define PIDMSB 3
#define PIDLSB 4

EXTERN int ethernet;



#ifdef MAIN
char server[] = {0x0f, 0x02, 0x02, 0, 0, NODE};
#else
extern char server[];
#endif


#ifdef MAIN
char client[] = {0x0f, 0x02, 0x02, PIDMSB, PIDLSB, NODE};
#else
extern char client[];
#endif

#define PROTOCOL 0x5656


#ifdef MAIN
char myprotocol[] = {0x56, 0x56};
#else
extern char myprotocol[];
#endif


#ifdef MAIN
char mynode[] = {0,0,0,0,0,0};
#else
extern char mynode[];
#endif

char *ipaddr(), *getenv();

struct request {
	EI_PORT r_port;			/* Ethernet header */
	int r_size;			/* size of data field */
	char r_type;			/* type of request */
	unsigned char r_sequence;	/* Sequence number */
	char r_data[1024];		/* data field */
};

#define DATA 0			/* just data of some sort */
#define UNDEFINED 1		/* crappy packet */
#define REQUEST 2		/* Is this necessary? */
#define TERMINATE 3		/* STOP! Exit ASAP */
#define RMTSIGINT 4		/* signal from here to there */
#define RMTSIGQUIT 5		/* another signal */
#define ACCEPT 6		/* I accept that file */
#define REJECT 7		/* I have rejected that file */
#define PUTFILE 8		/* file to server */
#define SENDFILE 9		/* file from server */
