/*
 * file.c: server end of the "rcp" function.
 * Send or get files. Relies on the transport interface to detect errors,
 * only checks sequence numbers to identify lost packets.
 * If a packet is lost, then the transfer is abandoned and restarted - this
 * is not expected to happen often.
 */
#include <sys/types.h>
#include <sys/stat.h>

#include "ni.h"

#include "ftp.h"

extern char *sys_errlist[];
extern int errno;

char *lastpart();

fileserver(r)
register struct request *r;
{
	register int f, n;
	int mode, newfile;
	long kb;
	struct stat statb;
	char fname[128], local[128], remote[128];
/*
 * re-configure the ethernet port to handle sufficient buffers
 */
	close(ethernet);
	configure(server, WINDOW, getpid());
	send(r, 0, ACCEPT, client);
	signal(SIGTERM, SIG_DFL);		/* TERMINATE packet kills */
	while(1) {
		recv(r);			/* get request */
		switch(r->r_type) {
		case TERMINATE:
			exit(1);
			break;
		case SENDFILE:
			strncpy(fname, r->r_data, r->r_size);
			fname[r->r_size] = 0;
			if((f = open(fname, 0)) == -1) {
				n = sprintf(r->r_data, "%s: %s", fname,
					sys_errlist[errno]);
				send(r, n, REJECT, client);
			}
			else {
				stat(fname, &statb);
				n = sprintf(r->r_data, "%d", statb.st_mode & 0777);
				send(r, n, ACCEPT, client);
				ftpout(f, client);
				close(f);
			}
			break;
		case PUTFILE:
			n = sscanf(r->r_data,  "%d %s %s", 
					&mode,  remote, local);
			if(n != 3) {
				n = sprintf(r->r_data, "Illegal request parameters");
				send(r, n, REJECT, client);
				break;
			}
			strcpy(fname, local);
			if(stat(local, &statb) != -1) {
				if((statb.st_mode & S_IFMT) == S_IFDIR)
					sprintf(fname, "%s/%s", local, 
						lastpart(remote));
				newfile = 0;
			}
			else newfile = 1;
			if((f = creat(fname, 0666)) == -1) {
				n = sprintf(r->r_data, "%s: %s", fname,
					sys_errlist[errno]);
				send(r, n, REJECT, client);
			}
			else {
				if(newfile) chmod(fname, mode);
				send(r, 0, ACCEPT, client);
				if(!ftpin(f, client, &kb)) unlink(fname);
				close(f);
			}
			break;
		default:
			n = sprintf(r->r_data, "Illegal request function %d", 
					r->r_type);
			send(r, n, REJECT, client);
		}
	}
}
