#include <sys/signal.h>

#define GRACETIME 1
/*
 * terminate: log out the child shell. Sends SIGHUP, SIGTERM, SIGKILL
 * until the child exits.
 */
terminate(child)
{
	int status;
	if(child < 1) return(0);
	kill(child, SIGHUP);
	alarm(GRACETIME);
	if(wait(&status) == -1) {
		kill(child, SIGTERM);
		alarm(GRACETIME);
		if(wait(&status) == -1) {
			kill(child, SIGKILL);
			alarm(GRACETIME);
			if(wait(&status) == -1) {
				printf("Cannot kill child pid %d\n", child);
				status = 0;
			}
		}
	}
	alarm(0);
}

