.TH XXENCODE 1 "27 November 1989"
.UC 4
.SH NAME
xxencode,xxdecode \- encode/decode a binary file for transmission via mail
.SH SYNOPSIS
.I xxencode
[ source ] remotedest 
.br
.I xxdecode 
[ \-r ] [ file ]
.br
e.g. 
.I cat 
binaryfile | 
.I xxencode 
binaryfile | 
.I mail 
user@node
.br
e.g. 
.I xxencode 
\- < binaryfile | 
.I mail 
\-s binaryfile user@node 
.br
e.g. (from mail) |
.I xxdecode 
> binaryfile
.br
.sp 1
VM/CMS Examples:
.br
.I xxencode 
fn ft fm (bin options remotefile > fn ft fm
.br
.I xxencode 
remotefile < fn ft fm (bin options > fn ft fm
.br
(remotefile is a Unix syntax filename.)
.br
.I xxdecode 
[-r] fn ft [fm] [> fn ft [fm] [(options] (bin]
.SH DESCRIPTION
.I xxencode 
and 
.I xxdecode 
are used to send a binary file via electronic mail.   
.PP
.I xxencode 
takes the named source file (default standard
input) and produces an encoded version on the standard output.  
The encoding uses characters from a set expected to traverse
most mail gateways without translation.  The encoded file
includes the permission for the file and the remotedest for 
recreation on the remote system.
.PP
.I xxdecode 
reads an encoded file, strips off any leading and
trailing lines added by mailers, and recreates the original
files with the specified mode and name.  If the remotedest included
in the encoded file is '\-' or '/dev/stdout' (for historical purposes),
it will write the binary file to the standard output.  Note that several
files can be encoded into the same stream.  For instance, one can
concatenate the result of several invokations of xxencode to be
processed all-at-once by xxdecode.  xxdecode will search through the
entire file for occurrences of xxencoded files.
.PP
The encode file has an ordinary text form and can be edited
by any text editor to change the mode or remote name.
.SH OPTIONS
.TP 
.B \-r
If an unpiped output file from xxdecode already exists, the user will be
prompted whether the file should be replaced.  This option overrides
this prompt, forcing the file to be replaced.
.SH SEE\ ALSO
mail(1), elm(l), split(1), xxformat(l)
.SH AUTHOR
Phil Howard, David J. Camp (david@wubios.wustl.edu)
.SH BUGS
The file is expanded by 35% (3 bytes become 4 plus control information)
causing it to take longer to transmit.
.PP
The user on the remote system who is invoking
.I xxdecode
must have write permission on the specified file.
