      PROGRAM XX2BIN
C
C***************************************************************************
C   by Karl-L. Noell <NOELL@DWIFH1.BITNET>
C   XXE2BIN.FOR is currently only a Beta-Test-Version (15.Sep.1989)
C   compiled with MicroSoft FORTRAN 4.10
C   Purpose of XXE2BIN: decoding *.XXE-Files in PCs under DOS 3.x
C
C***************************************************************************
C
      IMPLICIT INTEGER (A-Z)
      INTEGER NU(4)
      CHARACTER ENDSTA*4,XXEREC(61)*1,RECSTR*61
      CHARACTER*1 CH(4)
C
      EQUIVALENCE (XXEREC(1),RECSTR)
      EQUIVALENCE (ENDSTA,XXEREC(1))
C
      COMMON /INITS/ XXETAB(0:127),CONO
C
C      DATA MASK /#000000FF/
      DATA MASK /255/
C
C
      CALL INIT (IDSI,ODSI,LINE)
      BYTES = 0
C
C======================== start of main loop ===========================
C---  read next XXE-line:
 10   READ(IDSI,'(A)',END=1000) RECSTR
      LINE = LINE + 1
      IF (ENDSTA.EQ.'end ') GOTO 99
C
      COL = 1
      BYTCNT = X2NUM (XXEREC(1),LINE,COL)
      IF (BYTCNT.EQ.0) GOTO 10
C
      BYTES = BYTES + BYTCNT
      ENDCOL = (4*BYTCNT)/3 + 1
      IF(ENDCOL.LT.5.AND.BYTCNT.GT.0) ENDCOL = 5
C
      PUTCNT = BYTCNT
      DO 20 ICOL=2,ENDCOL,4
            DO 15 I = 1,4
                  COL = COL + 1
                  CH(I) = XXEREC(COL)
                  NU(I) = X2NUM (CH(I),LINE,COL)
 15         CONTINUE
C
C----------------------- mapping 4 XXE characters into 3 Bytes: --------
C                   I                                               I
C                   I   NU(1)   I   NU(2)   I   NU(3)   I   NU(4)   I
C (4x 6 bits)    ---I-----------I-----------I-----------I-----------I---
C (00 .. 3Fh)   ... I1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0I ..
C                ---I-----------I---*-------I-------*---I-----------I---
C (3x 8 bits)    ---I---------------I---------------I---------------I---
C (00 .. FFh)   ... I1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0I ..
C                ---I---------------I---------------I---------------I---
C                   I      B1       I      B2       I      B3       I
C
C
            B1 =      IOR(ISHFT(NU(1),2),ISHFT(NU(2),-4))
            B2 = IAND(IOR(ISHFT(NU(2),4),ISHFT(NU(3),-2)),MASK)
            B3 = IAND(IOR(ISHFT(NU(3),6),NU(4)),MASK)
C-----------------------------------------------------------------------
C
            IF(PUTCNT.GE.1) CALL PUTBYT (B1,ODSI)
            IF(PUTCNT.GE.2) CALL PUTBYT (B2,ODSI)
            IF(PUTCNT.GE.3) CALL PUTBYT (B3,ODSI)
C
            PUTCNT = PUTCNT - 3

 20   CONTINUE
C
      GOTO 10
C======================== end   of main loop ===========================
C
C-- here normal exit:
 99   CALL FLUSH (ODSI)
      CLOSE (ODSI)
      CLOSE (IDSI)
      WRITE (CONO,199) LINE,BYTES
 199  FORMAT(/1X,I6,' lines read.'/
     *        1X,I6,' bytes in outfile '/)
      STOP 0
C
C///////////////////////  exception handling ///////////////////////////
C
C  end statement in XXE-file missing:
 1000 WRITE(CONO,100) LINE
 100  FORMAT(/
     * ' EOF encountered after line ',I5,' end statement missing')
      CLOSE (ODSI)
      CLOSE (IDSI)
      STOP 1000
C///////////////////////////////////////////////////////////////////////
C
       END
C
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C      Subroutine PUTBYT
C
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      SUBROUTINE PUTBYT (BYTNUM,ODSI)
C
      IMPLICIT INTEGER (A-Z)
      CHARACTER*1 SECTOR (256)
C
      COMMON /INITS/ XXETAB(0:127),CONO
C
      DATA SECLEN,BUFCNT/256,0/
      DATA KBYTES,KCOUNT/0,0/
C
      BUFCNT = BUFCNT + 1
      SECTOR (BUFCNT) = CHAR(BYTNUM)
      IF (BUFCNT.EQ.SECLEN) THEN
C---  write to outfile if buffer full:
         WRITE(ODSI) SECTOR
         BUFCNT=0
         KCOUNT = KCOUNT + 1
      ENDIF
C
      IF (KCOUNT.EQ.4) THEN
C---  show the progress of the decoding:
         KCOUNT = 0
         KBYTES = KBYTES + 1
         WRITE(CONO,'(''+'',I6)') KBYTES
      ENDIF
C
      RETURN
C
C --- Entry:
      ENTRY FLUSH (ODSI)
      WRITE(ODSI) (SECTOR(I),I=1,BUFCNT)
      RETURN
C///////////////////////  exception handling ///////////////////////////
C---  currently not used.
C///////////////////////////////////////////////////////////////////////
C
       END
C
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C      Subroutine INIT
C
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      SUBROUTINE INIT (IDSI,ODSI,LINE)
C
      IMPLICIT  INTEGER (A-Z)
      LOGICAL   FOUND
      CHARACTER XXECHR(0:63)*1
      CHARACTER XXEREC(61)*1,RECSTR*61
      CHARACTER XXESTR*64,XXEFIL*64,BEGREC*6,OUTFIL*12,OUTF11*12,ANSWER
C
      EQUIVALENCE (XXESTR,XXECHR(0))
      EQUIVALENCE (XXEREC(1),RECSTR)
      EQUIVALENCE (BEGREC,XXEREC(1))
      EQUIVALENCE (OUTFIL,XXEREC(12))
      EQUIVALENCE (OUTF11,XXEREC(11))
C
      COMMON /INITS/ XXETAB(0:127),CONO
C
C-- Inits:
      DATA XXESTR /
     *'+-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'
     * /
C
C --- I/O UNITS (DSI= data set identifier):
C     Input  ---> in File IDSI=9:  (filename.XXE)
C     Output ---> in File ODSI=7:  (binary)
C
      IDSI = 9
      ODSI = 7
      CONI = 5
      CONO = 6
C
      WRITE(CONO,'(/'' XXE2BIN V 0.5 (beta test)  15. Sep. 1989 ''/)')
      LINE = 0
C
      DO 10 I=0,127
 10   XXETAB(I) = 99
C
      DO 20 I=0,63
      IDX = ICHAR(XXECHR(I))
      IF (IDX.LT.0.OR.IDX.GT.127) STOP 128
C
 20   XXETAB(IDX) = I
C
      WRITE(CONO,'('' Enter source file: '')')
      READ (CONI,'(A)') XXEFIL
      INQUIRE (FILE=XXEFIL,ERR=1040,EXIST=FOUND)
      IF (.NOT.FOUND) GOTO 1040
C
      OPEN (UNIT=IDSI,FILE=XXEFIL,STATUS='OLD')
C
C-- Searching for begin- and filename-statement
C
 50   READ (IDSI,'(A)',END=1590) RECSTR
      LINE = LINE + 1
      IF (BEGREC.NE.'begin ') GOTO 50
C
C
      IF(XXEREC(11).NE.' ') THEN
        DO 55 I=23,12,-1
              XXEREC(I) = XXEREC(I-1)
 55     CONTINUE
      ENDIF
      INQUIRE (FILE=OUTFIL,ERR=1050,EXIST=FOUND)
      OPEN (UNIT=ODSI,FILE=OUTFIL,FORM='BINARY')
      IF (FOUND) THEN
         WRITE (CONO,150) OUTFIL
 150     FORMAT(/1X,A,' already exists.')
 60      WRITE (CONO,'('' replace ? (y/n)''/)')
         READ (CONI,'(A)') ANSWER
         IF (ANSWER.EQ.'n'.OR.ANSWER.EQ.'N') STOP 1060
C
         IF (.NOT.(ANSWER.EQ.'y'.OR.ANSWER.EQ.'Y')) GOTO 60
C
      ENDIF
      WRITE(CONO,'('' binary output is going to file: '',A)') OUTFIL
      WRITE(CONO,'('' KBytes processed:''/)')
      RETURN
C
C///////////////////////  exception handling ///////////////////////////
C
C  Open Error:
 1040 WRITE (CONO,'(/'' Error opening file: '',A/)') XXEFIL
      IF(.NOT.FOUND) WRITE (CONO,'('' File not found.''/)')
      STOP 1040
C
 1050 WRITE (CONO,'(/'' Error opening file: '',A/)') OUTFIL
      STOP 1050
C
C  begin statement in XXE-file missing:
 1590 WRITE(CONO,'(1X,I5,'' EOF: begin statement not found.''/)')
      STOP 1590
C///////////////////////////////////////////////////////////////////////
C
      END
C
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C      Function X2NUM
C
C  Purpose:  converts one XXE-character (one byte) into its num. value.
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      INTEGER FUNCTION X2NUM (CHR,LINE,COL)
C
      IMPLICIT  INTEGER (A-Z)
      CHARACTER*1 CHR
C
      COMMON /INITS/ XXETAB(0:127),CONO
C
      IDX = ICHAR (CHR)
      IF (IDX.LT.0.OR.IDX.GT.127) GOTO 1128
C
      X2NUM = XXETAB (IDX)
      IF (X2NUM.EQ.99) GOTO 1099
C
      RETURN
C
C///////////////////////  exception handling ///////////////////////////
C
C  illegal XXE character:
 1128 WRITE(CONO,528) CHR,CHR,LINE,COL,IDX
 528  FORMAT(/' illegal XXE character ',A,
     * ' (',Z2,'h) in line: ',I5,' col.: ',I3,' IDX:',I11/)
      STOP 1128
C
C  num value out of range (0..63)
 1099 WRITE (CONO,199) CHR,CHR,LINE,COL
 199  FORMAT(/' illegal XXE character ',A,
     * ' (',Z2,'h) in line: ',I5,' col.: ',I3/)
      STOP 1099
C
C///////////////////////////////////////////////////////////////////////
C
      END
