/*
 * Name: uupath
 *
 * Calls getpath to lookup the usenet path
 *
 * Author: J. Donnelly  3/82
 * $Log:	uupath.c,v $
 * Revision 1.3  85/08/03  01:26:17  UUCP
 * *** empty log message ***
 * 
 * Revision 1.2  85/07/19  17:47:05  UUCP
 * updated to define Debug for compatability with getpath
 * 
 * Revision 1.1  85/07/11  18:35:59  sob
 * Initial revision
 * 
 *
 */

#include	"uuconf.h"
bool Debug;

static char rcsid[] = "$Header: uupath.c,v 1.3 85/08/03 01:26:17 UUCP Exp $";

main (argc, argv) char *argv[];
{
    char    path[PATHSIZ],work[BUFSIZ];
    int     i,
            retval;					/* value returned from getpath */

    if (argc < 2)
    {
	printf ("Usage: uupath sysname1 sysname2 ...\n");
	exit (EX_USAGE);
    }

    for (i = 1; i < argc; i++)
    {
	retval = getpath (argv[i], &path[0],DATABASE);		/* lookup usenet path */
	if (retval == EX_NOHOST)
	    printf ("Can't find path to %s\n", argv[i]);

	else
	    if (retval == EX_NOINPUT)
	    {
		printf ("Can't open the network map\n");
		exit (EX_TEMPFAIL);
	    }

	    else
		{
		sprintf (&work[0],"Path to %s:  %s\n", argv[i], &path[0]);
    		printf(&work[0],"username");
		}
	}
}
