/* $Header: uuconf.h,v 1.5 85/12/10 20:42:30 sob Exp $
 * Configuration for uumail and uupath utilities
 * Please see the header for makefile for changes you may
 * need to make there.
 * $Log:	uuconf.h,v $
 * Revision 1.5  85/12/10  20:42:30  sob
 * Added defines for new parts of getpath, SENTINAL and TIMEOUT
 * 
 * Revision 1.4  85/10/02  02:16:21  sob
 * Added LOCALMAIL definition
 * 
 * Revision 1.3  85/09/30  02:50:51  sob
 * Added pwd.h to list of include files
 * 
 * Revision 1.2  85/07/11  19:29:34  sob
 * *** empty log message ***
 * 
 * Revision 1.1  85/07/11  19:22:20  sob
 * Initial revision
 * 
 */
#include <stdio.h>
#include <ctype.h>
#include <pwd.h>
#include <signal.h>
#include <setjmp.h>

/*
 * sysexits is a file of exit codes that are used in sendmail
 * and other programs ...
 */
#include <sysexits.h>
/* if you don't have sysexits.h here are the useful parts */
#ifndef EX_OK

# define EX_OK		0	/* successful termination */


# define EX_USAGE	64	/* command line usage error */
# define EX_DATAERR	65	/* data format error */
# define EX_NOINPUT	66	/* cannot open input */
# define EX_NOHOST	68	/* host name unknown */
# define EX_UNAVAILABLE	69	/* service unavailable */
# define EX_SOFTWARE	70	/* internal software error */
# define EX_OSERR	71	/* system error (e.g., can't fork) */
# define EX_OSFILE	72	/* critical OS file missing */
# define EX_CANTCREAT	73	/* can't create (user) output file */
# define EX_IOERR	74	/* input/output error */
# define EX_TEMPFAIL    75      /* temp failure; user should retry */
#endif

typedef char bool;

#ifdef DBM
#include <dbm.h>
#endif

#ifdef SYSIII
#define index strchr
#define rindex strrchr
#include <sys/utsname.h>
#endif

#define NAMESIZ 32 /* system name size */
#define PATHSIZ 16*NAMESIZ /* path length */

#define TRUE	1
#define FALSE	0

#ifndef TIMEOUT
#define TIMEOUT ((unsigned) 180)
#endif TIMEOUT

#ifndef SENTINEL
#define SENTINEL "@@@"
#endif SENTINEL

/* Here's where you should put in the the name of the file
 * in which the uucpmap data is kept.
 * For those using DBM, this will be the root filename for the database
 * (eg... file.pag and file.dir with root name file)
 */

#define DATABASE "/usr/lib/uucp/palias"
#define CONFIGFILE "/usr/lib/uucp/domains"
#define LOGFILE "/usr/adm/uumail.log"
/* this needs to be a printf-like string to deliver LOCAL mail */
/* usually this is either /bin/mail or /bin/binmail */

#define LOCALMAIL "/bin/bellmail %s"

#ifdef _DEFINE
#define EXTERN 
#else
#define EXTERN extern
#endif

EXTERN int Debug;
EXTERN char *paths;
EXTERN char *ConfFile;
EXTERN char Myname[NAMESIZ];
EXTERN char *logfile;
EXTERN char	OpMode;		/* operation mode, see below */
/* These don't do anything yet.... next time they will do something */
#define MD_DELIVER	'm'		/* be a mail sender */
#define MD_ARPAFTP	'a'		/* old-style arpanet protocols */
#define MD_SMTP		's'		/* run SMTP on standard input */
#define MD_DAEMON	'd'		/* run as a daemon */
#define MD_VERIFY	'v'		/* verify: don't collect or deliver */
#define MD_TEST		't'		/* test mode: resolve addrs only */
#define MD_INITALIAS	'i'		/* initialize alias database */
#define MD_PRINT	'p'		/* print the queue */
#define MD_FREEZE	'z'		/* freeze the configuration file */
