#ifndef lint
static char sccsid[] = "@(#)uuencode.c	5.1 (Berkeley) 7/2/83";
#endif

/*
 * uuencode [input] remote-file-name encoded-output
 *
 * Encode a file so it can be mailed to a remote system, busting it into
 * segments small enough to pass through net mailers.
 *
 * changed 11/10/87 by Herm Fischer of Mark V Business Systems, Encino CA,
 *	fischer@hermix.uucp
 *
 * (a) so that you can specify input file, remote file name (which is often
 * different), and temporary encoded-file-name (where you want it placed
 * from which to net mail from)
 *
 * (b) and so that long files are broken into small enough segments to
 * pass through net mailers without choking.
 *
 * TESTED on PC with Microsoft C compiler 4.0
 *
 * NEW arguments:
 *  uuencode [input file] remote-file-name encoded-output
 *
 * (Changes contributed by H. Fischer are placed into the public domain.
 * Ownership of original sources is unclear.)
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <io.h>
#include <string.h>

#define MAX_OUT ((long)(45L*1200L))	/* max file output size */

/* ENC is the basic 1 character encoding function to make a char printing */
#define ENC(c) (((c) & 077) + ' ')

main(argc, argv)
char **argv;
{
	int in;
	FILE * out;
	struct stat sbuf;
	int mode;
	char outbuffer[BUFSIZ];
	int num_parts, part_no;
	char outfile[132];
	char * extension = NULL;
	int I;

	/* optional 1st argument */
	if (argc > 3) {
		if ((in = open(argv[1], O_RDONLY | O_BINARY ))
			 	< 0 ) {
			perror(argv[1]);
			exit(1);
		}
		argv++; argc--;
	} else	{
		in = fileno(stdin);
		fprintf(stderr, "\nUsing Standard Input as Input");
		}

	if (argc != 3) {
		fprintf(stderr, "Usage: uuencode [infile] remotefile encodedfile\n");
		exit(2);
	}

	strcpy(outfile, argv[2]);	/* output file specification */

	/* figure out the input file mode */
	fstat(in, &sbuf);
	mode = sbuf.st_mode & 0777;

	/* figure out whether uuencoded result exceeds 90k max file size */
	num_parts = (sbuf.st_size / MAX_OUT) + 1L;
	if (num_parts > 1) {	/* must split file into parts */
		fprintf(stderr, "Warning, output file split into %d parts\n",
				num_parts);
		/* find or make up file extension */
		I = strlen(outfile);
		while( I-- ) {
		    if (outfile[I] == '.') {
			extension = &outfile[I];
			break;
			}
		    if (outfile[I] == ':' || outfile[I] == '\\') {
			extension = outfile + strlen(outfile);
			break;
			}
		  }
		if (!extension) extension = outfile + strlen(outfile);
		}

    for(part_no = 1; part_no <= num_parts; part_no++) {

	if (num_parts > 1) sprintf(extension, ".%.3d", part_no);

	fprintf(stderr, "Writing encoded file %s\n", outfile);
	out = fopen(outfile, "wt");
	setbuf(out, outbuffer);

	fprintf(out, "begin %o %s", mode, argv[1]);
	if (num_parts > 1)
		fprintf(out, " segment %d of %d", part_no, num_parts);
	fputc('\n', out);

	encode(in, out);

	fputs("end\n", out);
	fclose(out);

	}

	exit(0);
}

/*
 * copy from in to out, encoding as you go along.
 */
encode(in, out)
int   in;
FILE *out;
{
	char buf[80];
	int i, n;
	long byte_count;

	for (byte_count = 0;byte_count < MAX_OUT;byte_count += 45) {
		/* 1 (up to) 45 character line */
		n = fr(in, buf, 45);
		if (n > 0) {
		    putc(ENC(n), out);

		    for (i=0; i<n; i += 3)
			outdec(&buf[i], out);

		    putc('\n', out);
		    }

		if (n <= 0)
			break;
	}
	fputs(" \n", out);	/* terminator count of zero */
}

/*
 * output one group of 3 bytes, pointed at by p, on file f.
 */
outdec(p, f)
char *p;
FILE *f;
{
	int c1, c2, c3, c4;

	c1 = *p >> 2;
	c2 = (*p << 4) & 060 | (p[1] >> 4) & 017;
	c3 = (p[1] << 2) & 074 | (p[2] >> 6) & 03;
	c4 = p[2] & 077;
	putc(ENC(c1), f);
	putc(ENC(c2), f);
	putc(ENC(c3), f);
	putc(ENC(c4), f);
}

/* fr: like read but stdio */
int
fr(fd, buf, cnt)
int   fd;
char *buf;
int cnt;
{
	int c, i;

/*
	for (i=0; i<cnt; i++) {
		c = getc(fd);
		if (c == EOF)
			return(i);
		buf[i] = c;
	}
	return (cnt);
*/
	return( read(fd, buf, cnt) );
}
