#ifndef lint
static char sccsid[] = "@(#)uudecode.c	5.1 (Berkeley) 7/2/83";
#endif

/*
 * uudecode input [input [input...]] for PC [segmented] files
 *
 * create the specified file, decoding as you go.
 * used with uuencode.
 *
 * changed 11/10/87 by Herm Fischer of Mark V Business Systems, Encino CA,
 *	fischer@hermix.uucp
 *
 * (a) so that you can specify segments of input file[s] as received from
 * net mail
 *
 * (b) and so that long files which were broken into small segments become
 * assembled back together with error checking for missing and order of
 * segments
 *
 * TESTED on PC with Microsoft C compiler 4.0
 *
 * NEW arguments:
 *  uudecode file [file [file...] ]
 *
 * (note:  files assembled are given name specified under "remote file"
 * when uuencode was run)
 *
 * (Changes contributed by H. Fischer are placed into the public domain.
 * Ownership of original sources is unclear.)
 */
#include <stdio.h>
#ifdef UNIX
#include <pwd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>

/* single character decode */
#define DEC(c)	(((c) - ' ') & 077)

main(argc, argv)
char **argv;
{
	FILE *in, *out;
	struct stat sbuf;
	int mode;
	char dest[128];
	char buf[80];
	int segment_nbr = 1, num_segments = 1;
	int last_segment_nbr = 0;
	static char outbuffer[BUFSIZ];
	static char inbuffer[BUFSIZ];

	/* optional input arg */
	if (argc > 1) {
		if ((in = fopen(argv[1], "rt")) == NULL) {
			perror(argv[1]);
			exit(1);
		}
		argv++; argc--;
	} else
		in = stdin;

#ifdef NEVER
	if (argc != 1) {
		printf("Usage: uudecode [infile] [infile...]\n");
		exit(2);
	}
#endif

    while(1) {	/* loop through multiple input files */
	setbuf(in, inbuffer);

	/* search for header line */
	for (;;) {
		if (fgets(buf, sizeof buf, in) == NULL) {
			fprintf(stderr, "No begin line, segment %d\n",
				segment_nbr);
			exit(3);
			}
		if (strncmp(buf, "begin ", 6) == 0)
			break;
		}
	sscanf(buf, "begin %o %s segment %d of %d", &mode, dest,
			&segment_nbr, &num_segments);

	if ((++last_segment_nbr) != segment_nbr) 
		fprintf(stderr,
		"File segments may be missing before segment %d of %d\n",
				segment_nbr, num_segments);
	if (num_segments > 1)
		fprintf(stderr, "Decoding file segment %d of %d\n", segment_nbr,
				num_segments);

#ifdef UNIX
	/* handle ~user/file format */
	if (dest[0] == '~') {
		char *sl;
		struct passwd *getpwnam();
		char *index();
		struct passwd *user;
		char dnbuf[100];

		sl = index(dest, '/');
		if (sl == NULL) {
			fprintf(stderr, "Illegal ~user\n");
			exit(3);
		}
		*sl++ = 0;
		user = getpwnam(dest+1);
		if (user == NULL) {
			fprintf(stderr, "No such user as %s\n", dest);
			exit(4);
		}
		strcpy(dnbuf, user->pw_dir);
		strcat(dnbuf, "/");
		strcat(dnbuf, sl);
		strcpy(dest, dnbuf);
	}
#endif

	if (last_segment_nbr == 1) {
	
		/* create output file */
		out = fopen(dest, "wb");
		if (out == NULL) {
			perror(dest);
			exit(4);
			}
		chmod(dest, mode);
		setbuf(out, outbuffer);
		}

	decode(in, out);

	if (fgets(buf, sizeof buf, in) == NULL || strcmp(buf, "end\n")) {
		fprintf(stderr, "No end line\n");
		exit(5);
		}

    fclose(in);
    if (argc <= 1) {
	if (last_segment_nbr != num_segments)
		fprintf(stderr, "Missing files segments between %d and %d\n",
				last_segment_nbr, num_segments);
	exit(0);	/* quit if last input file */
	}
    if ((in = fopen(argv[1], "rt")) == NULL) {
			perror(argv[1]);
			exit(1);
			}
    argv++; argc--;
    } /* end of while on multiple input files */
    exit(0);
}

/*
 * copy from in to out, decoding as you go along.
 */
decode(in, out)
FILE *in;
FILE *out;
{
	char buf[80];
	char *bp;
	int n;

	for (;;) {
		/* for each input line */
		if (fgets(buf, sizeof buf, in) == NULL) {
			perror("Short file");
			exit(10);
		}
		n = DEC(buf[0]);
		if (n <= 0)
			break;

		bp = &buf[1];
		while (n > 0) {
			outdec(bp, out, n);
			bp += 4;
			n -= 3;
		}
	}
}

/*
 * output a group of 3 bytes (4 input characters).
 * the input chars are pointed to by p, they are to
 * be output to file f.  n is used to tell us not to
 * output all of them at the end of the file.
 */
outdec(p, f, n)
char *p;
FILE *f;
{
	int c1, c2, c3;

	c1 = DEC(*p) << 2 | DEC(p[1]) >> 4;
	c2 = DEC(p[1]) << 4 | DEC(p[2]) >> 2;
	c3 = DEC(p[2]) << 6 | DEC(p[3]);
	if (n >= 1)
		putc(c1, f);
	if (n >= 2)
		putc(c2, f);
	if (n >= 3)
		putc(c3, f);
}


/* fr: like read but stdio */
int
fr(fd, buf, cnt)
FILE *fd;
char *buf;
int cnt;
{
	int c, i;

	for (i=0; i<cnt; i++) {
		c = getc(fd);
		if (c == EOF)
			return(i);
		buf[i] = c;
	}
	return (cnt);
}

/*
 * Return the ptr in sp at which the character c appears;
 * NULL if not found
 */

#define	NULL	0

char *
index(sp, c)
register char *sp, c;
{
	do {
		if (*sp == c)
			return(sp);
	} while (*sp++);
	return(NULL);
}
