/* biff - accept or refuse new mail messages from comsat

   Usage: biff [yn]

   David MacKenzie
   public domain
   Latest revision: 08/19/89 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <varargs.h>

char *ttyname ();

char *any_ttyname ();
void msg_perror_fatal ();
void usage ();

char *program_name;

int
main (argc, argv)
     int argc;
     char **argv;
{
  struct stat stats;
  char *tty;

  program_name = argv[0];
  tty = any_ttyname ();
  if (tty == NULL)
    {
      fprintf (stderr, "%s: Not connected to a terminal\n", argv[0]);
      exit (1);
    }
  if (stat (tty, &stats) == -1)
    msg_perror_fatal ("Cannot stat %s", tty);
  switch (argc)
    {
    case 1:
      printf ("is %c\n", (stats.st_mode & S_IEXEC) ? 'y' : 'n');
      break;
    case 2:
      if (*argv[1] == '-')
	++argv[1];		/* Allow '-y' or 'y'. */
      switch (*argv[1])
	{
	case 'y':
	  if (chmod (tty, stats.st_mode | S_IEXEC) == -1)
	    msg_perror_fatal ("Cannot change mode of %s", tty);
	  break;
	case 'n':
	  if (chmod (tty, stats.st_mode & ~S_IEXEC) == -1)
	    msg_perror_fatal ("Cannot change mode of %s", tty);
	  break;
	default:
	  usage ();
	}
      break;
    default:
      usage ();
    }
  exit (0);
  /* NOTREACHED */
}

char *
any_ttyname ()
{
  char *tty;

  tty = ttyname (2);
  if (tty)
    return tty;
  tty = ttyname (1);
  if (tty)
    return tty;
  tty = ttyname (0);
  if (tty)
    return tty;
  return NULL;
}

/* ANSI C function. */

char *
strerror (n)
     int n;
{
  extern char *sys_errlist[];
  extern int sys_nerr;

  return n >= 0 && n < sys_nerr ? sys_errlist[n] : "Unknown error";
}

/* Print "program_name: str_and_optional_args: perror_message" on stderr,
   then exit with error status. */
/* VARARGS */
void
msg_perror_fatal (str, va_alist)
     char *str;
     va_dcl
{
  va_list args;
  extern int errno;
  int save_errno;

  save_errno = errno;
  fprintf (stderr, "%s: ", program_name);
  va_start (args);
  vfprintf (stderr, str, args);
  va_end (args);
  fprintf (stderr, ": %s\n", strerror (save_errno));
  exit (1);
}

void
usage ()
{
  fprintf (stderr, "Usage: %s [yn]\n", program_name);
  exit (1);
}
