/* Local Mail Interceptor to handle interface to comsat */
/* Args for local mail are  [ -r sender ] parties ... */
/* Jim Mattson <mattson%cs@ucsd.edu> */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>

#define FIFO "/usr/tmp/comsat.fifo"
#define MAILDIR "/usr/spool/mail"
#define MAILER "/usr/lib/mail/mail.orig"

main(argc, argv)
int argc;
char **argv;
{
	off_t *offsets;		/* Mailbox offsets before delivery */
	struct stat stbuf;	/* For stat'ing mailboxes */
	char **av = argv;	/* Old argv */
	int fd;			/* file descriptor for FIFO */
	FILE *fp;		/* File pointer for FIFO */
	int rc;			/* Return Code from local mailer */
	int i;

	/* Get rid of program name and [ -r sender ] */
	argc--;
	argv++;
	if(!strcmp(argv[0], "-r")) {
		argc -= 2;
		argv += 2;
	}
	if(argc == 0)
		exit(0);

	if((offsets = (off_t *)malloc(sizeof(off_t) * argc)) == NULL)
		bailout(av);

	/* Get mailbox offsets */
	if(chdir(MAILDIR) < 0)
		bailout(av);
	for(i = 0; i < argc; i++) {
		if(stat(argv[i], &stbuf) < 0)
			offsets[i] = 0;
		else
			offsets[i] = stbuf.st_size;
	}

	/* Send mail and wait for exit code */
	switch(fork()) {
	case -1:
	case 0:
		bailout(av);	/* No return */
	default:
		wait(&rc);
	}
	/* Send messages to comsat if it's listening */
	if((fd = open(FIFO, O_WRONLY | O_NDELAY)) >= 0) {
		if((fp = fdopen(fd, "w")) != NULL) {
			for(i = 0; i < argc; i++)
				fprintf(fp, "%s@%d\n", argv[i], offsets[i]);
			fclose(fp);
		}
		close(fd);
	}
	/* Exit with local mailer's return code */
	exit(rc >> 8);
}

bailout(argv)
char **argv;
{
	argv[0] = MAILER;
	execv(MAILER, argv);
	_exit(0);
}
