
/*
**  Miscellaneous support functions for smtp (borrowed from smail)
*/

# include	"smtp.h"
#ifdef BSD
# include	<sys/timeb.h>
#endif
#ifdef SYSV
# include	<sys/utsname.h>
#endif

char hostdomain[256];
char hostname[256];

extern struct tm *localtime();

struct tm *gmt, *loc;		/* GMT and local time structure	*/
time_t now;			/* current system time		*/
char nows[50];			/* time in ctime format		*/
char arpanows[50];		/* time in arpa format		*/

setdates()
{
	time_t time();
	struct tm *gmtime();
	char *ctime(), *arpadate();

	(void) time(&now);
	(void) strcpy(nows, ctime(&now));
	gmt = gmtime(&now);
	loc = localtime(&now);
	(void) strcpy(arpanows, arpadate(nows));
}

/*
**  Note: This routine was taken from sendmail
**
**  ARPADATE -- Create date in ARPANET format
**
**	Parameters:
**		ud -- unix style date string.  if NULL, one is created.
**
**	Returns:
**		pointer to an ARPANET date field
**
**	Side Effects:
**		none
**
**	WARNING:
**		date is stored in a local buffer -- subsequent
**		calls will overwrite.
**
**	Bugs:
**		Timezone is computed from local time, rather than
**		from whereever (and whenever) the message was sent.
**		To do better is very hard.
**
**		Some sites are now inserting the timezone into the
**		local date.  This routine should figure out what
**		the format is and work appropriately.
*/

char *
arpadate(ud)
	register char *ud;
{
	register char *p;
	register char *q;
	static char b[40];
	extern char *ctime();
	register int i;
#ifndef BSD
	extern char *tzname[];
	extern long timezone;
	char dspace[40];
	time_t t, time();
	int dst;			/* dst active */
	long tz;
#else
	/* V7 and 4BSD */
	struct timeb t;
	extern struct timeb *ftime();
	extern char *timezone();
#endif

	/*
	**  Get current time.
	**	This will be used if a null argument is passed and
	**	to resolve the timezone.
	*/

#ifndef BSD
	(void) time(&t);
	if (ud == NULL)
		ud = ctime(&t);
#else
	/* V7 or 4BSD */
	ftime(&t);
	if (ud == NULL)
		ud = ctime(&t.time);
#endif

	/*
	**  Crack the UNIX date line in a singularly unoriginal way.
	*/

	q = b;

	p = &ud[0];		/* Mon */
	*q++ = *p++;
	*q++ = *p++;
	*q++ = *p++;
	*q++ = ',';
	*q++ = ' ';

	p = &ud[8];		/* 16 */
	if (*p == ' ')
		p++;
	else
		*q++ = *p++;
	*q++ = *p++;
	*q++ = ' ';

	p = &ud[4];		/* Sep */
	*q++ = *p++;
	*q++ = *p++;
	*q++ = *p++;
	*q++ = ' ';

	p = &ud[22];		/* 1979 */
	*q++ = *p++;
	*q++ = *p++;
	*q++ = ' ';

	p = &ud[11];		/* 01:03:52 */
	for (i = 8; i > 0; i--)
		*q++ = *p++;

				/* -PST or -PDT */
#ifndef BSD
	dst = localtime(&t)->tm_isdst;
	tz = timezone - (dst ? 3600 : 0);
	p = tzname[dst];
#else
	p = timezone(t.timezone, localtime(&t.time)->tm_isdst);
	if (p[3] != '\0')
	{
		/* hours from GMT */
		p += 3;
		*q++ = *p++;
		if (p[1] == ':')
			*q++ = '0';
		else
			*q++ = *p++;
		*q++ = *p++;
		p++;		/* skip ``:'' */
		*q++ = *p++;
		*q++ = *p++;
	}
	else
#endif
	{
		*q++ = ' ';
		while (*p) *q++ = *p++;
	}
#ifndef BSD
	if (tz != 0) {
		(void) sprintf (q, " (%c%02d%02d)", 
			((tz > 0) ? '-' : '+'),
			abs(tz/3600),
			abs(tz%3600)/60);
		q += strlen (q);
	}
#endif

	*q = '\0';
	return (b);
}

/*
**
**  getmynames(): what is my host name and host domain?
**
**  Hostname set by -h, failing that by #define HOSTNAME, failing
**  that by gethostname() or uname().
**  
**  Hostdomain set by -h, failing that by #define HOSTDOMAIN,
**  failing that as hostname.MYDOM, or as just hostname.
**
**  See defs.h for the inside story.
**
*/

getmynames()
{
#ifdef HOSTNAME
	if (!*hostname)
		(void) strcpy(hostname, HOSTNAME);
#endif
#ifdef BSD
	if (!*hostname)
		gethostname(hostname, SMLBUF - 1);
#endif
#ifdef SYSV
	if (!*hostname) {
		struct utsname site;

		if (uname(&site) == 0)
			(void) strcpy(hostname, site.nodename);
	}
#endif
	if (!*hostname)
		return -1;
#ifdef HOSTDOMAIN
	if (!*hostdomain)
		(void) strcpy(hostdomain, HOSTDOMAIN);
#endif
#ifdef MYDOM
	if (!*hostdomain)
		(void) strcat(strcpy(hostdomain, hostname), MYDOM);
#endif
	if (!*hostdomain)
		(void) strcpy(hostdomain, hostname);

	return 1;
}
