/*
** Various pieces of configuration for comsat
*/

/*
** If SECUREBIFF is defined, comsat will only accept datagrams from privileged
** (<1024) port numbers.  This is to prevent users from sending "biff bombs"
** to each other by sending messages to the server.  Note that /bin/mail may
** have to be modified for this to work, as it does not normally use a secure
** port to talk to comsat.
*/
/*#define SECUREBIFF*/

/*
** Set ROLLCALL to the number of seconds between "roll calls" -- a roll call
** checks to see that all the remote users who are watching someone are still
** logged in.
*/
#define ROLLCALL	120

/*
** These are the default port numbers to use, if we can't find the biff
** entry in /etc/services.
*/
#define UDP_PORT	512
#define TCP_PORT	522

/*
** Mail header fields we print in a mail notification.
*/
char *fields[] = {
"From: ",
"Subject: ",
"To: ",
"Date: "
};

/*
** Directory where users' mailboxes are kept.
*/
#define MAILDIR		"/usr/spool/mail"

/*
** Location of utmp file.
*/
#define UTMP		"/etc/utmp"

/*
** Directory to search for tty devices.
*/
#define DEVDIR		"/dev"

#define Nfields (sizeof(fields)/sizeof(fields[0]))
