/*
 *	$Source: /pozzo/usr/src.LOCAL/cmd/pmdc/RCS/runtime.c,v $
 *	$Author: rlk $
 *	$Locker:  $
 *	$Header: /pozzo/usr/src.LOCAL/cmd/pmdc/RCS/runtime.c,v 1.5 88/07/14 17:37:54 rlk Exp $
 */

#ifndef lint
static char *rcsid_runtime_c = "$Header: /pozzo/usr/src.LOCAL/cmd/pmdc/RCS/runtime.c,v 1.5 88/07/14 17:37:54 rlk Exp $";
#endif	lint

#include "pmd.h"
#include <stdio.h>
#include <sys/file.h>
#include <sysexits.h>
#include <strings.h>
#include <ndbm.h>
#include <sys/time.h>

#define LOCKTIME 15		/* Time to wait while grabbing a lock */
#define MAXTIME	10		/* Number of locks to wait through */
#define TIMEFIELD "_pptime"	/* Time of first database entry */

#define LSIZE 512		/* Size of various lines */

char *pptemp;			/* Temporary file */
FILE *ppin;			/* Temporary file filepointer */
char ppline[MAXLINELEN];	/* Input line buffer */
int pperr;			/* Error flag */
datum ppkey, ppcount;		/* For statistical routines */


/*
 * Sets up pptemp and pperr, then calls ppact to do the real work.
 * Cleans up on error.
 */
main()
{
    char *mktemp();

    /* If we can't chdir to home, we're scrod */
    if(chdir(pphome) != 0) {
	fprintf(stderr, "Pmd: mail directory %s does not exist!\n", pphome);
	exit(EX_TEMPFAIL);
    }
    pperr = 0;
    pptemp = mktemp("/tmp/pmdXXXXXX");
    if(ppfcat(pptemp) == 0) {
	fprintf(stderr, "Can't write to temp file %s\n", pptemp);
	exit(EX_TEMPFAIL);
    }
    if((ppin = fopen(pptemp, "r")) == NULL) {
	fprintf(stderr, "Can't read temp file %s\n", pptemp);
	exit(EX_TEMPFAIL);
    }
    ppinc("Total messages");
    ppact();
    if ((fsync (fileno (ppin))) || (fclose (ppin))) {
        fprintf (stderr, "Can't close temp file %s\n", pptemp);
	exit(EX_TEMPFAIL);
      }
    if(pperr) {
	ppinc("Dead letters");
	ppputact(pperrf);	/* If this fails, we can do nothing */
    }
    unlink(pptemp);
    exit(0);
}

/* Do a system call, with input from pptemp */
/* Sets pperr if there is an error */
pprunact(action)
char *action;
{
  char line[LSIZE];

  strcpy(line, action);
  strcat(line, " < ");
  strcat(line, pptemp);
  if(system(line) != 0) pperr++;	/* Check to see that the pipe works */
}

/* Appends pptemp to file, flocking file to prevent lossage */
/* Sets pperr on error */
ppputact(file)
char *file;
{
  FILE *f1, *f2;
  int fd, rmail, mmdf;
  char line[LSIZE], *fgets();
  long end, ftell();

  if((f2=fopen(pptemp, "r")) == NULL) {
    pperr++;
    return;
  }

  if((fd=open(file, (O_CREAT | O_APPEND | O_WRONLY), ppmode|0200)) < 0) {
    pperr++;
    return;
  }

  flock(fd, LOCK_EX);		/* Lock the file */
  
  if((f1=fdopen(fd, "a")) == NULL) {
    close(fd);
    pperr++;
    return;
  }

  fseek(f1, 0L, 2);
  end=ftell(f1);
  
  /* Everything ok, copy file */
  /* Do this line-at-a-time so we can test for from lines */
  /* Note: this is somewhat specialized for mailbox format */
  /* We need to put a from line on if none exists */
  if(fgets(line, LSIZE, f2) == NULL) goto wrerr;
  rmail = !strcmp (ppformat, "rmail");
  mmdf = !strcmp (ppformat, "mmdf");

  if(rmail) fprintf (f1, "\014\n0, unseen,,\n*** EOOH ***\n");
  else if (mmdf) fprintf (f1, "\001\001\001\001\n");
  else if(!isin("from ", line)) {
    struct timeval tp;
    struct timezone tzp;
    
    gettimeofday(&tp, &tzp);
    fprintf(f1, "From Personal_Mail_Daemon  %s\n", ctime(&(tp.tv_sec)));
  }
  else fputs(line, f1);

  /* After the first line, all postmark lines get prefixed */
  while(fgets(line, LSIZE, f2) != NULL) {
    if(isin("from ", line) && !rmail && !mmdf) {
      if('>' != putc('>', f1)) goto wrerr;
    }
    if (isin ("\037", line) && rmail)
      fprintf (f1, "^_%s", line + 1);
    else
      fputs(line, f1);
  }

  if (rmail) fprintf (f1, "\037");
  else if (mmdf) fprintf (f1, "\001\001\001\001\n");

  if(fflush(f1) == EOF || ferror(f1)) {
  wrerr:
    ftruncate(fd, (int) end);	/* Cast to int to get lint to shut up */
    close(fd);
    pperr++;
    return;
  }

  if (fsync (fd)) {
    ftruncate(fd, (int) end);	/* Cast to int to get lint to shut up */
    fprintf (stderr, "Can't close temp file %s\n", pptemp);
    close (fd);
    exit(EX_TEMPFAIL);
  }
  close(fd);
  return;
}

/* Barf out this message with argument as error string */
/* NEVER RETURNS */
ppbarfact(error)
char *error;
{
    ppinc("Bounced messages");
    ppinc("Total messages");
    fprintf(stderr, "PMD error: %s\n", error);
    unlink(pptemp);
    exit(EX_UNAVAILABLE);
}

/* Cat standard input to file */
ppfcat(file)
char *file;
{
  FILE *f;
  int fd;
  char c;

  if((fd=open(file,  (O_CREAT | O_EXCL | O_WRONLY), ppmode|0600)) < 0) {
    return(0);
  }

  if((f=fdopen(fd, "w")) == NULL) {
    close(fd);
    return(0);
  }

  /* Everything ok, cat to file */
  while((c=getchar()) != EOF)
    if(c != putc(c, f)) goto wrerr;
  if('\n' != putc('\n', f)) goto wrerr; /* Add a newline */

  if((fflush(f) == EOF) || (fsync (fileno (f)))) {
  wrerr:
    close(fd);
    unlink(file);		/* This is a temporary, so clean up */
    return(0);
  }

  close(fd);
  return(1);
}

/* Returns 1 iff s1 matches s2 (ignoring case) for the length of s1 */
isin(s1, s2)
char *s1, *s2;
{
#ifdef DEBUG
    printf("isin(%s, %s)\n", s1, s2);
#endif DEBUG
    for(; *s1; s1++, s2++) {
	if(((*s1 | 0x20) != (*s2 | 0x20)) /* Ctype's tolower loses big */
	   || *s2 == '\0'
	   || *s2 == '\n') return(0);
    }
#ifdef DEBUG
    puts("Returning true");
#endif    
    return(1);
}

/* Returns 1 iff ppline is a header line of type field which contains val */
pphead(field, val)
char *field, *val;
{
    register char *p;

#ifdef DEBUG
    printf("pphead(%s, %s) applied to %s\n", field, val, ppline);
#endif    
    if(*field != '\0') {	/* If "", don't match field */
	if(!isin(field, ppline)) return(0);	/* Not of type field */
	p = ppline + strlen(field);
	if(*p++ != ':') return(0);	/* Header field too long */
    } else {			/* We don't care about field */
	p = ppline;
    }
    for(; *p; p++) {
	if(isin(val, p)) return(1); /* Bingo */
    }
    return(0);			/* You lose */
}

/*
 * Returns true iff ppline contains val
 */
ppbody(val)
char *val;
{
    register char *p;

#ifdef DEBUG
    printf("ppbody(%s) applied to %s\n", val, ppline);
#endif
    for(p = ppline; *p; p++) {
	if(isin(val, p)) return(1);
    }
    return(0);
}

/*
 * Increment counter in ppdbfile associated with key
 * Returns 0 if successful, <0 otherwise.
 */
ppinc(key)
char *key;
{
    DBM *db;
    int result, lock, lockcount;
    unsigned long count;

    /* We use ppdbfile itself for locking */
    for(lockcount = 0;
	(lock = open(ppdbfile, O_CREAT|O_EXCL, 0)) < 0;
	lockcount++) {
	    sleep(LOCKTIME);
	    if(lockcount > MAXTIME) { /* Give up */
		unlink(ppdbfile); /* File is garbage */
		lock = open(ppdbfile, O_CREAT, 0);
		break;
	    }
	}
    /* No need to waste file descriptors */
    if(lock > 0) close(lock);

    /* We have the lock, update the database */
    if((db = dbm_open(ppdbfile, O_CREAT|O_RDWR, ppmode|0600)) == NULL) {
	return(-1);
    }

    /* Check the time settings */
    ppkey.dptr = TIMEFIELD;
    ppkey.dsize = strlen(ppkey.dptr)+1;
    ppcount = dbm_fetch(db, ppkey);
    if(ppcount.dptr == NULL) {
	struct timeval tp;
	struct timezone tzp;

	gettimeofday(&tp, &tzp);
	ppcount.dptr = ctime(&(tp.tv_sec));
	ppcount.dsize = strlen(ppcount.dptr)+1;
	dbm_store(db, ppkey, ppcount, DBM_INSERT);
    }

    ppkey.dptr = key;
    ppkey.dsize = strlen(key)+1;
    ppcount = dbm_fetch(db, ppkey);
    if(ppcount.dptr == NULL) {
	count = 0;
    } else {
	count = *((unsigned long *) ppcount.dptr);
    }
    count++;
    ppcount.dptr = (char *) &count;
    ppcount.dsize = sizeof(count);
    result = dbm_store(db, ppkey, ppcount, DBM_REPLACE);
    dbm_close(db);

    /* Relase the lock */
    unlink(ppdbfile);

    return(result);
}

/* Fgethdr; like fgets, but eats newlines that are internal to a header line */
char *fgethdr(line, size, stream)
char *line;
int size;
FILE *stream;
{
    char *cur, c;

    if(feof(stream)) return(NULL);

    for(cur=line; size>2; cur++, size--) {
	switch(*cur=getc(stream)) {
	  case(EOF):
	    goto done;
          case('\n'):
	    if(cur != line && isspace(c=getc(stream)) && c != '\n') {
	    	*cur=c;
		break;
	    } else {
		ungetc(c, stream);
	    	goto done;
	    }
    	  default:
	    break;
      }
    }
  done:
    *cur++='\n';		/* For fgets compatibility */
    *cur=NULL;
    return(line);
}
