/*
 *	$Source: /@/source/4.3/watchmkr/pmdc/RCS/pmdc.y,v $
 *	$Author: asp $
 *	$Locker:  $
 *	$Header: pmdc.y,v 2.10 87/02/10 11:54:00 asp Exp $
 */

%{
#include <stdio.h>

#define DSLP	ds("(")
#define	DSRP	ds(")")
#define DSOR	ds(" || ")
#define DSAND	ds(" && ")
#define DSNOT	ds("!")

#define P(x)		cat(DSLP, x, DSRP)
#define POR(x,y)	P(cat(x, DSOR, y))
#define PAND(x,y)	P(cat(x, DSAND, y))
#define PNOT(x)		P(cat(DSNOT, x, NULL))

char *cat(), *ds(), *headrule(), *bodyrule(), *def_rule(), *def_global();
char *malloc();

char *defs = NULL;		/* Header definitions */
char *hrules = NULL;		/* Header rules */
char *brules = NULL;		/* Body rules */

char *home, *mode;	/* Set using declarator commands */
char *errorfile, *dbfile, *format;

int errorflag;			/* Global error flag.  Determines exit code */


%}

%union {
	char *dynstr;
}

%token	HOME MODE ERR DB FORMAT	/* Option declarators */
%token	IF THEN OTHERWISE END
%token	NOT AND OR LEFTP RIGHTP
%token	IS HEADER BODY CONTAINS FROM TO
%token	<dynstr> STRING
%token	<dynstr> NUM
%token	RUN PUT BARF SEMICOLON

%type	<dynstr>    rules rule default expr pred phrase word actions action

%left OR
%left AND
%left NOT

%start prog

%%
prog	:   decls rules default
		{ make_pmd(cat($2, $3, NULL)); }
	|   error
	;

rules	:   rules rule
	    { $$ = cat($1, $2, NULL); }
	|   /* empty */
	    { $$ = NULL; }
	;

rule	:   IF expr THEN actions END
	    {
	      $$ = cat(ds("\nif("),
		       cat($2,
			   ds(") {\n"),
			   $4),
		       ds("\nreturn;\n}\n"));
	    }
	|   error
	    { $$ = NULL; }
	;
expr	:   NOT expr
		{ $$ = PNOT($2); }
	|   expr AND expr
		{ $$ = PAND($1, $3); }
	|   expr OR expr
		{ $$ = POR($1, $3); }
	|   LEFTP expr RIGHTP
		{ $$ = P($2); }
	|   pred
	;

pred	:   IS FROM phrase
		{
		    $$ = POR(POR(headrule(ds($3), ds("from")),
				 headrule(ds($3), ds("sender"))),
			     POR(POR(headrule(ds($3), ds("resent-from")),
				     headrule(ds($3), ds("apparently-from"))),
				 headrule(ds($3), ds("resent-by"))));
		    free($3);	/* Must be freed explicitly */
		}
	|   IS TO phrase
		{
		    $$ = POR(POR(headrule(ds($3), ds("to")),
				 headrule(ds($3), ds("cc"))),
			     POR(POR(headrule(ds($3), ds("bcc")),
				     headrule(ds($3), ds("resent-to"))),
				 POR(headrule(ds($3), ds("forwarded-to")),
				     headrule(ds($3), ds("apparently-to")))));
		    free($3);	/* Must be freed explicitly */
		}

	|   word IS phrase
		{ $$ = headrule($3, $1); }
	|   TO IS phrase
	    	{ $$ = headrule($3, ds("to")); }
	|   FROM IS phrase
	    	{ $$ = headrule($3, ds("from")); }
	|   HEADER CONTAINS phrase
		{ $$ = headrule($3, NULL); }
	|   BODY CONTAINS phrase
		{ $$ = bodyrule($3); }
	|   CONTAINS phrase
		{
		    $$ = POR(headrule(ds($2), NULL),
			     bodyrule(ds($2)));
		    free($2);
		}
	;

actions	:   actions SEMICOLON action
		{ $$ = cat($1, $3, NULL); }
	|   actions action
		{ $$ = cat($1, $2, NULL); }
	|   action
	;

action	:   RUN phrase
		{
		  $$ = cat(ds("pprunact(\""),
			   $2,
			   ds("\");\n"));
		}
	|   PUT STRING
		{
		  $$ = cat(ds("ppputact(\""),
			   $2,
			   ds("\");\n"));
		}
	|   IS phrase
	    	{
		    $$ = cat(ds("ppinc(\""),
			     $2,
			     ds("\");\n"));
		}
	|   BARF phrase
		{
		    $$ = cat(ds("ppbarfact(\""),
			     $2,
			     ds("\");\n"));
		}
	|   /* empty */
		{ $$ = ds(";"); }
	|   error
	    { $$ = NULL; }
	;

decls	:   decls decl
	|   ;

decl	:   HOME IS STRING
		{ free(home); home = $3; }
	|   MODE IS NUM
		{ free(mode); mode = $3; }
	|   ERR IS STRING
		{ free(errorfile); errorfile = $3; }
	|   DB IS STRING
		{ free(dbfile); dbfile = $3; }
	|   FORMAT IS STRING
                { free(format); format = $3; }
	|   error   ;

default	:   OTHERWISE actions END
		{ $$ = cat(ds("{\n"), $2, ds("\nreturn;\n}")); }
	;

phrase	:   phrase STRING
		{
		    $$ = cat($1, ds(" "), $2);
		}
	|   STRING
	;

word	:   STRING
    	    	{
		    if(index($1, ' ') || index($1, '\t') ||
		       index($1, ':')) {
			yyerror("illegal character in header field");
			YYERROR;
		    }
		    $$ = $1;
		}
	;

%%


main()
{
#ifdef YYDEBUG
    extern int yydebug;
    yydebug = 1;
#endif
    errorflag = 0;
    hrules = brules = defs = NULL;
    mode = ds("0664");
    home = ds(getenv("HOME"));
    errorfile = ds("pmd.dead.letter");
    dbfile = ds(".pmd.stats");
    format = ds("mail");
    yyparse();
    exit(errorflag);
}

yyerror(s)
char *s;
{
    extern int yylineno;

    fprintf(stderr, "%d: %s\n", yylineno, s);
    errorflag |= 1;		/* Set the error flag */
}

/*
 * Support for dynamic strings:
 * cat creates a string from three input strings.
 * The input strings are freed by cat (so they better have been malloced).
 * ds makes a malloced string from one that's not.
 * (Stolen from cdecl source)
 */

char *cat(s1,s2,s3)
char *s1,*s2,*s3;
{
    register char *newstr;
    register unsigned len = 1;

    if (s1 != NULL) len += strlen(s1);
    if (s2 != NULL) len += strlen(s2);
    if (s3 != NULL) len += strlen(s3);
    newstr = malloc(len);
    *newstr = NULL;
    if (s1 != NULL) {
	strcat(newstr,s1);
	free(s1);
    }
    if (s2 != NULL) {
	strcat(newstr,s2);
	free(s2);
    }
    if (s3 != NULL) {
	strcat(newstr,s3);
	free(s3);
    }
    return(newstr);
}

char *ds(s)
char *s;
{
    register char *p;

    p = malloc((unsigned)(strlen(s) + 1));
    strcpy(p,s);
    return p;
}

/*
 * Rule constructors
 */

/*
 * Headrule creates a new rule in defs and rules, and returns the name of
 * the flag associated with the rule.  It destroys its arguments.
 */
char *headrule(val, field)
char *val;
char *field;
{
    char *name;

    name = def_rule();

    /* If field is NULL, rule field should be "" */
    if(field == NULL) field = ds("");
    hrules = cat(hrules,
		 cat(cat(ds("if(pphead(\""),
			 field,
			 ds("\", \"")),
		     cat(val,
			 ds("\")) "),
			 ds(name)),
		     ds("++;\n")),
		 NULL);
    return(name);
}

/*
 * Bodyrule defines a rule which fires if val is in the message body,
 * and returns the name of that rule.  It destroys its argument.
 */
char *bodyrule(val)
char *val;
{
    char *name;

    name = def_rule();

    brules = cat(brules,
		 cat(ds("if(ppbody(\""),
		     cat(val,
			 ds("\")) "),
			 ds(name)),
		     ds("++;\n")),
		 NULL);
    return(name);
}

/*
 * Defines a new rule name in the global variable defs.
 * Returns the new name.  All names generated are unique.
 */
char *def_rule()
{
    char rulename[20];
    static long lastname = 0;
    extern char *defs;

    strcpy(rulename, "ppr");
    sprintf(rulename + strlen(rulename), "%ld", lastname++);

    /* Define the rule flag */
    defs = cat(defs,
	       ds("\nint "),
	       cat(ds(rulename),
		   ds(" = 0;\n"),
		   NULL));
    return(ds(rulename));
}

/*
 * Puts a null-terminated array of strings to stdout, one to a line.
 */
put_block(block)
char *block[];
{
    char **ptr;

    for(ptr = block; *ptr; ptr++) puts(*ptr);
}

/* Top of definitions */
char *def_head[] = {
    "#include \"pmd.h\"",
    (char *) NULL };

/* Top of ppact */
char *ppacthead[] = {
    "ppact()",
    "{",
    "char *fgets(), *fgethdr();",
    "while(fgethdr(ppline, MAXLINELEN, ppin) != NULL && *ppline != '\\0') {",
    (char *) NULL };

/* In ppact, between header rules and body rules */
char *ppactbody[] = {
    "}",			/* End of while */
    "while(fgets(ppline, MAXLINELEN, ppin) != NULL) {",
    (char *) NULL };

/* In ppact, after brules but before actions */
char *ppactact[] = {
    "}",				/* End of while in ppactbody */
    (char *) NULL };

/* End of ppact */
char *ppacttail[] = {
    "}",			/* End of ppact */
    (char *) NULL};

/*
 * Creates the pmd source file.
 *
 * Make_pmd prints this file to stdout, destroying [hb]rules, defs, and its
 * argument.
 */
make_pmd(acts)
char *acts;
{

    /* Definitions section */
    put_block(def_head);
    free_puts(cat(cat(def_global("pphome", home),
		      cat(ds("\nint ppmode=0"), mode, ds(";\n")),
		      cat(def_global("pperrf", errorfile), ds("\n"),
			  cat(def_global("ppformat", format), ds("\n"),
			      def_global("ppdbfile", dbfile)))),
		  defs,
		  NULL));
	   
	      /* Rules section */
	      put_block(ppacthead);
	      free_puts(hrules);
	      put_block(ppactbody);
	      free_puts(brules);
	      put_block(ppactact);
	      free_puts(acts);
	      put_block(ppacttail);
	  }

/*
 * Like puts, only destroys its argument.
 */
free_puts(ds)
char *ds;
{
  if (ds) {
    puts(ds);
    free(ds);
  }
}

/*
 * First argument is a normal string, second is a dynstr which is destroyed.
 * Generates a char * variable definition of var as val.
 */
char *def_global(var, val)
char *var;
char *val;
{
    return(cat(cat(ds("\nchar *"),
		   ds(var),
		   ds("=")),
	       cat(ds("\""),
		   val,
		   ds("\";\n")),
	       NULL));
}
