#!/bin/csh -f
# User interface for pmdc.  Compiles and installs a Personal Mail Daemon.
#
# Usage: install_pmd [-A] rules-file [pmd-file-name]
#

# this is the home directory for the pmdc system.
# it will need to be changed depending on where the system is installed
set pmdc=/usr/local/lib/pmdc

if($#argv > 1 && $1 == '-A') then
    set athena
    shift
else if($#argv > 1 && $1 == '-n') then
    set noforward
    shift
endif

if($#argv == 0 || $#argv > 2) then
    echo "Usage: install_pmd [-A] rules-file [pmd-file-name]"
    exit 1
else if($#argv == 1) then
    set pmd=$HOME/.pmd
else if($2 !~ /*) then
    echo "Pmd name must be absolute."
    exit 1
else
    set pmd=$2
endif

echo "Parsing rules file..."
${pmdc}/pmdc < $1 > /tmp/pmdc$$.c
if($status) then
    echo "Cleaning up..."
    rm -f /tmp/pmdc$$.c
    exit 1
endif

echo "Compiling pmd..."
chdir /tmp
cc -o pmdc$$ -O -s -I${pmdc} pmdc$$.c ${pmdc}/runtime.o

if($status) then
    echo "Cleaning up..."
    exit 1
endif

rm -f pmdc$$.c
rm -f pmdc$$.o

if(-e $HOME/.forward && (! $?noforward)) then
    echo "Saving old .forward file..."
    mv -f $HOME/.forward $HOME/.forward.old
endif

echo "Installing new pmd..."

# Here's where we build the .forward file.  Notice difference for athena.
if($?athena) then
    echo \"\|$pmd\"@`hostname`.LOCAL >/tmp/pmdcf$$
else if (! $?noforward) then
    echo \"\|$pmd\" >/tmp/pmdcf$$
endif

# Now do the actual install
mv -f /tmp/pmdc$$ $pmd
chmod 4755 $pmd
if (! $?noforward) then
    mv -f /tmp/pmdcf$$ $HOME/.forward
endif

exit
#
# 	$Source: /pozzo/usr/src.LOCAL/cmd/pmdc/RCS/install_pmd.sh,v $
#	$Author: rlk $
#	$Locker:  $
#	$Header: install_pmd.sh,v 1.2 87/09/28 12:55:53 rlk Exp $
#
