%C
%{
#include    "pmdc.h"
#include    "pmdc.y.h"
#include    <ctype.h>

/* Nuke the output routine */
#undef output
#define output(X) 0
%}

S [ \t\n;\(\)]
C [^ \t\n\";\(\)]
D [0-9]
%%
^#.*$	    	    	;   /* Delete comments */
home/{S}+		return(HOME);
mode/{S}+		return(MODE);
errorfile/{S}+		return(ERR);
statfile/{S}+		return(DB);
format/{S}+		return(FORMAT);
{D}{3,4}/{S}+		{ yylval.dynstr = ds(yytext);
			  return(NUM); 
			  }
if/{S}+			return(IF);
then/{S}+			return(THEN);
otherwise/{S}+		return(OTHERWISE);
end/{S}+			return(END);
not/{S}+			return(NOT);
and/{S}+			return(AND);
or/{S}+			return(OR);
is/{S}+			return(IS);
header/{S}+		return(HEADER);
body/{S}+			return(BODY);
contains/{S}+		return(CONTAINS);
from/{S}+			return(FROM);
to/{S}+			return(TO);
\(			return(LEFTP);
\)			return(RIGHTP);
;			return(SEMICOLON);
run/{S}+			return(RUN);
put/{S}+			return(PUT);
bounce-with-error/{S}+		return(BARF);
\"[^\"\n]*\"/{S}+	{ yytext[yyleng-1] = '\0';
			  yylval.dynstr = ds(yytext+1);
			  return(STRING); }
{C}+/{S}+		{ yylval.dynstr = ds(yytext);
			  return(STRING); }
%%
