
# line 9 "pmdc.y"
#include <stdio.h>

#define DSLP	ds("(")
#define	DSRP	ds(")")
#define DSOR	ds(" || ")
#define DSAND	ds(" && ")
#define DSNOT	ds("!")

#define P(x)		cat(DSLP, x, DSRP)
#define POR(x,y)	P(cat(x, DSOR, y))
#define PAND(x,y)	P(cat(x, DSAND, y))
#define PNOT(x)		P(cat(DSNOT, x, NULL))

char *cat(), *ds(), *headrule(), *bodyrule(), *def_rule(), *def_global();
char *malloc();

char *defs = NULL;		/* Header definitions */
char *hrules = NULL;		/* Header rules */
char *brules = NULL;		/* Body rules */

char *home, *mode;	/* Set using declarator commands */
char *errorfile, *dbfile, *format;

int errorflag;			/* Global error flag.  Determines exit code */



# line 37 "pmdc.y"
typedef union  {
	char *dynstr;
} YYSTYPE;
# define HOME 257
# define MODE 258
# define ERR 259
# define DB 260
# define FORMAT 261
# define IF 262
# define THEN 263
# define OTHERWISE 264
# define END 265
# define NOT 266
# define AND 267
# define OR 268
# define LEFTP 269
# define RIGHTP 270
# define IS 271
# define HEADER 272
# define BODY 273
# define CONTAINS 274
# define FROM 275
# define TO 276
# define STRING 277
# define NUM 278
# define RUN 279
# define PUT 280
# define BARF 281
# define SEMICOLON 282
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 203 "pmdc.y"



main()
{
#ifdef YYDEBUG
    extern int yydebug;
    yydebug = 1;
#endif
    errorflag = 0;
    hrules = brules = defs = NULL;
    mode = ds("0664");
    home = ds(getenv("HOME"));
    errorfile = ds("pmd.dead.letter");
    dbfile = ds(".pmd.stats");
    format = ds("mail");
    yyparse();
    exit(errorflag);
}

yyerror(s)
char *s;
{
    extern int yylineno;

    fprintf(stderr, "%d: %s\n", yylineno, s);
    errorflag |= 1;		/* Set the error flag */
}

/*
 * Support for dynamic strings:
 * cat creates a string from three input strings.
 * The input strings are freed by cat (so they better have been malloced).
 * ds makes a malloced string from one that's not.
 * (Stolen from cdecl source)
 */

char *cat(s1,s2,s3)
char *s1,*s2,*s3;
{
    register char *newstr;
    register unsigned len = 1;

    if (s1 != NULL) len += strlen(s1);
    if (s2 != NULL) len += strlen(s2);
    if (s3 != NULL) len += strlen(s3);
    newstr = malloc(len);
    *newstr = NULL;
    if (s1 != NULL) {
	strcat(newstr,s1);
	free(s1);
    }
    if (s2 != NULL) {
	strcat(newstr,s2);
	free(s2);
    }
    if (s3 != NULL) {
	strcat(newstr,s3);
	free(s3);
    }
    return(newstr);
}

char *ds(s)
char *s;
{
    register char *p;

    p = malloc((unsigned)(strlen(s) + 1));
    strcpy(p,s);
    return p;
}

/*
 * Rule constructors
 */

/*
 * Headrule creates a new rule in defs and rules, and returns the name of
 * the flag associated with the rule.  It destroys its arguments.
 */
char *headrule(val, field)
char *val;
char *field;
{
    char *name;

    name = def_rule();

    /* If field is NULL, rule field should be "" */
    if(field == NULL) field = ds("");
    hrules = cat(hrules,
		 cat(cat(ds("if(pphead(\""),
			 field,
			 ds("\", \"")),
		     cat(val,
			 ds("\")) "),
			 ds(name)),
		     ds("++;\n")),
		 NULL);
    return(name);
}

/*
 * Bodyrule defines a rule which fires if val is in the message body,
 * and returns the name of that rule.  It destroys its argument.
 */
char *bodyrule(val)
char *val;
{
    char *name;

    name = def_rule();

    brules = cat(brules,
		 cat(ds("if(ppbody(\""),
		     cat(val,
			 ds("\")) "),
			 ds(name)),
		     ds("++;\n")),
		 NULL);
    return(name);
}

/*
 * Defines a new rule name in the global variable defs.
 * Returns the new name.  All names generated are unique.
 */
char *def_rule()
{
    char rulename[20];
    static long lastname = 0;
    extern char *defs;

    strcpy(rulename, "ppr");
    sprintf(rulename + strlen(rulename), "%ld", lastname++);

    /* Define the rule flag */
    defs = cat(defs,
	       ds("\nint "),
	       cat(ds(rulename),
		   ds(" = 0;\n"),
		   NULL));
    return(ds(rulename));
}

/*
 * Puts a null-terminated array of strings to stdout, one to a line.
 */
put_block(block)
char *block[];
{
    char **ptr;

    for(ptr = block; *ptr; ptr++) puts(*ptr);
}

/* Top of definitions */
char *def_head[] = {
    "#include \"pmd.h\"",
    (char *) NULL };

/* Top of ppact */
char *ppacthead[] = {
    "ppact()",
    "{",
    "char *fgets(), *fgethdr();",
    "while(fgethdr(ppline, MAXLINELEN, ppin) != NULL && *ppline != '\\0') {",
    (char *) NULL };

/* In ppact, between header rules and body rules */
char *ppactbody[] = {
    "}",			/* End of while */
    "while(fgets(ppline, MAXLINELEN, ppin) != NULL) {",
    (char *) NULL };

/* In ppact, after brules but before actions */
char *ppactact[] = {
    "}",				/* End of while in ppactbody */
    (char *) NULL };

/* End of ppact */
char *ppacttail[] = {
    "}",			/* End of ppact */
    (char *) NULL};

/*
 * Creates the pmd source file.
 *
 * Make_pmd prints this file to stdout, destroying [hb]rules, defs, and its
 * argument.
 */
make_pmd(acts)
char *acts;
{

    /* Definitions section */
    put_block(def_head);
    free_puts(cat(cat(def_global("pphome", home),
		      cat(ds("\nint ppmode=0"), mode, ds(";\n")),
		      cat(def_global("pperrf", errorfile), ds("\n"),
			  cat(def_global("ppformat", format), ds("\n"),
			      def_global("ppdbfile", dbfile)))),
		  defs,
		  NULL));
	   
	      /* Rules section */
	      put_block(ppacthead);
	      free_puts(hrules);
	      put_block(ppactbody);
	      free_puts(brules);
	      put_block(ppactact);
	      free_puts(acts);
	      put_block(ppacttail);
	  }

/*
 * Like puts, only destroys its argument.
 */
free_puts(ds)
char *ds;
{
  if (ds) {
    puts(ds);
    free(ds);
  }
}

/*
 * First argument is a normal string, second is a dynstr which is destroyed.
 * Generates a char * variable definition of var as val.
 */
char *def_global(var, val)
char *var;
char *val;
{
    return(cat(cat(ds("\nchar *"),
		   ds(var),
		   ds("=")),
	       cat(ds("\""),
		   val,
		   ds("\";\n")),
	       NULL));
}
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 41
# define YYLAST 129
short yyact[]={

  28,  42,  68,  50,  28,  59,  60,  63,  51,  80,
  45,  44,  43,  48,  41,  26,  65,  64,  62,  26,
  28,  61,  21,  24,  25,  27,  46,  24,  25,  27,
  46,  30,  20,  19,  31,  26,  33,  37,  38,  39,
  36,  35,  40,  24,  25,  27,  55,  56,  18,  72,
  54,  17,  55,  16,  55,  56,   3,  49,  23,  15,
  22,  14,  11,   6,   7,   8,   9,  10,  29,   5,
   2,   1,  34,  32,  12,  13,   4,   0,   0,   0,
   0,  47,   0,   0,  52,  53,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,  66,   0,  57,
  58,   0,   0,   0,   0,  67,   0,   0,   0,   0,
   0,   0,   0,   0,   0,  69,   0,  73,  74,  75,
  76,  77,  78,  79,  70,  71,   0,   0,  47 };
short yypact[]={

-200,-1000,-194,-1000,-203,-1000,-220,-223,-238,-239,
-249,-1000,-1000,-1000,-236,-235,-1000,-263,-277,-265,
-266,-267,-252,-1000,-274,-269,-274,-274,-1000,-213,
-235,-235,-1000,-270,-250,-253,-264,-257,-258,-274,
-1000,-1000,-1000,-1000,-1000,-1000,-236,-1000,-1000,-275,
-1000,-1000,-275,-275,-236,-235,-235,-1000,-221,-274,
-274,-274,-274,-274,-274,-274,-275,-1000,-1000,-256,
-1000,-215,-1000,-275,-275,-275,-275,-275,-275,-275,
-1000 };
short yypgo[]={

   0,  76,  75,  74,  68,  73,  57,  72,  60,  58,
  71,  70,  69 };
short yyr1[]={

   0,  10,  10,   1,   1,   2,   2,   4,   4,   4,
   4,   4,   5,   5,   5,   5,   5,   5,   5,   5,
   8,   8,   8,   9,   9,   9,   9,   9,   9,  11,
  11,  12,  12,  12,  12,  12,  12,   3,   6,   6,
   7 };
short yyr2[]={

   0,   3,   1,   2,   0,   5,   1,   2,   3,   3,
   3,   1,   3,   3,   3,   3,   3,   3,   3,   2,
   3,   2,   1,   2,   2,   2,   2,   0,   1,   2,
   0,   3,   3,   3,   3,   3,   1,   3,   2,   1,
   1 };
short yychk[]={

-1000, -10, -11, 256,  -1, -12, 257, 258, 259, 260,
 261, 256,  -3,  -2, 264, 262, 256, 271, 271, 271,
 271, 271,  -8,  -9, 279, 280, 271, 281, 256,  -4,
 266, 269,  -5, 271,  -7, 276, 275, 272, 273, 274,
 277, 277, 278, 277, 277, 277, 282,  -9, 265,  -6,
 277, 277,  -6,  -6, 263, 267, 268,  -4,  -4, 275,
 276, 271, 271, 271, 274, 274,  -6,  -9, 277,  -8,
  -4,  -4, 270,  -6,  -6,  -6,  -6,  -6,  -6,  -6,
 265 };
short yydef[]={

  30,  -2,   4,   2,   0,  29,   0,   0,   0,   0,
   0,  36,   1,   3,  27,   0,   6,   0,   0,   0,
   0,   0,   0,  22,   0,   0,   0,   0,  28,   0,
   0,   0,  11,   0,   0,   0,   0,   0,   0,   0,
  40,  31,  32,  33,  34,  35,  27,  21,  37,  23,
  39,  24,  25,  26,  27,   0,   0,   7,   0,   0,
   0,   0,   0,   0,   0,   0,  19,  20,  38,   0,
   8,   9,  10,  12,  13,  14,  15,  16,  17,  18,
   5 };
#ifndef lint
static	char yaccpar_sccsid[] = "@(#)yaccpar 1.2 86/07/18 SMI"; /* from UCB 4.1 83/02/11 */
#endif

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps>= &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 1:
# line 59 "pmdc.y"
{ make_pmd(cat(yypvt[-1].dynstr, yypvt[-0].dynstr, NULL)); } break;
case 3:
# line 64 "pmdc.y"
{ yyval.dynstr = cat(yypvt[-1].dynstr, yypvt[-0].dynstr, NULL); } break;
case 4:
# line 66 "pmdc.y"
{ yyval.dynstr = NULL; } break;
case 5:
# line 70 "pmdc.y"
{
	      yyval.dynstr = cat(ds("\nif("),
		       cat(yypvt[-3].dynstr,
			   ds(") {\n"),
			   yypvt[-1].dynstr),
		       ds("\nreturn;\n}\n"));
	    } break;
case 6:
# line 78 "pmdc.y"
{ yyval.dynstr = NULL; } break;
case 7:
# line 81 "pmdc.y"
{ yyval.dynstr = PNOT(yypvt[-0].dynstr); } break;
case 8:
# line 83 "pmdc.y"
{ yyval.dynstr = PAND(yypvt[-2].dynstr, yypvt[-0].dynstr); } break;
case 9:
# line 85 "pmdc.y"
{ yyval.dynstr = POR(yypvt[-2].dynstr, yypvt[-0].dynstr); } break;
case 10:
# line 87 "pmdc.y"
{ yyval.dynstr = P(yypvt[-1].dynstr); } break;
case 12:
# line 92 "pmdc.y"
{
		    yyval.dynstr = POR(POR(headrule(ds(yypvt[-0].dynstr), ds("from")),
				 headrule(ds(yypvt[-0].dynstr), ds("sender"))),
			     POR(POR(headrule(ds(yypvt[-0].dynstr), ds("resent-from")),
				     headrule(ds(yypvt[-0].dynstr), ds("apparently-from"))),
				 headrule(ds(yypvt[-0].dynstr), ds("resent-by"))));
		    free(yypvt[-0].dynstr);	/* Must be freed explicitly */
		} break;
case 13:
# line 101 "pmdc.y"
{
		    yyval.dynstr = POR(POR(headrule(ds(yypvt[-0].dynstr), ds("to")),
				 headrule(ds(yypvt[-0].dynstr), ds("cc"))),
			     POR(POR(headrule(ds(yypvt[-0].dynstr), ds("bcc")),
				     headrule(ds(yypvt[-0].dynstr), ds("resent-to"))),
				 POR(headrule(ds(yypvt[-0].dynstr), ds("forwarded-to")),
				     headrule(ds(yypvt[-0].dynstr), ds("apparently-to")))));
		    free(yypvt[-0].dynstr);	/* Must be freed explicitly */
		} break;
case 14:
# line 112 "pmdc.y"
{ yyval.dynstr = headrule(yypvt[-0].dynstr, yypvt[-2].dynstr); } break;
case 15:
# line 114 "pmdc.y"
{ yyval.dynstr = headrule(yypvt[-0].dynstr, ds("to")); } break;
case 16:
# line 116 "pmdc.y"
{ yyval.dynstr = headrule(yypvt[-0].dynstr, ds("from")); } break;
case 17:
# line 118 "pmdc.y"
{ yyval.dynstr = headrule(yypvt[-0].dynstr, NULL); } break;
case 18:
# line 120 "pmdc.y"
{ yyval.dynstr = bodyrule(yypvt[-0].dynstr); } break;
case 19:
# line 122 "pmdc.y"
{
		    yyval.dynstr = POR(headrule(ds(yypvt[-0].dynstr), NULL),
			     bodyrule(ds(yypvt[-0].dynstr)));
		    free(yypvt[-0].dynstr);
		} break;
case 20:
# line 130 "pmdc.y"
{ yyval.dynstr = cat(yypvt[-2].dynstr, yypvt[-0].dynstr, NULL); } break;
case 21:
# line 132 "pmdc.y"
{ yyval.dynstr = cat(yypvt[-1].dynstr, yypvt[-0].dynstr, NULL); } break;
case 23:
# line 137 "pmdc.y"
{
		  yyval.dynstr = cat(ds("pprunact(\""),
			   yypvt[-0].dynstr,
			   ds("\");\n"));
		} break;
case 24:
# line 143 "pmdc.y"
{
		  yyval.dynstr = cat(ds("ppputact(\""),
			   yypvt[-0].dynstr,
			   ds("\");\n"));
		} break;
case 25:
# line 149 "pmdc.y"
{
		    yyval.dynstr = cat(ds("ppinc(\""),
			     yypvt[-0].dynstr,
			     ds("\");\n"));
		} break;
case 26:
# line 155 "pmdc.y"
{
		    yyval.dynstr = cat(ds("ppbarfact(\""),
			     yypvt[-0].dynstr,
			     ds("\");\n"));
		} break;
case 27:
# line 161 "pmdc.y"
{ yyval.dynstr = ds(";"); } break;
case 28:
# line 163 "pmdc.y"
{ yyval.dynstr = NULL; } break;
case 31:
# line 170 "pmdc.y"
{ free(home); home = yypvt[-0].dynstr; } break;
case 32:
# line 172 "pmdc.y"
{ free(mode); mode = yypvt[-0].dynstr; } break;
case 33:
# line 174 "pmdc.y"
{ free(errorfile); errorfile = yypvt[-0].dynstr; } break;
case 34:
# line 176 "pmdc.y"
{ free(dbfile); dbfile = yypvt[-0].dynstr; } break;
case 35:
# line 178 "pmdc.y"
{ free(format); format = yypvt[-0].dynstr; } break;
case 37:
# line 182 "pmdc.y"
{ yyval.dynstr = cat(ds("{\n"), yypvt[-1].dynstr, ds("\nreturn;\n}")); } break;
case 38:
# line 186 "pmdc.y"
{
		    yyval.dynstr = cat(yypvt[-1].dynstr, ds(" "), yypvt[-0].dynstr);
		} break;
case 40:
# line 193 "pmdc.y"
{
		    if(index(yypvt[-0].dynstr, ' ') || index(yypvt[-0].dynstr, '\t') ||
		       index(yypvt[-0].dynstr, ':')) {
			yyerror("illegal character in header field");
			YYERROR;
		    }
		    yyval.dynstr = yypvt[-0].dynstr;
		} break;
		}
		goto yystack;  /* stack new state and value */

	}
