/*
 *	$Source: /pozzo/usr/src.LOCAL/cmd/pmdc/RCS/pmd_stats.c,v $
 *	$Author: rlk $
 *	$Locker: rlk $
 *	$Header: pmd_stats.c,v 1.1 88/01/15 11:26:03 rlk Locked $
 */

#ifndef lint
static char *rcsid_pmd_stats_c = "$Header: pmd_stats.c,v 1.1 88/01/15 11:26:03 rlk Locked $";
#endif	lint

#include <stdio.h>
#include <ndbm.h>
#include <sys/file.h>

#define TIMEFIELD "_pptime"	/* Field holding start time */

datum key, contents;

main(argc, argv)
int argc;
char *argv[];
{
    DBM *db;
    char *statfile;

    switch(argc) {
	case 1:
	statfile = ".pmd.stats";
	break;
	case 2:
	statfile = argv[1];
	break;
      default:
	fputs("Usage: pmd_stats [statfile]\n", stderr);
	exit(1);
    }

    if((db = dbm_open(statfile, O_RDONLY, 0644)) == NULL) {
	fputs("Could not open database\n", stderr);
	exit(2);
    }

    key.dptr = TIMEFIELD;
    key.dsize = strlen(key.dptr)+1;
    contents = dbm_fetch(db, key);
    if(contents.dptr == NULL) {
	puts("Couldn't find start time.\n");
    } else {
	printf("Database started on %s\n", contents.dptr);
    }

    for(key = dbm_firstkey(db); key.dptr != NULL; key = dbm_nextkey(db)) {
	contents = dbm_fetch(db, key);
	if(strcmp(key.dptr, TIMEFIELD)) {
	    /* Note gross but vital}i pointer cast */
	    printf("%30s %lu\n", key.dptr, *((unsigned long *) contents.dptr));
	}
    }
    
    exit(0);
}
