.TH PMDC l "17 Oct 1986"
.FM quote "MIT Watchmakers"
.SH NAME
pmdc \- personal mail daemon compiler
.SH SYNOPSIS
.B pmdc
< rules-file > pmd.c
.PP
cc -o pmd pmd.c runtime.o -ldbm
.SH DESCRIPTION
.I Pmdc
takes a Personal Mail Daemon rules file and translates it into
a C source file, which must then by compiled and linked to produce a
PMD program capable of filtering incoming mail.	 This provides, in
addition to the ability to sort mail by type and content, the ability
to run other programs on certain messages, and to maintain a count of
messages falling into various categories.
.PP
Pmdc itself is not intended to be used directly; most user
will want to use install_pmd(l)
instead.  The remainder of this file describes
the structure of the pmdc rules file.
.SH RULES FILE FORMAT
A rules file consists of zero or more declarations, followed by zero
or more if-then rules and a required default action.  The minimum
possible rules file consists only of a default action.
.SH DECLARATIONS
Declarations have the form
.PP
<variable> is <value>
.PP
where <variable> can be any of
home,
mode,
format,
errorfile,
or statfile.
.PP
The value of the 
.I home
variable specifies which directory the PMD will
work in while running; it defaults to the user's home directory at the
time of compilation.
.PP
.I Mode
specifies the default mode for all files created by the PMD; its value
must be a three-digit octal number if specified, and defaults to 644.
The specified restrictions are relaxed if they prevent the PMD from
operating -- in particular, no temporary or statistics 
file will be created with a
mode more restrictive than 600, and no mailbox will be created with a
mode more restrictive than 200.
.PP
.I Format
specifies the format to be used for messages appended to files created
by the PMD.  If specified, it must be either rmail or mmdf.  If
nothing is specified, the messages will be appended in the format used
by /bin/mail(1). 
.PP
.I Errorfile
and
.I statfile
specify the names of the files used for logging errors and message
statistics, respectively.  They default to "pmd.dead.letter" and
".pmd.stats".
.SH RULES
Rules are tried in order, and the first rule which matches a message
determines the actions to be taken on that message.  If no rule
matches a message, the default action is taken.
Rules take the form
.PP
if <expression> then <actions> end
.PP
Expressions consist of zero or more predicates which may be combined
using the binary operators
.I and
and
.I or,
the unary operator
.I not
and parentheses for grouping.  The order of precedence is
.I not, and, or.
.SH PREDICATES
Predicates can be of the form
.PP 
<field> 
is
<string>
.PP
in which case they match any message whose header field <field>
contains the string to match.
In addition, the following special predicates may be used:
.PP
is from
<string>
.PP
matches all messages which contain the given string in their from,
sender, resent-from, apparently-from, or resent-by fields.
.PP
is to
<string>
.PP
matches all messages which contain the given string in their
to, cc, bcc, resent-to, forwarded-to, or apparently-to fields.
.PP
header contains
<string>
.PP
matches all messages which contain the given string in any header field.
.PP
body contains
<string>
.PP
matches all messages which contain the given string in their body.
.PP
contains
<string>
.PP
is equivalent to
.PP
(header contains
<string>
or body contains
<string>)
.SH ACTIONS
There are three types of actions which may be taken when a rule
matches:
.I is
actions,
.I put
actions, and
.I run
actions.  Each is specified by the form <keyword> <argument(s)>, where
<keyword> determines the type of the action.  
For
.I is
actions, the counter named by the argument is incremented in the
statistics file.  For
.I put
actions, the message is appended to the mailbox specified by the
argument.
For
.I run
actions, the argument is an arbitrary shell command line; this is run
with the message as standard input.
.PP
More than one action may be specified in a rule; multiple actions must
be separated by semicolons.
The PMD will attempt to carry out all actions specified, in the order
listed.	 If one or more of the actions fails, this will not affect any
remaining actions but will cause the message to be written to the
error file, if possible.
.SH DEFAULT ACTIONS
The default actions are specifed by the 
.PP
otherwise
<actions>
end
.PP
form, which must be placed at the end of the rules file.  A default
action is required.
.SH EXAMPLES
This minimal rules file duplicates the normal action of the mailer:
.PP
# bare-bones pmdc rules file
.br
otherwise put /usr/spool/mail/your-name-here end
.PP
This is a more complicated file:
.PP
# declarations
.br
home is /mit/a/s/asp/mail
.br
mode is 644
.br
# note that I use the default error and stat files.
.br

.br
# Junk mail gets categorized and placed in junk
.br
if is from sf-lovers then is sf-lovers; put junk end
.br
if is from human-nets then is human-nets; put junk end
.br

.br
# this entry saves fortunes mailed using another program
.br
# note that "from is" != "is from"
.br
if from is asp
.br
   and to is asp
.br
   and subject is "save this fortune"
.br
   then
.br
	is fortune;
.br
	run "sed -n '/^$/,$p' >> fortunes"
.br
   end
.br

.br
# a default action is required
.br
otherwise put mbox end
.SH FILES
/usr/unsupported/watchmkr/pmdc/pmdc
.br
/usr/unsupported/watchmkr/pmdc/runtime.o
.br
$HOME/.forward to set pmd to process incoming mail
.br
$HOME/.pmd.stats* (default statistics files)
.br
$HOME/pmd.dead.letter (default error file)
.SH SEE ALSO
install_pmd(l), pmd_stats(l), sendmail(8), binmail(1)
.SH AUTHOR
Jim Aspnes, MIT Project Athena.  Format variable added by Robert
Krawitz, MIT Project Athena.
.SH BUGS
Reserved words such as "and", "then", or "is" must be quoted when used in
arguments to predicates or actions.  Also, all whitespace in unquoted
arguments is converted to spaces; this may create problems when
specifying some run actions.
.PP
The format for pmdc rules files is incompatible with that of older versions of
pmd.
