/*++
/* NAME
/*	tgetnum 3
/* SUMMARY
/*	extract numerical capability from terminal database
/* PROJECT
/*	ms-dos/unix compatibility
/* PACKAGE
/*	termcap
/* SYNOPSIS
/*	tgetnum(name)
/*	char *name;
/* DESCRIPTION
/*	tgetnum extracts the numerical value associated with the
/*	capability in "name", for the terminal info extracted with
/*	a previous call of tgetent(3).
/* SEE ALSO
/*	tgetent(3), extract terminal entry from database.
/*	termcap(3), Berkeley extensions to UNIX.
/* FILES
/*	ANSI.SYS, ibm pc console driver.
/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Wed Jan  1 19:01:13 GMT+1:00 1986
/* LAST MODIFICATION
/*	90/01/22 13:57:11
/* VERSION/RELEASE
/*	2.1
/*--*/

#include "termcap.h"

tgetnum(id)
register char *id;
{
    register Cap *p;

    for (p = _console; *p->name; p++)
	if (strcmp(id, p->name) == 0)
	    return atoi(p->cap);
    return -1;
}
