/*++
/* NAME
/*      console 3
/* SUMMARY
/*      encoded ibm pc console terminal capabilities
/* PROJECT
/*       ms-dos/unix compatibility
/* PACKAGE
/*      termcap
/* SYNOPSIS
/*      #include "termcap.h"
/* DESCRIPTION
/*      The terminal capabilities for the ibm pc ANSI.SYS console driver
/*      are stored in a static data structure named "_console". 
/*      User access proceeds through the tget{num|str|flag} functions.
/*
/*      The escape character at the start of function key codes are
/*      imaginary; the PC hardware actually returns a nul byte.
/* SEE ALSO
/*      tgetnum(3), tgetstr(3), tgetflag(3).
/*      termcap(3), Berkeley extensions to UNIX.
/* FILES
/*      ANSI.SYS, ibm pc console driver.
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*      Wed Jan  1 19:01:13 GMT+1:00 1986
/* LAST MODIFICATION
/*      90/01/22 13:56:58
/* VERSION/RELEASE
/*      2.1
/*--*/

#include "termcap.h"

Cap     _console[] = {
    "am", 0,				/* auto CR-LF at right margin */
    "bs", 0,				/* terminal can backspace */
    "cd", "\033[J",			/* clear to end of screen */
    "ce", "\033[K",			/* clear to end of line */
    "cl", "\033[;H\033[2J",		/* clear whole screen */
    "cm", "\033[%i%d;%dH",		/* cursor movement */
    "co", "80",				/* nbr of columns on screen */
    "cr", "\r",				/* carriage-return */
    "do", "\033[B",			/* cursor down */
    "ku", "\033H",			/* up-arrow key */
    "kd", "\033P",			/* down-arrow key */
    "kl", "\033L",			/* left-arrow key */
    "kr", "\033N",			/* right-arrow key */
    "le", "\010",			/* cursor left */
    "li", "25",				/* nbr of lines on screen */
    "nd", "\033[C",			/* cursor right */
    "nl", "\n",				/* linefeed character */
    "pt", "",				/* has hardware tabs */
    "PU", "\033I",			/* page up key (non-std code) */
    "PD", "\033Q",			/* page down key (non-std code) */
    "se", "\033[m",			/* end standout mode */
    "so", "\033[1m",			/* enter standout (bold) mode */
    "ue", "\033[m",			/* end underscore mode */
    "up", "\033[A",			/* cursor up */
    "us", "\033[4m",			/* enter underscore mode */
    0, 0,				/* terminator */
};
