/*++
/* NAME
/*	status 5
/* SUMMARY
/*	process termination status
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	library
/* SYNOPSIS
/*	#include "status.h"
/* DESCRIPTION
/* .nf

 /* process termination status codes */

#define	E_SUCCESS	0		/* successfull completion */

#define	E_SYSFAIL	41		/* operating system failure */
#define	E_NOPROG	42		/* program not found */
#define	E_NOSPOOL	43		/* no spool directory */
#define	E_READERR	44		/* data file read error */
#define	E_WRITERR	45		/* data file write error */
#define	E_CONFUSED	46		/* internal error */
#define	E_UNKNOWN	47		/* unknown error */
#define	E_FILENO	48		/* cannot open enough files */
#define	E_BADSETUP	49		/* bad setup parameter */
#define	E_UNLINK	50		/* cannot remove file */
#define	E_PRINTERR	51		/* printer error */
#define	E_NOUSER	52		/* unknown user */
#define	E_OVALIAS	53		/* alias expansion overflow */
#define	E_TOOLONG	54		/* list of recipients too long */

 /* cico specific codes */

#define	E_NOLINE	61		/* cannot reach host */
#define	E_NORESP	62		/* no ititial response */
#define	E_REJECT	63		/* rejected by host (unknown,... ) */
#define	E_LOST		64		/* link lost (timeout,...) */
/* SEE ALSO
/*	status(3)	error message implementation
/* BUGS
/*	The usual error message problem: there is hardly any context
/*	information. A read error is a read error, no info about the
/*	state of processing when it ocurred.
/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Sat Apr 11 15:45:37 GMT+1:00 1987
/* LAST MODIFICATION
/*	90/01/22 13:02:42
/* VERSION/RELEASE
/*	2.1
/*--*/
