/*++
/* NAME
/*      lmail 1
/* SUMMARY
/*      local delivery of mail received via GNUUCP
/* PROJECT
/*      pc-mail
/* PACKAGE
/*      gnu
/* SYNOPSIS
/*      lmail [arguments]
/* DESCRIPTION
/*	This program replaces the receiving function of the pc-mail "cico"
/*	program, on systems that use GNUUCP for message transport.
/*
/*      lmail reads one mail message from its standard input and installs
/*	it as a message file in the pc-mail mail data base. Any command-line
/*	arguments are ignored (since pc-mail is a single-user mail system).
/*
/*	This command should be installed such that it can be found by the 
/*	GNUUCP "rmail" command. The actual program name may be different
/*	from "lmail"; this depends on how the GNUUCP software was configured.
/* ENVIRONMENT
/*	MAILDIR, path to pc-mail message data base
/* FILES
/*      In the spool directory:
/*	h<seqno>	new mail message.
/* SEE ALSO
/*      path(5)         spool directory, file names
/*	nmail(1)	extracts sender and subject from new mail.
/* DIAGNOSTICS
/*      Problems are reported on the standard error output, and cause the
/*	program to terminate with a nonzero exit status.
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Wed Jan  3 22:16:08 MET 1990
/* LAST MODIFICATION
/*	90/01/22 13:02:00
/* VERSION/RELEASE
/*	2.1
/*--*/

#include <stdio.h>
#include <varargs.h>

#include "defs.h"
#include "path.h"

extern int errno;
extern char *sys_errlist[];

extern char *fgets();

hidden void error();
public char *progname = "lmail";

/* pc-mail is a single-user mailer, so we ignore command-line arguments */

main()
{
    char    buf[BUFSIZ];
    char   *fname;
    FILE   *fp;

    /* Find out where the mail data base lives */

    if (pathinit())
	error("no mail directory or MAILDIR environment variable not set");

    /* Create a mail message file only - let nmail extract sender and subject */

    (void) umask(0222);				/* make files read-only */
    if ((fp = fopen(fname = new_mesg(newseqno()), "w")) == 0)
	error("cannot open %s: %s", fname, sys_errlist[errno]);

    /* Copy standard input to message file */

    while (fgets(buf, sizeof(buf), stdin))
	(void) fputs(buf, fp);

    /* Error checking */

    if (fflush(fp) || ferror(fp) || fclose(fp))
	error("%s: write error: %s", fname, sys_errlist[errno]);

    exit(0);
    /* NOTREACHED */
}

/* error - complain */

/* VARARGS */

hidden void error(va_alist) 
va_dcl
{
    va_list ap;
    char   *fmt;

    (void) fprintf(stderr, "%s: ", progname);
    va_start(ap);
    fmt = va_arg(ap, char *);
    (void) vfprintf(stderr, fmt, ap);
    va_end(ap);
    (void) putc('\n', stderr);
    exit(2);
}
