/*++
/* NAME
/*      defs 5
/* SUMMARY
/*      program-independent definitions
/* PROJECT
/*      pc-mail
/* PACKAGE
/*      all
/* SYNOPSIS
/*      #include "defs.h"
/* DESCRIPTION
/* .nf

 /* this file is for program-independent definitions */

extern int errno;
extern char *sys_errlist[];

#define hidden static			/* for functions local to a module */
#define public				/* globally visible functions/data */

 /*
  * Take care of differences between various flavours of C library function
  * names. Define macros where functions are missing.
  */

#if (SIII|SYSV|MSDOS)
#   define index strchr
#   define rindex strrchr
#endif

#ifdef	unix
#   define rename(from,to) (link(from,to) || unlink(from))
#endif

 /*
  * The delay macro is used during the dial-out sequence, e.g. when we are
  * sending commands to a modem. It is supposed to produce a short delay of a
  * few milliseconds so that the modem can see a small gap between successive
  * characters.
  */

#if (unix||MSDOS)
#define delay()	chdir(".")
#else
"put your delay() definition here"
#endif

 /*
  * Standard macros.
  */

#define	MIN(a,b)	((a) < (b) ? (a) : (b))
#define	MAX(x,y)	((x) > (y) ? (x) : (y))
#define CALL(p)		(*(p))

 /* library functions with non-default return types */

extern char *strtok();
extern char *fgets();
extern char *strcpy();
extern char *strncpy();
extern char *strcat();
extern char *strncat();
extern char *malloc();
extern char *realloc();
extern void free();
extern char *getenv();
extern char *asctime();
extern long time();
extern char *index();
extern char *rindex();
extern char *memcpy();
extern void exit();

 /* local utility functions with non-default return types */

extern char *myalloc();
extern char *myrealloc();
extern char *strcons();
extern char *split();
extern char **strvec();
extern char *vecstr();

 /* maximal length of lines with recipients etcetera */

#define	MAXLINE	1024

/* SEE ALSO
/*      path(5)         system-dependent path names
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*      Mon Apr  6 16:58:42 GMT+1:00 1987
/* LAST MODIFICATION
/*	90/01/22 13:01:28
/* VERSION/RELEASE
/*	2.1
/*--*/
