/*++
/* NAME
/*      call 3
/* SUMMARY
/*      call remote unix system
/* PROJECT
/*      pc-mail
/* PACKAGE
/*      mail
/* SYNOPSIS
/*      int call()
/* DESCRIPTION
/*      call() is invoked when the user wants to contact the unix host.
/*	It asks for a uucp password. After the user has provided this
/*	the password is erased from the screen and the mail server is called
/*	by the cico file transfer program. Afterwards, the nmail program is 
/*	invoked to extract originator addresses from new mail messages. In 
/*	order to force a new mailbox display the current mail display is junked.
/* FUNCTIONS AND MACROS
/*	kbdinp(), kbdrest(), invoke(), kbdinit(), errdisp(), junk_desk()
/* COMMANDS
/*      cico    remote login, file transfer
/*	nmail	extract originator from new mail
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*      Sun Apr  5 18:27:18 GMT+1:00 1987
/* LAST MODIFICATION
/*	90/01/22 13:01:16
/* VERSION/RELEASE
/*	2.1
/*--*/

#include "defs.h"
#include "path.h"
#include "screen.h"
#include "pager.h"
#include "mail.h"

hidden int do_call();				/* forward declarations */

/* call - set up dialogue for password */

public int call()
{
    static Screen screen[] = {
	STRING,	0,              do_call,int_error,
	0,	0,              0,
	"Press ESC to cancel. Enter password:",
    };

    kbdinp(screen);				/* ask password */
    return(S_REDRAW);				/* say screen has changed */
}

/* do_call - make the call to a unix host */

static int do_call(pwd)
char   *pwd;
{
    register int stat;

    clrtoeol();					/* erase password kludge */
    patience();					/* this may take some time */
    kbdrest();					/* reset user tty modes */
    ((stat = invokelp(CICO, "-p", pwd, (char *) 0))	/* try to call host */
     ||(stat = invokelp(NMAIL, (char *) 0)));	/* try to extract originators */
    kbdinit();					/* set user tty modes */
    junk_desk();				/* force new mailbox display */
    if (stat) {					/* check error status */
	errdisp(stat);				/* notify user of problem */
	return (S_BREAK | S_REDRAW);		/* redisplay, stop caller */
    } else {
	return (S_BREAK);			/* just stop caller */
    }
}
