/*++
/* NAME
/*	util 3
/* SUMMARY
/*	wrappers around standard library functions
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	nfs
/* SYNOPSIS
/*	#include <stdio.h>
/*	#include <pwd.h>
/*	#include "util.h"
/* DESCRIPTION
/* .nf

 /* Anticipate on ANSI-compatible compilers */

#ifdef __STDC__
FILE   *u_fopen(struct passwd * user, char *file, char *mode);
int     u_unlink(char *file);
DIR    *e_opendir(char *path);
int     e_chdir(char *path);
int     e_fork(void);

#else
FILE   *u_fopen();			/* open file, log any errors */
int     u_unlink();			/* unlink file, log any errors */
DIR    *e_opendir();			/* open directory, log any errors */
int     e_chdir();			/* change directory, log any errors */
int     e_fork();			/* fork, log any errors */

#endif
/* AUTHOR(S)
/*	Wietse Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Sun Oct 29 16:21:02 MET 1989
/* LAST MODIFICATION
/*	10/29/89 22:29:55
/* VERSION/RELEASE
/*	1.1
/*--*/

