/*++
/* NAME
/*	mtime 3
/* SUMMARY
/*	maintain modification times of files
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	nfs
/* SYNOPSIS
/*	#include "mtime.h"
/*
/*	MTIME *mtime(path)
/*	char *path;
/* DESCRIPTION
/*	mtime() maintains a table of modification times of files.
/*	If a new file name is given, a modification time of 0 is
/*	assumed (the UNIX equivalent of "a very long time ago").
/*
/*	If, for whatever reason, no memory can be allocated to update the
/*	symbol table, a dummy entry is returned with modification time of 0.
/* DIAGNOSTICS
/*	Diagnostics are logged with the syslog(3) facility. The program
/*	tries to continue to run as long as possible.
/* BUGS
/*	The dummy entry is stored in static memory; its value may be
/*	overwritten an any time.
/* AUTHOR(S)
/*	Wietse Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Sun Oct 29 15:48:01 MET 1989
/* LAST MODIFICATION DATE
/*	10/29/89 22:29:56
/* VERSION/RELEASE
/*	1.1
/*--*/

#ifndef lint
static char sccsid[] = "@(#) mtime.c 1.1 10/29/89 22:29:56";

#endif

#ifdef SYSLOG
#include <syslog.h>
#else
#include "syslog.h"
#endif

#include "mtime.h"

extern char *malloc();
extern char *strcpy();

MTIME  *mtime_tree;			/* head of symbol table */

/* findtime - actual symbol-table access routine */

MTIME  *findtime(path, tree)
register char *path;
register MTIME *tree;
{
    register int direct;
    static MTIME dummy;

    /*
     * We use a trivial binary-tree storage scheme. If we cannot get memory
     * for whatever reason, produce a dummy result. This means we will always
     * believe that a file has changed. My first excercise in "graceful
     * degradation".
     */

    if (tree == 0) {				/* new file */
	if ((tree = (MTIME *) malloc(sizeof(MTIME))) == 0
	    || (tree->path = malloc(strlen(path) + 1)) == 0) {
	    syslog(LOG_WARNING, "memory allocation failed");
	    dummy.time = 0;
	    tree = &dummy;
	} else {
	    (void) strcpy(tree->path, path);
	    tree->time = 0;
	    tree->left = tree->rite = 0;
	}
    } else if ((direct = strcmp(path, tree->path)) < 0) {
	tree->left = findtime(path, tree->left);
    } else if (direct > 0) {
	tree->rite = findtime(path, tree->rite);
    }
    return (tree);
}

