/*++
/* NAME
/*	tputs 3
/* SUMMARY
/*	output string with padding
/* PROJECT
/*	ms-dos/unix compatibility
/* PACKAGE
/*	termcap
/* SYNOPSIS
/*	tputs(cp,affcnt,outc)
/*	char *p;
/*	int affcnt;
/*	int (*outc)();
/* DESCRIPTION
/*	tputs interprets leading padding information in the string
/*	pointed to by cp, and outputs through the function pointed
/*	to by outc.
/*
/*	In the MS-DOS implementation, padding information is not
/*	needed.
/* SEE ALSO
/*	termcap(3), Berkeley extensions to UNIX.
/* FILES
/*	ANSI.SYS, ibm pc console driver.
/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Wed Jan  1 19:01:13 GMT+1:00 1986
/* LAST MODIFICATION
/*	90/01/22 13:57:21
/* VERSION/RELEASE
/*	2.1
/*--*/

#include "termcap.h"

/* version does not check for padding */

tputs(cp, affcnt, outc)
register char *cp;
int     affcnt;
register int (*outc) ();
{
    while (*cp)
	(*outc) (*cp++);
}
