/*++
/* NAME
/*      tgoto 3
/* SUMMARY
/*      absolute cursor addressing
/* PROJECT
/*      ms-dos/unix compatibility
/* PACKAGE
/*      termcap
/* SYNOPSIS
/*      char *tgoto(cm,destcol,destline)
/*      char *cm;
/*      int destcol,destline;
/* DESCRIPTION
/*      tgoto(3) returns a character string for absolute cursor addressing.
/*      Usually, the string is constructed on the basis of the "cm" capability
/*      extracted from the terminal capability database.
/*
/*      In the ms-dos implementation cursor addressing is hardwired into
/*      the tgoto(3) algorithm.
/* SEE ALSO
/*      tgetstr(3)      Extracts string capability from data base
/*      termcap(3)      Berkeley extensions to UNIX.
/* FILES
/*      ANSI.SYS, ibm pc console driver.
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*      Wed Jan  1 19:01:13 GMT+1:00 1986
/* LAST MODIFICATION
/*      90/01/22 13:57:19
/* VERSION/RELEASE
/*      2.1
/*--*/

#include "termcap.h"

/* version with wired-in cursor movement */

char   *tgoto(cm, destcol, destline)
char   *cm;
int     destcol;
int     destline;
{
    static char buf[100];

    (void) sprintf(buf, "\033[%d;%dH", destline + 1, destcol + 1);
    return buf;
}
