/*++
/* NAME
/*	tgetstr 3
/* SUMMARY
/*	extract string-valued capability from terminal database
/* PROJECT
/*	ms-dos/unix compatibility
/* PACKAGE
/*	termcap
/* SYNOPSIS
/*	char *tgetstr(name,area)
/*	char *name,**area;
/* DESCRIPTION
/*	tgetstr extracts the string value associated with the capability
/*	in "name", from the info obtained earlier through a call of
/*	tgetent(3). area is a pointer to a 1024-character buffer and is
/*	updated with each call of tgetstr(3).
/*
/*	Since the capabilities of the ms-dos console are stored in a static
/*	data structure,
/*	the area pointer is not used in the MS-DOS implementation.
/* SEE ALSO
/*	tgetent(3), extract terminal entry from database.
/*	termcap(3), Berkeley extensions to UNIX.
/* FILES
/*	ANSI.SYS, ibm pc console driver.
/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Wed Jan  1 19:01:13 GMT+1:00 1986
/* LAST MODIFICATION
/*	90/01/22 13:57:13
/* VERSION/RELEASE
/*	2.1
/*--*/

#include "termcap.h"

char   *tgetstr(id, area)
register char *id;
char  **area;
{
    register Cap *p;

    for (p = _console; *p->name; p++)
	if (strcmp(id, p->name) == 0)
	    return (p->cap);
    return 0;
}
