\" format with the ms macro library
.TL
PC-MAIL tutorial
.AU
Wietse Z. Venema
Mathematics and Computing Science,
Eindhoven University of Technology
Eindhoven, The Netherlands
.AE
.NH
What does this software do for you?
.LP
This software allows you to send and receive electronic mail.  Once the
software has been configured, it can be used without any knowledge about
computer networking.
.LP
The following summarizes a few features:
.IP o
Mail messages can be edited, printed, replied to, sent, and received, from
within the mail program.
.IP o
Messages can be created with almost every word-processing package.
.IP o
Almost every command can be selected by pressing a single key. There is
a "help" facility that gives brief explanations.
.IP o
You can set up an "alias" data base to avoid the use of the usually
cryptical electronic mail addresses.  This facility can also be used to
implement small mailing lists.
.IP o
There is a facility for personalized headers and signatures.
.LP
The mail software does not attempt to solve every problem in this world.
It is only fair to mention the most important limitations here:
.IP o
Any information other than pure text must be converted to text format
before you can mail it to someone else (for example, programs, pictures
and so on).  Fortunately, there exists a lot of software to aid in this
task.  The people that installed the mail software should be able to
help you out.  
.IP o
Most electronic mail systems impose an upper limit to the size of a mail
message.  This limit varies from about 60 kilobytes to about 100
kilobytes per message.  You will have to break up larger messages; the
mail software does not do it for you.  Normally, you should not run into
this limit.
.LP
Installation of the mail software is described in various other documents.
The remainder of this document gives an introduction to the use of the mail
software. The following gives a summary.
.LP
Chapter 2, "Starting the program",
describes how to invoke the program, and how to leave it.  Also gives a
general introduction to the command structure of the program.
.LP
Chapter 3, "Reading new mail",
describes how to take care of new mail, and what happens once you have
read a new message.
.LP
Chapter 4, "Creating a message",
describes how to compose a message from scratch, and how to specify its
destination.
.LP
Chapter 5, "Sending and receiving electronic mail",
describes how to exchange messages between your machine and the rest of
the world.  It does not apply if your machine is connected to a "file
server".
.LP
Chapter 6, "Alias data base",
describes the use of the alias data base, and gives an example of a tiny
mailing list.
.LP
Chapter 7, "Replying to a message",
describes how to compose a reply to message.
.LP
Chapter 8, "Mailing other files",
describes how to distribute files via electronic mail.
.LP
Chapter 9, "Receiving encoded files",
describes how to decode files that have been encoded with e.g. the
"\fCuuencode\fR" or "\fCbtoa\fR" programs.
.NH
Starting the program
.LP
Starting the mail program is easy; just type the command "\fCmail\fR".
You should see a screen that looks like the one shown here:
.DS L
.ft C
Close  File  Setup  Alias  Print  Up  Down  Enter  Help ?
==========================================================
Create       Create a new message
Work       2 Messages in preparation
New        0 Unread messages
In        30 Messages already read
Out        7 Messages not-yet sent
Sent      20 Messages already sent


==========================================================
Select a message category with cursor keys and press ENTER
or select one of the commands in the top line.
.ft R
.DE
.LP
The screen is divided into three horizontal regions:
.IP o
The \fItop\fR region shows the commands that can be selected by pressing
a single key.  Some of these commands are selected by pressing a
function key with the same name as the command; for example, the
\fCUp\fR or \fCDown\fR commands are selected by pressing the
corresponding arrow key.  Other commands are selected by typing the
first letter of that command; for example, the \fCH\fR key selects the
"\fCHelp\fR" command; it gives a brief description of what the other
commands do.
.IP o
The \fImiddle\fR region shows various categories of mail messages.  You
might think of it as a collection of boxes with letters.  For example,
the "\fCNew\fR" box is for messages that you haven\'t read yet, and the
"\fCOut\fR" box is for messages that you wrote, but that have not yet been
sent away.  The program also shows how many messages there are within a
message category.
.sp
A special case is the "\fCCreate\fR" box; it is for messages you are
going to write.  Think of it as a box with blank sheets of paper.
.IP o
The \fIbottom\fR region gives an explanation of what you are supposed to
do when you see this screen.  In this particular case, it tells that you
can select one of the message categories by moving the cursor to the
appropriate line, and by pressing the "\fCEnter\fR" key, or that you can
give commands by pressing the appropriate key.
.LP
You can leave most screens by pressing the "\fCC\fR" key. In particular,
pressing that key while the program displays the first screen is the
preferred way to leave the mail program.
.NH
Reading new mail
.LP
Depending on how the mail software was installed on your system, you may
have seen a message that "\fCYou have new mail\fR" when you started
up the machine. This section describes how to deal with new mail.
.LP
In the display that was described above, move the cursor to the
line with "\fCNew\fR" and press the "\fCEnter\fR" key. The program
will present an overview of unread messages that looks like the
following one:
.DS L
.ft C
Close  File  Setup  Alias  Print  PgUp  PgDn  Up  Down  Enter  Help ?
=====================================================================
   90  Dec 15 22:18  Wietse Venema "Re: how do I forward a message?"
   63  Dec 11 23:18  Jan Kalisvaart "File server cleanup"
    .
    .
    .
-- end of display --


=====================================================================
Select a message with the cursor keys and press ENTER
or select one of the commands in the top line.
.ft R
.DE
.LP
The top line of the screen shows a few more commands than the screen
described earlier.  New commands, for example, are the the PgUp and PgDn
commands.  They are useful when information does not fit in the middle
screen region.
.LP
The middle screen region shows summaries of mail messages.  Each message
is summarized on a single line, and gives the following information:
.IP o
The message sequence number (e.g. \fC90\fR).  Normally, you do not have
to remember message sequence numbers, but the mail program needs them in
order to keep things apart.
.IP o
The date of arrival (e.g. \fCDec 15 22:18\fR).  If a message is very
old, the year will be displayed instead of the hours and minutes.
.IP o
The sender of the message (e.g. \fCWietse Venema\fR).  Usually, the mail
program presents a "human" name.  Every now and then, however, you may
see an ugly electronic mail address.
.IP o
The subject of the message (e.g. "\fCRe:  how do I forward a
message?\fR").  This allows you to decide if a message is urgent and has
to be dealt with right away, or if the message can wait till later.
.LP
After you have moved the cursor to the message you want to read, and have
pressed the "\fCEnter\fR" key, the program displays the selected message.
The following example shows what the screen might look like.
.DS L
.ft C
Close  Delete  Mail  Print  Reply  Save  Work  |  PgUp  PgDn  Up  Down  Help ?
==============================================================================
Subject: Re: how do I forward a message?
Organization: Eindhoven University of Technology, The Netherlands
From: wietse@wzv.win.tue.nl (Wietse Venema)
To: you

Select the message that you wish to forward, and press the "M" (Mail)
key.  The program will ask for a destination. As usual, you can enter 
an alias or a real address. This command mails a copy of the message;
it does not change or remove the message itself.

		Greetings,
                                Wietse Venema
-- end of display --

==============================================================================
(Reading a mail message)
.ft R
.DE
.LP
At this stage you may decide to do nothing with the message; just hit
the "\fCC\fR" key and the program returns to the last message-selection
screen.  Now that the message has been read it will no longer show up in
an overview of the "\fCNew\fR" category; once a "\fCNew\fR" message has
been read it goes to the "\fCIn\fR" category, and remains there until
you explicitly delete it.
.LP
Hitting the "\fCC\fR" key once more brings us back to the beginning of
the program.
.NH
Creating a message
.LP
In order to compose a message, move the cursor to the "\fCCreate a new
message\fR" line in the first screen of the mail program and press the
"\fCEnter\fR" key.  After a few seconds you should see the first screens
of the same word processor that you probably also use for other
activities.  Please note that the mail program has not terminated; as
soon as you exit from the word processor you will return back to the
mail program.
.LP
If all is well, your message should begin with a "\fCSubject: \fR" line.
Depending on how the mail software was set up on your machine, an
"empty" message may already contain one or more customized header lines,
as well as a customized "signature" at the end of the message.  The
following is an "empty" message as produced on my personal system (the
text between square braces is not part of the "empty" message; I just
added it to clarify things).  
.DS L
.ft C
Subject:  [the subject of this message] 
Organization:  Eindhoven University of Technology, The Netherlands

[this is where the actual message goes]

					Wietse Venema
.ft R
.DE
.LP
If your "empty" message contains garbage you should contact the people
that installed the mail software on your system.
.LP
The message text that you are about to enter will be only part of the
message that other people will receive; the mail software automatically
prefixes each message with your own electronic mail address, and the
current date\(dg.
.FS
\(dg Your message will probably be prefixed with several additional rude
header lines while it passes through other machines on the way to its
destination. This happens outside the control of the mail software on
your machine.
.FE
.LP
Obviously, further details about the entry of message text depend on the
word-processing package that you are using.  Suffice to say that upon
exit, the word processor should produce an "ASCII document" file; the
people that installed the mail software on your machine should be able
to provide more details on this topic.
.LP
Upon return from the word processor back to the mail program, you will
see the first few lines of your newly-composed message in the middle
region of the screen.  There may be "funny cookies" in your text if you
forgot to produce an "ASCII document"; if that is the case you had
better re-enter the word processor (by pressing the "\fCE\fR" key) and
correct this mistake.  After this, your screen should be something like:
.LP
.DS L
.ft C
Close  Delete  Edit  Mail  Print  PgUp  PgDn  Up  Down  Help ?
==============================================================
Subject: your subject
optional header lines

your message
-- end of display --


==============================================================
(Reading a message in preparation)
.ft R
.DE
.LP
What you see on the screen is a close approximation of what other people
will receive.  If this is the first time you use electronic mail you may
wish to use the "\fCPgUp\fR" and "\fCPgDn\fR" keys to check things out.
.LP
Normally, the next step will be to mail the message to its destination,
but you may choose any of the other commands shown in the upper line of
the screen.  For example, you could choose the \"fCClose\fR" command to
put the message "on hold"; the mail program will ask you to give a
one-line description so that you can easily find it back at a later
time (it will be stored in the category "\fCMessages in preparation\fR").
.LP
If you choose the "\fCMail\fR" command, the program will respond with:
.DS
.ft C
Press ESC to cancel. Send message to:
? 
.ft R
.DE
.LP
You should enter one or more electronic mail addresses or aliases.  If
what you wrote was just a "test" message, you might want to mail it to
yourself.  There is nothing crazy about sending mail to yourself; many
people do that instead of littering their rooms with notes on small
pieces of paper.  Aliases are described later on, and are more easily
remembered than real electronic mail addresses.  Your input should be
terminated by pressing the "\fCEnter\fR" key.
.LP
After this, the program returns to the first screen.  The message you
just "mailed" will temporarily live in the category "\fCNot-yet
sent\fR".  If your machine is connected to a "file server", it will
automatically be moved to the category "\fCAlready sent\fR" within a
short period of time. Otherwise, you should read the next section.
.NH
Sending and receiving mail
.LP
This section describes how to exchange mail messages between your
machine and the rest of the world. This is automatically taken
care of if your machine has a direct connection to a "file server". 
.LP
If you are not connected to a "file server", most of the mail-program
screens will provide a "\fCNetwork\fR" command (for example, the first
screen).  All messages that you produce will stay on your machine, in
the message category "\fCNot-yet sent"\fR", until the mail software has
sent them away through the network.  Also, messages, having your machine
as their destination, will not arrive on your machine until the mail
software has picked them up through the network.
.LP
The mail software may have been installed such that it, as soon as the
machine is turned on, automatically makes contact with the network.  In
that case, you do not need to invoke the "\fCNetwork\fR" command by
hand.  It can, however, be useful if you are expecting urgent mail, or
if you wrote a letter that should be sent away right now.
.LP
The "\fCNetwork\fR" command is activated by pressing the "\fCN\fR" key.
The mail program will ask for a network password (the one given to you
by the people that installed the mail software on your machine).
Transferring mail across the network may take a few minutes.  If all
goes well, all messages in the message category "\fCOut\fR" will have
moved to the category "\fCSent\fR"; in addition, you may have received
new mail that will show up in the "\fCNew\fR" message category.
.NH
Alias data base
.LP
The addresses used in electronic mail are often ugly, and hard to
remember.  To alleviate this problem, the mail program provides an alias
data base facility.  This allows you to use easily-remembered names
instead of mail addresses; the mail program will automatically replace
aliases by the actual mail addresses that you have specified in the
alias data base.
.LP
The following is an example of an alias data base:
.DS
.ft C
wietse	wswietse@lso.win.tue.nl
jan	wsbujank@win.tue.nl
staff	wietse jan
.ft R
.DE
.LP
An alias data base has a very simple format:  each alias definition
consists of a single line of text with two or more words.  Words may be
separated by blanks or commas.  The first word is the alias; it will be
replaced (by the words in the remainder of the line) if the mail program
finds the alias in the destination of a mail message.  With the alias
data base shown above, the message destination "\fCwietse\fR" will be
automatically replaced by the destination
"\fCwswietse@lso.win.tue.nl\fR".
.LP
An interesting property is that an alias may be defined in terms of
other aliases; an alias may, however, not be defined in terms of itself!
In the above example, the third line illustrates the definition of an
alias in terms of other aliases.  The same line also is an example of
how to implement a small mailing list; all messages sent to
"\fCstaff\fR" will be sent to "\fCwswietse@lso.win.tue.nl\fR" and to
"\fCwsbujank@win.tue.nl\fR".  Typing the word "\fCstaff\fR" certainly is
easier.
.LP
The mail program is smart enough to eliminate, after alias replacement,
multiple occurrances of the same destination.  Thus, you do not have to
worry about duplicate destinations if you combine several mailing lists
into a bigger one.
.LP
Most mail-program screens provide the "\fCAlias\fR" command.  This
allows you to look at the contents of your alias data base, and to
invoke a word processor to make changes.  The word processor should save
the alias data base in "ASCII document" format, just like ordinary mail
messages.
.LP
It is worth noting that aliases can be defined in any order.  The above
example would have worked just as well if the last entry had been the
first one.  Thus, you may wish to keep the alias data base in sorted
order.
.LP
Finally, a few caveats are in order.  If an alias is defined more than
once, only the last definition will be used.  Although the mail program
does not care whether an alias is defined in upper case or in lower
case, it is wise to keep electronic mail addresses in lower case.
.NH
Replying to a message
.LP
Replying to a mail message is almost the same as creating a mail message
from scratch; the main difference is that you must specify which message
you are replying to.
.LP
In order to reply to a message, select it with the cursor keys and the
"\fCEnter\fR" key, so that the contents of the message become visible
on the screen.  Pressing the "\fCR\fR" key executes the reply command. 
.LP
The program will ask you if the reply should include a copy of the
message being replied to.  Including a copy of the original message is
convenient if the sender asked several questions; both you and the
recipient of the message can see what questions you are actually
replying to.  In order to distinguish the text that you write from what
the other person wrote, the latter text will be prefixed with a ">"
character at the beginning of each line.
.LP
After you answered the question, the mail program will invoke a word
processing program.  Most of what follows is the same as when you create
an electronic mail message:  the mail program has not terminated, but is
just waiting for you to finish editing; upon exit, the word processing
package should produce an "ASCII document" file; after leaving the word
processing program you will return to the mail program.
.LP
At this point, your screen should look like this:
.DS L
.ft C
Close  Delete  Edit  Mail  Print  PgUp  PgDn  Up  Down  Help ?
==============================================================
Subject: Re: The subject of the original message
Other customized header lines may go here

>Text taken from the original message is prefixed
>to distinguished it from the text that you wrote.

Your text
-- end of display --


==============================================================
(Reading a message in preparation)
.ft R
.DE
.LP
In order to send the message, press the "\fCM\fR" key. The program will
respond with:
.DS
.ft C
Press ESC to cancel. Send message to:
? some-mail-address
.ft R
.DE
.LP
The mail address shown by the program was taken from the original
message and should usually be correct.  If you wish to use that address,
just press the "\fCEnter\fR" key.  Otherwise, the address can be changed
in the usual way; you can specify one or more aliases or electronic mail
addresses.
.LP
After this, the message that you wrote will temporarily live in the
message category "\fCNot-yet sent\fR"; if your machine is connected to a
"file server" the message will automatically be moved to the message
category "\fCAlready sent\fR".  If your machine is not connected to a
"file server", read the section "Sending and receiving mail".
.NH
Mailing other files
.LP
In addition to sending files created with your word processor, the mail
program provides a facility to distribute copies of other files as well.
This feature is of limited use, however, since it only works well with
pure text files; a file that contains non-textual data, such as a
program or a picture, will have to be converted to textual form before
the mail program can handle it.  The mail program can, however, help you
to find out whether a file is suitable for mailing.
.LP
Most screens of the mail program provide a "\fCFile\fR" command that can
be executed by pressing the "\fCF\fR" key.  After a few seconds the
middle region of the screen should show a listing of the current
directory.  The top region of the screen lists the commands that you can
execute; the bottom region of the screen shows the name of the directory
being listed.  
.DS L
.ft C
Close  Print  Save  PgUp  PgDn  Up  Down  Enter  Help ?
===================================================================
\&.                        <dir> Dec 28 18:10
\&..                       <dir> Dec 27 16:36
alias.c                   3295 Dec 12 22:41
ascf.c                    5315 Dec 23 21:16
call.c                    2282 Nov 30 22:08
cmail.c                   3748 Dec 17 21:22
create.c                  2176 Dec 27 18:28
desk.c                   12435 Dec 27 14:04
deskutil.c                7180 Dec 27 15:29
 .
 .
 .
===================================================================
To display a file, select it with the cursor keys, then press ENTER
(showing directory: "/usr2/wietse/src/pc-mail/mail")
.ft R
.DE
.LP
You can leave the "\fCFile\fR" command at any time by
pressing the "\fCC\fR" key once or twice.
.LP
With the cursor keys and the PgUP and PgDn keys you can "walk" through
the directory listing.  Pressing the "\fCEnter\fR" key causes the
program to "open" the thing being selected.  If you select a directory,
the program will display the contents of that directory; if you select a
file, the program will display the contents of that file.
.LP
In order to mail a copy of a file, select that file with the cursor and
"\fCEnter\fR" keys so that its contents are shown on the screen.  Only
if you see a clean text, without "funny cookies", the file is suitable
for mailing.  Pressing the "\fCM\fR" key executes the "\fCMail\fR"
command.  It will ask for a destination, which may be one or more
aliases or an electronic mail addresses.  Pressing "\fCEnter\fR" finishes
the "\fCMail\fR" command.  As usual, the message will temporarily live
in the message category "\fCNot-yet sent\fR"; if your machine is
connected to a "file server" the message will automatically be moved to
the message category "\fCAlready sent\fR".  If your machine is not
connected to a "file server", read the section "Sending and receiving
mail".
.LP
In order to leave the "\fCFile\fR" command you may have to press the
"\fCC\fR" key once or twice.
.NH
Receiving encoded files
.LP
Sometimes people send "encoded" files if they contain data that cannot
be sent directly as an electronic mail message. Encoded files must be
processed by a "decoding" program in order to restore the original data.
.LP
There exist various encoding methods.  Usually, the sender will provide
some information about the encoding method used.  In case of doubt, you
will have to consult a technical person.
.LP
If a message was encoded with the "\fCuuencode\fR" program it usually
looks like
.DS L
.ft C
begin 644 tutorial.ms
M7"(@9F]R;6%T('=I=&@@=&AE(&US(&UA8W)O(&QI8G)A<GD*+E1,"E!#+4U!;
M24P@='5T;W)I86P*+D%5"E=I971S92!:+B!696YE;6$*36%T:&5M871I8W,@P
M86YD($-O;7!U=&EN9R!38VEE;F-E+`I%:6YD:&]V96X@56YI=F5R<VET>2!OJ
 .
 .
 .
.ft
.DE
.LP
In order to restore the original file, select the message such that
its contents appear on the screen, and press the "\fC|\fR" key.
The program will ask for the name of a command:
.DS L
.ft C
    Press ESC to cancel. Filter through command:
    ?
.ft
.DE
.LP
At this point, specify the "\fCuudecode\fR" command and press the
"\fCENTER\fR" key.
.DS L
.ft C
    Press ESC to cancel. Filter through command:
    ? uudecode
.ft
.DE
.LP
This produces, in the current working directory, a decoded file with
the same name as shown in the "\fCbegin\fR" line in the message (in
this particular example, the name would be "\fCtutorial.ms\fR").
.LP
Another popular encoding program is "\fCbtoa\fR". If that program
has been used, the message looks somewhat like:
.DS L
.ft C
xbtoa Begin
>Tt;&DfT]'F<GdAFD)e=BOr<'F!,=.@rcK1Ch[@!@<-W#/lYLO:dZg/5tO`m
qQFE;"9=tUpuASu'r@1#_;FD,6&@<?3nF!+n/A0=6XD/aW>Bl7Q+;e'NQDI[
J=9*EcYr:Gp%$;+B2o^BPqa)DeF>&7;6XMBQ&'*DCco0BOr;]ATVTsEbo0%A
 .
 .
 .
.ft
.DE
.LP
In order to restore the original file, select the message such that
its contents appear on the screen, and press the "\fC|\fR" key.
The program will ask for the name of a command:
.DS L
.ft C
    Press ESC to cancel. Filter through command:
    ?
.ft
.DE
.LP
At this point, specify the "\fCatob\fR" command and a file name, and
press the "\fCENTER\fR" key.  For example,
.DE L
.ft C
    Press ESC to cancel. Filter through command:
    ? atob >abc.def
.ft
.DE
.LP
The "\fC>\fR" is needed or you will get the decoded data on your screen.
If all goes well, you should now have a decoded file in your current
working directory (in this example, the name of the file would be
"\fCabc.def\fR").
