/*++
/* NAME
/*	snapshot 3
/* SUMMARY
/*	keep overview of the mail directory
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	mail
/* SYNOPSIS
/*	#include "snapshot.h"
/*
/*	SNAP_SHOT *snap_shot(list)
/*	char *list;
/*
/*	void snap_junk()
/* DESCRIPTION
/*      These functions maintain a "snapshot" of the mail directory;
/*	this is a table of meta files.
/*
/*	snap_shot() make sure that a "snapshot" exists. list is
/*	a null-terminated string of metafile suffix characters.
/*	This function returns a list with as terminator an entry
/*	with all zeros.
/*
/*	snap_junk() schedules a re-scan of the mail directory.
/* FILES
/*      mail header files in the spool directory
/* BUGS
/*      Since a message can be accessed only if its metafile exists,
/*	a message is "lost" when for some reason the metafile is
/*	not available.
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Sun Dec 17 19:52:12 MET 1989
/* LAST MODIFICATION
/*	90/01/22 13:02:38
/* VERSION/RELEASE
/*	2.1
/*--*/

#include <stdio.h>

#include "defs.h"
#include "path.h"
#include "ndir.h"
#include "snapshot.h"

#define	SNAP_ALLOC	200		/* growth increment of table */

hidden SNAP_SHOT *snap_table = 0;	/* at most 16k messages on a PC */
hidden int snap_used = 0;		/* nr of elements actually used */
hidden int snap_length = 0;		/* actual length of table */

/* snap_add - add message to snapshot table */

hidden void snap_add(msgno, prefix)
unsigned msgno;
char    prefix;
{
    /* myrealloc() accepts a null pointer */

    if (snap_used >= snap_length) {
	snap_length += SNAP_ALLOC;
	if ((snap_table = (SNAP_SHOT *) myrealloc((char *) snap_table,
				     snap_length * sizeof(snap_table))) == 0)
	    fatal("insufficient free memory for operation");
    }
    snap_table[snap_used].msgno = msgno;
    snap_table[snap_used].prefix = prefix;
    snap_used++;
}

/* snap_build - record meta files in the mail directory */

hidden void snap_build(list)
char   *list;
{
    DIR    *dp;				/* dir search id */
    register struct direct *de;		/* directory entry */
    unsigned msgno;			/* message sequence number */

    if (dp = opendir(maildir)) {
	while (de = readdir(dp)) {
	    if ((msgno = seqno(de->d_name)) && strchr(list, de->d_name[0]) != 0)
		snap_add(msgno, de->d_name[0]);
	}
	closedir(dp);
    }
    snap_add(0, 0);			/* add terminator */
}

/* snap_junk - schedule re-build of snapshot table */

public void snap_junk()
{
    snap_used = 0;
}

/* snap_shot - make sure snapshot table exists */

public SNAP_SHOT *snap_shot(list)
char   *list;
{
    if (snap_used == 0)
	snap_build(list);
     return(snap_table);
}
