/*++
/* NAME
/*	rmtname 3
/* SUMMARY
/*	mapping between local and remote spool-file names
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	cico
/* SYNOPSIS
/*	#include "params.h"
/*	#include "comm.h"
/*
/*	char *rmtname(type,msgno)
/*	int type;
/*	unsigned msgno;
/*
/*	char *locname(rname)
/*	char *rname;
/* DESCRIPTION
/*	locname() translates a remote spool-file name to one suitable
/*	for the local file system. Remote X.* file names are converted
/*	to the name of the local null device. All other remote file
/*	names are mapped to names of the form n<msgno> in the local
/*	spool directory.
/*
/*	rmtname() constructs a remote spool file name from its arguments,
/*	which are a sort of broken-down local spool file name.
/*	"type" specifies the type of file (Data or eXecute file).
/*	"msgno" holds a sequence number.
/*
/*	The output for D files is: D.<rmtsys>S<xseq>
/*
/*	The output for X files is: X.<thissys>X<xseq>
/*
/*	xseq is the four-digit hexadecimal representation of
/*	the sequence number in tail.
/* SEE ALSO
/*	getwork()
/* DIAGNOSTICS
/*	rmtname() returns via longjmp(systrap,E_CONFUSED) if its
/*	arguments are incorrect.
/* BUGS
/*	locname() and rmtname() store their result in a static area which
/*	is overwritten upon each call.
/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Thu Mar 26 14:08:07 GMT+1:00 1987
/* LAST MODIFICATION
/*	90/01/22 13:02:30
/* VERSION/RELEASE
/*	2.1
/*--*/

#include <stdio.h>

#include "defs.h"
#include "params.h"
#include "comm.h"
#include "logs.h"
#include "status.h"
#include "path.h"

hidden char buf[BUFSIZ];		/* storage for the result */

/* rmtname - map local spool file name to remote spool file name */

public char *rmtname(type, msgno)
int     type;
unsigned msgno;
{
    msgno &= 0xffff;				/* truncate to four hex digs */

    switch (type) {
    case 'd':					/* data file */
    case 'D':					/* data file */
	sprintf(buf, "D.%sS%04x", rmthost, msgno);
	return (buf);
    case 'x':					/* execute file */
    case 'X':					/* execute file */
	sprintf(buf, "X.%sX%04x", LOGIN_NAME, msgno);
	return (buf);
    default:					/* oops */
	trap(E_CONFUSED, "INTERNAL ERROR (unexpected file type: %c)", type);
	/* NOTREACHED */
    }
}

/* locname - map remote spool-file name to local name */

char   *locname(rname)
char   *rname;
{
    if (strncmp(rname, "X.", 2) == 0) {		/* X. files are ignored */
	return (NULLDEV);
    } else {					/* everything else is kept */
	return (new_mesg(newseqno()));
    }
}
